/*
 * Decompiled with CFR 0.152.
 */
package fabric.org.figuramc.figura.gui.widgets.avatar;

import fabric.org.figuramc.figura.FiguraMod;
import fabric.org.figuramc.figura.avatar.local.LocalAvatarFetcher;
import fabric.org.figuramc.figura.gui.FiguraToast;
import fabric.org.figuramc.figura.gui.widgets.AbstractContainerElement;
import fabric.org.figuramc.figura.gui.widgets.Button;
import fabric.org.figuramc.figura.gui.widgets.ContextMenu;
import fabric.org.figuramc.figura.gui.widgets.avatar.AvatarFolderWidget;
import fabric.org.figuramc.figura.gui.widgets.avatar.AvatarWidget;
import fabric.org.figuramc.figura.gui.widgets.lists.AvatarList;
import fabric.org.figuramc.figura.utils.FiguraText;
import fabric.org.figuramc.figura.utils.ui.UIHelper;
import java.nio.file.Path;
import java.util.Objects;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_5348;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractAvatarWidget
extends AbstractContainerElement
implements Comparable<AbstractAvatarWidget> {
    protected static final int SPACING = 6;
    protected static final class_2561 FAVOURITE = class_2561.method_43470((String)"\u2605").method_27696(class_2583.field_24360.method_27704(UIHelper.UI_FONT).method_10977(class_124.field_1054));
    protected static final class_2561 ADD_FAVOURITE = FiguraText.of("gui.context.favorite.add");
    protected static final class_2561 REMOVE_FAVOURITE = FiguraText.of("gui.context.favorite.remove");
    protected final AvatarList parent;
    protected final int depth;
    protected final ContextMenu context;
    protected LocalAvatarFetcher.AvatarPath avatar;
    protected Button button;
    protected String filter = "";
    protected boolean favourite;

    public AbstractAvatarWidget(int depth, int width, int height, LocalAvatarFetcher.AvatarPath avatar, AvatarList parent) {
        super(0, 0, width, height);
        this.parent = parent;
        this.avatar = avatar;
        this.depth = depth;
        this.context = new ContextMenu((class_364)this);
        this.favourite = avatar.isFavourite();
        this.context.addAction(this.favourite ? REMOVE_FAVOURITE : ADD_FAVOURITE, null, button -> {
            this.favourite = !this.favourite;
            avatar.setFavourite(this.favourite);
            button.method_25355(this.favourite ? REMOVE_FAVOURITE : ADD_FAVOURITE);
            this.context.updateDimensions();
        });
        this.context.addAction((class_2561)FiguraText.of("gui.context.open_folder"), null, button -> {
            try {
                class_156.method_668().method_673(avatar.getFSPath().toUri());
            }
            catch (Exception e) {
                FiguraMod.debug("failed to open avatar folder: ", e.getMessage());
                class_156.method_668().method_673(LocalAvatarFetcher.getLocalAvatarDirectory().toUri());
            }
        });
        this.context.addAction((class_2561)FiguraText.of("gui.context.copy_path"), null, button -> {
            class_310.method_1551().field_1774.method_1455(avatar.getFSPath().toString());
            FiguraToast.sendToast(FiguraText.of("toast.clipboard"));
        });
    }

    @Override
    public void method_25394(class_332 gui, int mouseX, int mouseY, float delta) {
        if (!this.isVisible() || !this.button.isVisible()) {
            return;
        }
        super.method_25394(gui, mouseX, mouseY, delta);
        if (this.favourite) {
            class_327 font = class_310.method_1551().field_1772;
            int width = font.method_27525((class_5348)FAVOURITE);
            int x = this.method_46426() + this.method_25368() - width;
            int y = this.method_46427() + 2;
            gui.method_51439(font, FAVOURITE, x, y, 0xFFFFFF, false);
            if (mouseX >= x && mouseX < x + width && mouseY >= y) {
                Objects.requireNonNull(font);
                if (mouseY < y + 9) {
                    UIHelper.setTooltip((class_2561)FiguraText.of("gui.favorited").method_27693(" ").method_10852(FAVOURITE));
                }
            }
        }
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (!this.method_25405(mouseX, mouseY)) {
            return false;
        }
        if (super.method_25402(mouseX, mouseY, button)) {
            return true;
        }
        if (button == 1) {
            this.context.method_46421((int)mouseX);
            this.context.method_46419((int)mouseY);
            this.context.setVisible(true);
            UIHelper.setContext(this.context);
            return true;
        }
        if (UIHelper.getContext() == this.context) {
            this.context.setVisible(false);
        }
        return false;
    }

    @Override
    public boolean method_25405(double mouseX, double mouseY) {
        return this.parent.isInsideScissors(mouseX, mouseY) && super.method_25405(mouseX, mouseY);
    }

    public void update(LocalAvatarFetcher.AvatarPath path, String filter) {
        this.avatar = path;
        this.filter = filter.toLowerCase();
    }

    public class_2561 getName() {
        return class_2561.method_43470((String)this.avatar.getName());
    }

    @Override
    public void method_46421(int x) {
        super.method_46421(x);
        this.button.method_46421(x);
    }

    @Override
    public void method_46419(int y) {
        super.method_46419(y);
        this.button.method_46419(y);
    }

    public boolean filtered() {
        return this.getName().getString().toLowerCase().contains(this.filter.toLowerCase());
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible && this.filtered());
    }

    @Override
    public int compareTo(@NotNull AbstractAvatarWidget other) {
        if (this.favourite && !other.favourite) {
            return -1;
        }
        if (other.favourite && !this.favourite) {
            return 1;
        }
        if (this instanceof AvatarFolderWidget && other instanceof AvatarWidget) {
            return -1;
        }
        if (this instanceof AvatarWidget && other instanceof AvatarFolderWidget) {
            return 1;
        }
        return this.getName().getString().toLowerCase().compareTo(other.getName().getString().toLowerCase());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (obj == this) return true;
        if (!(obj instanceof AbstractAvatarWidget)) return false;
        AbstractAvatarWidget other = (AbstractAvatarWidget)obj;
        if (other.avatar == null) return false;
        if (this.avatar == null) return false;
        if (!this.avatar.getPath().equals(other.avatar.getPath())) return false;
        return true;
    }

    public boolean isOf(Path path) {
        return this.avatar != null && this.avatar.getTheActualPathForThis().equals(path);
    }
}

