/*
 * Decompiled with CFR 0.152.
 */
package fabric.org.figuramc.figura.gui.screens;

import fabric.org.figuramc.figura.FiguraMod;
import fabric.org.figuramc.figura.avatar.AvatarManager;
import fabric.org.figuramc.figura.gui.FiguraToast;
import fabric.org.figuramc.figura.gui.screens.AbstractPanelScreen;
import fabric.org.figuramc.figura.gui.widgets.Button;
import fabric.org.figuramc.figura.gui.widgets.EntityPreview;
import fabric.org.figuramc.figura.gui.widgets.SliderWidget;
import fabric.org.figuramc.figura.gui.widgets.SwitchButton;
import fabric.org.figuramc.figura.gui.widgets.lists.PermissionsList;
import fabric.org.figuramc.figura.gui.widgets.lists.PlayerList;
import fabric.org.figuramc.figura.gui.widgets.permissions.AbstractPermPackElement;
import fabric.org.figuramc.figura.gui.widgets.permissions.PlayerPermPackElement;
import fabric.org.figuramc.figura.permissions.PermissionManager;
import fabric.org.figuramc.figura.permissions.PermissionPack;
import fabric.org.figuramc.figura.permissions.Permissions;
import fabric.org.figuramc.figura.utils.FiguraIdentifier;
import fabric.org.figuramc.figura.utils.FiguraText;
import fabric.org.figuramc.figura.utils.MathUtils;
import fabric.org.figuramc.figura.utils.ui.UIHelper;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.class_1309;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_638;

public class PermissionsScreen
extends AbstractPanelScreen {
    private PlayerList playerList;
    private EntityPreview entityWidget;
    private SliderWidget slider;
    private PermissionsList permissionsList;
    private SwitchButton expandButton;
    private Button reloadAll;
    private Button back;
    private Button resetButton;
    private SwitchButton precisePermissions;
    private float listYPrecise;
    private float expandYPrecise;
    private float resetYPrecise;
    private boolean expanded;
    private PlayerPermPackElement dragged = null;

    public PermissionsScreen(class_437 parentScreen) {
        super(parentScreen, (class_2561)FiguraText.of("gui.panels.title.permissions"));
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        int middle = this.field_22789 / 2;
        int listWidth = Math.min(middle - 6, 208);
        Objects.requireNonNull(this.field_22793);
        int lineHeight = 9;
        int entitySize = (int)Math.min((double)(this.field_22790 - 95) - (double)lineHeight * 1.5 - (double)(FiguraMod.debugModeEnabled() ? 24 : 0), (double)listWidth);
        int modelSize = 11 * entitySize / 29;
        int entityX = Math.max(middle + (listWidth - entitySize) / 2 + 1, middle + 2);
        this.entityWidget = new EntityPreview(entityX, 28, entitySize, entitySize, modelSize, -15.0f, 30.0f, (class_1309)class_310.method_1551().field_1724, this);
        this.slider = new SliderWidget(middle + 2, (int)((double)(this.entityWidget.method_46427() + this.entityWidget.method_25364()) + (double)lineHeight * 1.5 + 20.0), listWidth, 11, 1.0, 5, true){

            @Override
            public void method_48579(class_332 gui, int mouseX, int mouseY, float delta) {
                super.method_48579(gui, mouseX, mouseY, delta);
                PermissionPack selectedPack = PermissionsScreen.this.playerList.selectedEntry.getPack();
                class_5250 text = selectedPack.getCategoryName();
                int x = (int)((float)this.method_46426() + (float)this.method_25368() / 2.0f - (float)PermissionsScreen.this.field_22793.method_27525((class_5348)text) * 0.75f);
                int n = this.method_46427() - 4;
                Objects.requireNonNull(PermissionsScreen.this.field_22793);
                int y = n - 9 * 2;
                class_4587 pose = gui.method_51448();
                pose.method_22903();
                pose.method_46416((float)x, (float)y, 0.0f);
                pose.method_22905(1.5f, 1.5f, 1.0f);
                UIHelper.renderOutlineText(gui, PermissionsScreen.this.field_22793, (class_2561)text, 0, 0, 0xFFFFFF, 0x202020);
                pose.method_22909();
                class_5250 info = class_2561.method_43470((String)"?").method_27696(class_2583.field_24360.method_27704(UIHelper.UI_FONT));
                int color = 0x404040;
                int width = PermissionsScreen.this.field_22793.method_27525((class_5348)info);
                x = Math.min((int)((float)x + (float)PermissionsScreen.this.field_22793.method_27525((class_5348)text) * 1.5f + (float)PermissionsScreen.this.field_22793.method_1727("  ")), PermissionsScreen.this.field_22789 - width);
                float f = y;
                Objects.requireNonNull(PermissionsScreen.this.field_22793);
                y = (int)(f + 9.0f * 0.25f);
                Objects.requireNonNull(PermissionsScreen.this.field_22793);
                if (UIHelper.isMouseOver(x, y, width, 9, mouseX, mouseY)) {
                    color = 0xFFFFFF;
                    UIHelper.setTooltip((class_2561)selectedPack.getCategory().info);
                }
                gui.method_27535(PermissionsScreen.this.field_22793, (class_2561)info, x, y, color);
            }
        };
        this.permissionsList = new PermissionsList(middle + 2, this.field_22790, listWidth, this.field_22790 - 54);
        this.playerList = new PlayerList(middle - listWidth - 2, 28, listWidth, this.field_22790 - 32, this);
        this.method_37063((class_364)this.playerList);
        this.method_37063((class_364)this.entityWidget);
        this.method_37063((class_364)this.slider);
        int bottomButtonsWidth = (listWidth - 24) / 2 - 2;
        this.reloadAll = new Button(middle + 2, this.field_22790 - 24, bottomButtonsWidth, 20, (class_2561)FiguraText.of("gui.permissions.reload_all"), null, bx -> {
            AvatarManager.clearAllAvatars();
            FiguraToast.sendToast(FiguraText.of("toast.reload_all"));
        });
        this.method_37063((class_364)this.reloadAll);
        this.back = new Button(middle + 6 + bottomButtonsWidth, this.field_22790 - 24, bottomButtonsWidth, 20, (class_2561)FiguraText.of("gui.done"), null, bx -> this.method_25419());
        this.method_37063((class_364)this.back);
        this.expandButton = new SwitchButton(middle + listWidth - 18, this.field_22790 - 24, 20, 20, 0, 0, 20, new FiguraIdentifier("textures/gui/expand_v.png"), 60, 40, (class_2561)FiguraText.of("gui.permissions.expand_permissions.tooltip"), btn -> {
            this.expanded = this.expandButton.isToggled();
            this.entityWidget.setVisible(!this.expanded);
            this.slider.setVisible(!this.expanded);
            this.slider.setActive(!this.expanded);
            this.reloadAll.setVisible(!this.expanded);
            this.back.setVisible(!this.expanded);
            this.expandButton.setTooltip((class_2561)(this.expanded ? FiguraText.of("gui.permissions.minimize_permissions.tooltip") : FiguraText.of("gui.permissions.expand_permissions.tooltip")));
            this.resetButton.setActive(this.expanded);
        });
        this.method_37063((class_364)this.expandButton);
        this.resetButton = new Button(middle + 2, this.field_22790, 60, 20, (class_2561)FiguraText.of("gui.permissions.reset"), null, btn -> {
            PermissionPack pack = this.playerList.selectedEntry.getPack();
            pack.clear();
            this.updatePermissions(pack);
        });
        this.method_37063((class_364)this.resetButton);
        this.precisePermissions = new SwitchButton(middle + 66, this.field_22790, listWidth - 88, 20, (class_2561)FiguraText.of("gui.permissions.precise"), false){

            @Override
            public void method_25306() {
                super.method_25306();
                PermissionsScreen.this.permissionsList.precise = this.isToggled();
                PermissionsScreen.this.permissionsList.updateList(PermissionsScreen.this.playerList.selectedEntry.getPack());
            }
        };
        this.method_37063((class_364)this.precisePermissions);
        this.precisePermissions.setUnderline(false);
        this.method_37063((class_364)this.permissionsList);
        this.listYPrecise = this.permissionsList.method_46427();
        this.expandYPrecise = this.expandButton.method_46427();
        this.resetYPrecise = this.resetButton.method_46427();
    }

    @Override
    public void method_25394(class_332 gui, int mouseX, int mouseY, float delta) {
        AbstractPermPackElement entity = this.playerList.selectedEntry;
        class_638 world = class_310.method_1551().field_1687;
        if (world != null && entity instanceof PlayerPermPackElement) {
            PlayerPermPackElement player = (PlayerPermPackElement)entity;
            this.entityWidget.setEntity((class_1309)world.method_18470(UUID.fromString(player.getPack().name)));
        } else {
            this.entityWidget.setEntity(null);
        }
        float lerpDelta = MathUtils.magicDelta(0.6f, delta);
        this.listYPrecise = class_3532.method_16439((float)lerpDelta, (float)this.listYPrecise, (float)(this.expandButton.isToggled() ? 50.0f : (float)(this.field_22790 + 1)));
        this.permissionsList.method_46419((int)this.listYPrecise);
        this.expandYPrecise = class_3532.method_16439((float)lerpDelta, (float)this.expandYPrecise, (float)(this.expandButton.isToggled() ? this.listYPrecise - 22.0f : this.listYPrecise - 24.0f));
        this.expandButton.method_46419((int)this.expandYPrecise);
        this.resetYPrecise = class_3532.method_16439((float)lerpDelta, (float)this.resetYPrecise, (float)(this.expandButton.isToggled() ? this.listYPrecise - 22.0f : (float)this.field_22790));
        this.resetButton.method_46419((int)this.resetYPrecise);
        this.precisePermissions.method_46419((int)this.resetYPrecise);
        super.method_25394(gui, mouseX, mouseY, delta);
    }

    @Override
    public void renderOverlays(class_332 gui, int mouseX, int mouseY, float delta) {
        if (this.dragged != null && this.dragged.dragged) {
            this.dragged.renderDragged(gui, mouseX, mouseY, delta);
        }
        super.renderOverlays(gui, mouseX, mouseY, delta);
    }

    public void method_25432() {
        PermissionManager.saveToDisk();
        super.method_25432();
    }

    @Override
    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256 && this.expandButton.isToggled()) {
            this.expandButton.method_25306();
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int button) {
        PlayerPermPackElement element;
        AbstractPermPackElement abstractPermPackElement;
        boolean bool = super.method_25402(mouseX, mouseY, button);
        this.dragged = null;
        if (button == 0 && (abstractPermPackElement = this.playerList.selectedEntry) instanceof PlayerPermPackElement && (element = (PlayerPermPackElement)abstractPermPackElement).method_25405(mouseX, mouseY)) {
            this.dragged = element;
            element.anchorX = (int)mouseX;
            element.anchorY = (int)mouseY;
            element.initialY = element.method_46427();
        }
        return bool;
    }

    @Override
    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.dragged != null) {
            this.dragged.index = this.playerList.getCategoryAt(mouseY);
            this.dragged.dragged = true;
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    @Override
    public boolean method_25406(double mouseX, double mouseY, int button) {
        boolean bool = super.method_25406(mouseX, mouseY, button);
        if (this.dragged == null || !this.dragged.dragged) {
            return bool;
        }
        PermissionPack pack = this.dragged.getPack();
        Permissions.Category category = Permissions.Category.indexOf(Math.min(this.dragged.index, Permissions.Category.values().length - 1));
        pack.setCategory(PermissionManager.CATEGORIES.get((Object)category));
        this.updatePermissions(pack);
        this.dragged.dragged = false;
        this.dragged = null;
        return bool;
    }

    public void updatePermissions(PermissionPack pack) {
        this.slider.setAction(null);
        this.slider.setActive(pack instanceof PermissionPack.PlayerPermissionPack && !this.expanded);
        this.slider.setMax(Permissions.Category.values().length);
        this.slider.setScrollProgress((double)pack.getCategory().index / ((double)this.slider.getMax() - 1.0));
        this.slider.setAction(scroll -> {
            Permissions.Category category = Permissions.Category.indexOf(((SliderWidget)scroll).getIntValue());
            pack.setCategory(PermissionManager.CATEGORIES.get((Object)category));
            this.permissionsList.updateList(pack);
        });
        this.permissionsList.updateList(pack);
    }
}

