/*
 * Decompiled with CFR 0.152.
 */
package fabric.org.figuramc.figura.commands;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import fabric.org.figuramc.figura.FiguraMod;
import fabric.org.figuramc.figura.avatar.Avatar;
import fabric.org.figuramc.figura.avatar.AvatarManager;
import fabric.org.figuramc.figura.backend2.BackendCommands;
import fabric.org.figuramc.figura.commands.DebugCommand;
import fabric.org.figuramc.figura.commands.EmojiListCommand;
import fabric.org.figuramc.figura.commands.ExportCommand;
import fabric.org.figuramc.figura.commands.LinkCommand;
import fabric.org.figuramc.figura.commands.LoadCommand;
import fabric.org.figuramc.figura.commands.ReloadCommand;
import fabric.org.figuramc.figura.commands.RunCommand;
import fabric.org.figuramc.figura.lua.FiguraLuaRuntime;
import fabric.org.figuramc.figura.lua.docs.FiguraDocsManager;
import fabric.org.figuramc.figura.model.rendering.AvatarRenderer;
import fabric.org.figuramc.figura.utils.FiguraClientCommandSource;
import fabric.org.figuramc.figura.utils.FiguraText;
import net.minecraft.class_2561;

public class FiguraCommands {
    public static LiteralArgumentBuilder<FiguraClientCommandSource> getCommandRoot() {
        LiteralArgumentBuilder root = LiteralArgumentBuilder.literal((String)"figura");
        root.then(FiguraDocsManager.getCommand());
        root.then(LinkCommand.getCommand());
        root.then(RunCommand.getCommand());
        root.then(LoadCommand.getCommand());
        root.then(ReloadCommand.getCommand());
        root.then(DebugCommand.getCommand());
        root.then(ExportCommand.getCommand());
        if (FiguraMod.debugModeEnabled()) {
            root.then(BackendCommands.getCommand());
            root.then(AvatarManager.getCommand());
        }
        root.then(EmojiListCommand.getCommand());
        return root;
    }

    protected static Avatar checkAvatar(CommandContext<FiguraClientCommandSource> context) {
        Avatar avatar = AvatarManager.getAvatarForPlayer(FiguraMod.getLocalPlayerUUID());
        if (avatar == null) {
            ((FiguraClientCommandSource)context.getSource()).figura$sendError((class_2561)FiguraText.of("command.no_avatar_error"));
            return null;
        }
        return avatar;
    }

    protected static FiguraLuaRuntime getRuntime(CommandContext<FiguraClientCommandSource> context) {
        Avatar avatar = FiguraCommands.checkAvatar(context);
        if (avatar == null) {
            return null;
        }
        if (avatar.luaRuntime == null || avatar.scriptError) {
            ((FiguraClientCommandSource)context.getSource()).figura$sendError((class_2561)FiguraText.of("command.no_script_error"));
            return null;
        }
        return avatar.luaRuntime;
    }

    protected static AvatarRenderer getRenderer(CommandContext<FiguraClientCommandSource> context) {
        Avatar avatar = FiguraCommands.checkAvatar(context);
        if (avatar == null) {
            return null;
        }
        if (avatar.renderer == null) {
            ((FiguraClientCommandSource)context.getSource()).figura$sendError((class_2561)FiguraText.of("command.no_renderer_error"));
            return null;
        }
        return avatar.renderer;
    }
}

