/*
 * Decompiled with CFR 0.152.
 */
package fabric.org.figuramc.figura.backend2;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.datafixers.util.Pair;
import fabric.org.figuramc.figura.FiguraMod;
import fabric.org.figuramc.figura.avatar.Avatar;
import fabric.org.figuramc.figura.avatar.AvatarManager;
import fabric.org.figuramc.figura.avatar.Badges;
import fabric.org.figuramc.figura.avatar.UserData;
import fabric.org.figuramc.figura.avatar.local.CacheAvatarLoader;
import fabric.org.figuramc.figura.backend2.AuthHandler;
import fabric.org.figuramc.figura.backend2.HttpAPI;
import fabric.org.figuramc.figura.backend2.websocket.C2SMessageHandler;
import fabric.org.figuramc.figura.backend2.websocket.WebsocketThingy;
import fabric.org.figuramc.figura.config.Configs;
import fabric.org.figuramc.figura.font.Emojis;
import fabric.org.figuramc.figura.gui.FiguraToast;
import fabric.org.figuramc.figura.permissions.PermissionManager;
import fabric.org.figuramc.figura.permissions.Permissions;
import fabric.org.figuramc.figura.utils.FiguraText;
import fabric.org.figuramc.figura.utils.RefilledNumber;
import fabric.org.figuramc.figura.utils.TextUtils;
import fabric.org.figuramc.figura.utils.Version;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_156;
import net.minecraft.class_2487;
import net.minecraft.class_2507;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_634;
import org.jetbrains.annotations.Nullable;

public class NetworkStuff {
    protected static final HttpClient client = HttpClient.newHttpClient();
    protected static final Gson GSON = new GsonBuilder().disableHtmlEscaping().create();
    private static final ConcurrentLinkedQueue<Request<HttpAPI>> API_REQUESTS = new ConcurrentLinkedQueue();
    private static final ConcurrentLinkedQueue<Request<WebsocketThingy>> WS_REQUESTS = new ConcurrentLinkedQueue();
    private static final List<UUID> SUBSCRIPTIONS = new ArrayList<UUID>();
    private static CompletableFuture<Void> tasks;
    private static final int RECONNECT = 6000;
    private static int authCheck;
    protected static HttpAPI api;
    protected static WebsocketThingy ws;
    public static int backendStatus;
    public static String disconnectedReason;
    public static boolean debug;
    @Nullable
    public static class_2561 motd;
    public static int lastPing;
    public static int pingsSent;
    public static int pingsReceived;
    public static Version latestVersion;
    private static final RefilledNumber uploadRate;
    private static final RefilledNumber downloadRate;
    private static int maxAvatarSize;

    public static void tick() {
        uploadRate.tick();
        downloadRate.tick();
        if (--authCheck <= 0) {
            authCheck = 6000;
            if (!NetworkStuff.isConnected()) {
                NetworkStuff.reAuth();
            } else if (!NetworkStuff.checkWS()) {
                NetworkStuff.reAuth();
            } else {
                NetworkStuff.checkAPI();
            }
        }
        NetworkStuff.tickSubscriptions();
        if (NetworkStuff.isConnected()) {
            NetworkStuff.processRequests();
        }
        if (lastPing > 0 && FiguraMod.ticks - lastPing >= 20) {
            pingsReceived = 0;
            pingsSent = 0;
            lastPing = 0;
        }
    }

    private static void tickSubscriptions() {
        class_634 connection = class_310.method_1551().method_1562();
        if (connection == null) {
            NetworkStuff.unsubscribeAll();
            return;
        }
        ArrayList<UUID> unsub = new ArrayList<UUID>(SUBSCRIPTIONS);
        for (UUID uuid : connection.method_31363()) {
            unsub.remove(uuid);
            if (SUBSCRIPTIONS.contains(uuid)) continue;
            SUBSCRIPTIONS.add(uuid);
            NetworkStuff.subscribe(uuid);
        }
        for (UUID uuid : unsub) {
            SUBSCRIPTIONS.remove(uuid);
            NetworkStuff.unsubscribe(uuid);
        }
    }

    private static void processRequests() {
        Request<HttpAPI> finalRequest;
        Request<Object> request;
        if (!API_REQUESTS.isEmpty()) {
            while ((request = API_REQUESTS.poll()) != null) {
                finalRequest = request;
                NetworkStuff.async(() -> finalRequest.consumer.accept(api));
            }
        }
        if (!WS_REQUESTS.isEmpty()) {
            while ((request = WS_REQUESTS.poll()) != null) {
                finalRequest = request;
                NetworkStuff.async(() -> finalRequest.consumer.accept(ws));
            }
        }
    }

    protected static void async(Runnable toRun) {
        if (tasks == null || tasks.isDone()) {
            tasks = CompletableFuture.runAsync(toRun);
        } else {
            tasks.thenRun(toRun);
        }
    }

    private static boolean checkUUID(UUID id) {
        if (id.version() != 4) {
            FiguraMod.debug("Voiding request for non v4 UUID \"" + String.valueOf(id) + "\" (v" + id.version() + ")", new Object[0]);
            return true;
        }
        return false;
    }

    public static void auth() {
        authCheck = 6000;
        AuthHandler.auth(false);
        NetworkStuff.fetchMOTD();
    }

    public static void reAuth() {
        authCheck = 6000;
        AuthHandler.auth(true);
        NetworkStuff.fetchMOTD();
    }

    protected static void authSuccess(String token) {
        FiguraMod.LOGGER.info("Successfully authed with the Figura auth server!");
        disconnectedReason = null;
        NetworkStuff.connect(token);
    }

    protected static void authFail(String reason) {
        FiguraMod.LOGGER.warn("Failed to auth with the Figura auth server! {}", (Object)(reason == null ? "" : reason));
        NetworkStuff.disconnect(reason);
    }

    public static void connect(String token) {
        if (NetworkStuff.isConnected()) {
            NetworkStuff.disconnect(null);
        }
        backendStatus = 2;
        NetworkStuff.connectAPI(token);
        NetworkStuff.connectWS(token);
    }

    private static void fetchMOTD() {
        NetworkStuff.queueString(class_156.field_25140, HttpAPI::getMotd, (code, data) -> {
            NetworkStuff.responseDebug("motd", code, data);
            if (data != null) {
                motd = Emojis.applyEmojis(TextUtils.tryParseJson(data));
            }
        });
    }

    public static void disconnect(String reason) {
        backendStatus = 1;
        disconnectedReason = reason;
        NetworkStuff.disconnectAPI();
        NetworkStuff.disconnectWS();
    }

    private static void queueString(UUID owner, Function<HttpAPI, HttpRequest> request, BiConsumer<Integer, String> consumer) {
        API_REQUESTS.add(new Request<HttpAPI>(owner, api -> HttpAPI.runString((HttpRequest)request.apply((HttpAPI)api), consumer)));
    }

    private static void queueStream(UUID owner, Function<HttpAPI, HttpRequest> request, BiConsumer<Integer, InputStream> consumer) {
        API_REQUESTS.add(new Request<HttpAPI>(owner, api -> HttpAPI.runStream((HttpRequest)request.apply((HttpAPI)api), consumer)));
    }

    public static void clear(UUID requestOwner) {
        API_REQUESTS.removeIf(request -> request.owner.equals(requestOwner));
    }

    private static void responseDebug(String src, int code, String data) {
        if (debug) {
            FiguraMod.debug("Got response of \"" + src + "\" with code " + code + ":\n\t" + data, new Object[0]);
        }
    }

    private static void connectAPI(String token) {
        api = new HttpAPI(token);
        NetworkStuff.checkVersion();
        NetworkStuff.setLimits();
    }

    private static void disconnectAPI() {
        api = null;
        NetworkStuff.clear(class_156.field_25140);
    }

    private static void checkAPI() {
        NetworkStuff.async(() -> {
            if (api == null) {
                NetworkStuff.reAuth();
                return;
            }
            HttpAPI.runString(api.checkAuth(), (code, data) -> {
                if (code != 200) {
                    NetworkStuff.reAuth();
                }
            });
        });
    }

    public static void checkVersion() {
        NetworkStuff.queueString(class_156.field_25140, HttpAPI::getVersion, (code, data) -> {
            NetworkStuff.responseDebug("checkVersion", code, data);
            JsonObject json = JsonParser.parseString((String)data).getAsJsonObject();
            latestVersion = new Version(json.get("prerelease").getAsString());
            int config = (Integer)Configs.UPDATE_CHANNEL.value;
            if (config != 0) {
                Version compare;
                Version version = compare = config == 1 ? new Version(json.get("release").getAsString()) : latestVersion;
                if (compare.compareTo(FiguraMod.VERSION) > 0) {
                    FiguraToast.sendToast((Object)FiguraText.of("toast.new_version"), compare);
                }
            }
        });
    }

    public static void setLimits() {
        NetworkStuff.queueString(class_156.field_25140, HttpAPI::getLimits, (code, data) -> {
            NetworkStuff.responseDebug("setLimits", code, data);
            JsonObject json = JsonParser.parseString((String)data).getAsJsonObject();
            JsonObject rate = json.getAsJsonObject("rate");
            uploadRate.set((double)rate.get("upload").getAsInt() * 0.95);
            downloadRate.set((double)rate.get("download").getAsInt() * 0.95);
            JsonObject limits = json.getAsJsonObject("limits");
            maxAvatarSize = limits.get("maxAvatarSize").getAsInt();
        });
    }

    public static void getUser(UserData user) {
        if (NetworkStuff.checkUUID(user.id)) {
            return;
        }
        NetworkStuff.queueString(user.id, api -> api.getUser(user.id), (code, data) -> {
            Permissions.Category cat;
            NetworkStuff.responseDebug("getUser", code, data);
            if (code != 200) {
                if (code == 404 && ((Boolean)Configs.CONNECTION_TOASTS.value).booleanValue()) {
                    FiguraToast.sendToast((Object)FiguraText.of("backend.user_not_found"), FiguraToast.ToastType.ERROR);
                }
                return;
            }
            JsonObject json = JsonParser.parseString((String)data).getAsJsonObject();
            ArrayList<Pair<String, Pair<String, UUID>>> avatars = new ArrayList<Pair<String, Pair<String, UUID>>>();
            JsonArray equippedAvatars = json.getAsJsonArray("equipped");
            for (JsonElement element : equippedAvatars) {
                JsonObject entry = element.getAsJsonObject();
                UUID owner = UUID.fromString(entry.get("owner").getAsString());
                avatars.add(Pair.of((Object)entry.get("hash").getAsString(), (Object)Pair.of((Object)entry.get("id").getAsString(), (Object)owner)));
            }
            JsonObject badges = json.getAsJsonObject("equippedBadges");
            Pair<BitSet, BitSet> badgesPair = Badges.emptyBadges();
            JsonArray pride = badges.getAsJsonArray("pride");
            BitSet prideSet = (BitSet)badgesPair.getFirst();
            for (int i = 0; i < pride.size(); ++i) {
                prideSet.set(i, pride.get(i).getAsInt() >= 1);
            }
            JsonArray special = badges.getAsJsonArray("special");
            BitSet specialSet = (BitSet)badgesPair.getSecond();
            for (int i = 0; i < special.size(); ++i) {
                specialSet.set(i, special.get(i).getAsInt() >= 1);
            }
            JsonElement trust = json.get("trust");
            if (trust != null && (cat = Permissions.Category.indexOf(trust.getAsInt())) != null) {
                PermissionManager.setDefaultFor(user.id, cat);
            }
            user.loadData(avatars, badgesPair);
        });
    }

    public static void uploadAvatar(Avatar avatar) {
        if (avatar == null || avatar.nbt == null) {
            return;
        }
        if (avatar.id != null) {
            // empty if block
        }
        String id = "avatar";
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            class_2507.method_10634((class_2487)avatar.nbt, (OutputStream)baos);
            NetworkStuff.queueString(class_156.field_25140, api -> api.uploadAvatar(id, baos.toByteArray()), (code, data) -> {
                NetworkStuff.responseDebug("uploadAvatar", code, data);
                if (code == 200) {
                    NetworkStuff.equipAvatar(List.of(Pair.of((Object)avatar.owner, (Object)id)));
                    AvatarManager.localUploaded = true;
                }
                switch (code) {
                    case 200: {
                        FiguraToast.sendToast(FiguraText.of("backend.upload_success"));
                        break;
                    }
                    case 413: {
                        FiguraToast.sendToast((Object)FiguraText.of("backend.upload_too_big"), FiguraToast.ToastType.ERROR);
                        break;
                    }
                    case 507: {
                        FiguraToast.sendToast((Object)FiguraText.of("backend.upload_too_many"), FiguraToast.ToastType.ERROR);
                        break;
                    }
                    default: {
                        FiguraToast.sendToast((Object)FiguraText.of("backend.upload_error"), FiguraToast.ToastType.ERROR);
                    }
                }
            });
            uploadRate.use();
            baos.close();
        }
        catch (Exception e) {
            FiguraMod.LOGGER.error("", (Throwable)e);
        }
    }

    public static void deleteAvatar(String avatar) {
        if (avatar != null) {
            // empty if block
        }
        String id = "avatar";
        NetworkStuff.queueString(class_156.field_25140, api -> api.deleteAvatar(id), (code, data) -> {
            NetworkStuff.responseDebug("deleteAvatar", code, data);
            switch (code) {
                case 200: {
                    FiguraToast.sendToast(FiguraText.of("backend.delete_success"));
                    break;
                }
                case 404: {
                    FiguraToast.sendToast((Object)FiguraText.of("backend.avatar_not_found"), FiguraToast.ToastType.ERROR);
                    break;
                }
                default: {
                    FiguraToast.sendToast((Object)FiguraText.of("backend.delete_error"), FiguraToast.ToastType.ERROR);
                }
            }
        });
    }

    public static void equipAvatar(List<Pair<UUID, String>> avatars) {
        JsonArray json = new JsonArray();
        for (Pair<UUID, String> avatar : avatars) {
            JsonObject obj = new JsonObject();
            obj.addProperty("owner", ((UUID)avatar.getFirst()).toString());
            obj.addProperty("id", (String)avatar.getSecond());
            json.add((JsonElement)obj);
        }
        NetworkStuff.queueString(class_156.field_25140, api -> api.setEquipped(GSON.toJson((JsonElement)json)), (code, data) -> {
            NetworkStuff.responseDebug("equipAvatar", code, data);
            if (code != 200 && ((Boolean)Configs.CONNECTION_TOASTS.value).booleanValue()) {
                FiguraToast.sendToast((Object)FiguraText.of("backend.equip_error"), FiguraToast.ToastType.ERROR);
            }
        });
    }

    public static void getAvatar(UserData target, UUID owner, String id, String hash) {
        if (NetworkStuff.checkUUID(target.id)) {
            return;
        }
        NetworkStuff.queueStream(target.id, api -> api.getAvatar(owner, id), (code, stream) -> {
            String s;
            try {
                s = code == 200 ? "<avatar data>" : new String(stream.readAllBytes());
            }
            catch (Exception e) {
                s = e.getMessage();
            }
            NetworkStuff.responseDebug("getAvatar", code, s);
            if (code != 200) {
                return;
            }
            try {
                class_2487 nbt = class_2507.method_10629((InputStream)stream);
                CacheAvatarLoader.save(hash, nbt);
                target.loadAvatar(nbt);
            }
            catch (Exception e) {
                FiguraMod.LOGGER.error("Failed to load avatar for " + String.valueOf(target.id), (Throwable)e);
            }
        });
        downloadRate.use();
    }

    private static void connectWS(String token) {
        if (ws != null) {
            ws.close();
        }
        ws = new WebsocketThingy(token);
        ws.connect();
    }

    private static void disconnectWS() {
        if (ws != null) {
            ws.close();
        }
        ws = null;
    }

    private static boolean checkWS() {
        return ws != null && ws.isOpen() && backendStatus == 3;
    }

    public static void sendPing(int id, boolean sync, byte[] data) {
        if (!AvatarManager.localUploaded || !NetworkStuff.isConnected()) {
            return;
        }
        try {
            ByteBuffer buffer = C2SMessageHandler.ping(id, sync, data);
            ws.send(buffer);
            ++pingsSent;
            if (lastPing == 0) {
                lastPing = FiguraMod.ticks;
            }
        }
        catch (Exception e) {
            FiguraMod.LOGGER.error("Failed to send ping", (Throwable)e);
        }
    }

    private static void subscribe(UUID id) {
        if (NetworkStuff.checkUUID(id) || !NetworkStuff.checkWS()) {
            return;
        }
        WS_REQUESTS.add(new Request<WebsocketThingy>(class_156.field_25140, client -> {
            try {
                ByteBuffer buffer = C2SMessageHandler.sub(id);
                client.send(buffer);
                if (debug) {
                    FiguraMod.debug("Subbed to " + String.valueOf(id), new Object[0]);
                }
            }
            catch (Exception e) {
                FiguraMod.LOGGER.error("Failed to subscribe to " + String.valueOf(id), (Throwable)e);
            }
        }));
    }

    private static void unsubscribe(UUID id) {
        if (NetworkStuff.checkUUID(id) || !NetworkStuff.checkWS()) {
            return;
        }
        WS_REQUESTS.add(new Request<WebsocketThingy>(class_156.field_25140, client -> {
            try {
                ByteBuffer buffer = C2SMessageHandler.unsub(id);
                client.send(buffer);
                if (debug) {
                    FiguraMod.debug("Unsubbed to " + String.valueOf(id), new Object[0]);
                }
            }
            catch (Exception e) {
                FiguraMod.LOGGER.error("Failed to unsubscribe to " + String.valueOf(id), (Throwable)e);
            }
        }));
    }

    public static void subscribeAll() {
        for (UUID uuid : SUBSCRIPTIONS) {
            NetworkStuff.subscribe(uuid);
        }
    }

    public static void unsubscribeAll() {
        for (UUID uuid : SUBSCRIPTIONS) {
            NetworkStuff.unsubscribe(uuid);
        }
        SUBSCRIPTIONS.clear();
    }

    private static InputStream request(HttpRequest request) throws Exception {
        HttpResponse<InputStream> response = client.send(request, HttpResponse.BodyHandlers.ofInputStream());
        return response.body();
    }

    public static InputStream getResourcesHashes(String version) throws Exception {
        return NetworkStuff.request(HttpRequest.newBuilder(HttpAPI.getUri("/assets/" + version)).timeout(Duration.ofSeconds(15L)).build());
    }

    public static InputStream getResource(String version, String resource) throws Exception {
        return NetworkStuff.request(HttpRequest.newBuilder(HttpAPI.getUri("/assets/" + version + "/" + resource)).build());
    }

    public static boolean isConnected() {
        return api != null && NetworkStuff.checkWS();
    }

    public static boolean canUpload() {
        return NetworkStuff.isConnected() && uploadRate.check();
    }

    public static int getSizeLimit() {
        return NetworkStuff.isConnected() ? maxAvatarSize : Integer.MAX_VALUE;
    }

    static {
        authCheck = 6000;
        backendStatus = 1;
        debug = false;
        uploadRate = new RefilledNumber();
        downloadRate = new RefilledNumber();
        maxAvatarSize = Integer.MAX_VALUE;
    }

    private record Request<T>(UUID owner, Consumer<T> consumer) {
        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Request)) return false;
            Request request = (Request)o;
            if (!this.owner.equals(request.owner)) return false;
            return true;
        }
    }
}

