/*
 * Decompiled with CFR 0.152.
 */
package elocindev.necronomicon.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import elocindev.necronomicon.config.Comment;
import elocindev.necronomicon.config.Comments;
import elocindev.necronomicon.config.NecConfig;
import elocindev.necronomicon.config.NestedConfig;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.StringJoiner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"necronomicon");
    private static final Gson BUILDER = new GsonBuilder().setPrettyPrinting().create();

    public static <T> T registerConfig(Path file, Class<T> configClass) {
        try {
            String json;
            if (Files.notExists(file, new LinkOption[0])) {
                T defaultConfig;
                try {
                    LOGGER.info("Creating default config file for " + configClass.getName() + ".");
                    defaultConfig = configClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to create an instance of the config class.", e);
                }
                ConfigBuilder.processNestedConfigs(defaultConfig, configClass);
                String defaultJson = BUILDER.toJson(defaultConfig);
                StringBuffer buffer = new StringBuffer(defaultJson);
                for (Field field : configClass.getDeclaredFields()) {
                    if (field.isAnnotationPresent(Comments.class)) {
                        for (Comment comment : field.getAnnotation(Comments.class).value()) {
                            ConfigBuilder.insertComment(buffer, field.getName(), comment.value());
                        }
                        continue;
                    }
                    if (!field.isAnnotationPresent(Comment.class)) continue;
                    String comment = field.getAnnotation(Comment.class).value();
                    ConfigBuilder.insertComment(buffer, field.getName(), comment);
                }
                Files.writeString(file, (CharSequence)buffer.toString(), new OpenOption[0]);
                return defaultConfig;
            }
            try {
                LOGGER.info("File exists, reading config for " + configClass.getName() + ".");
                json = Files.readString(file);
                LOGGER.info("Config for " + configClass.getName() + " read successfully.");
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to read the config file " + file.getFileName().toString(), e);
            }
            String withoutComments = ConfigBuilder.preprocessJson(json);
            Object configEntries = BUILDER.fromJson(withoutComments, configClass);
            ConfigBuilder.processNestedConfigs(configEntries, configClass);
            return (T)configEntries;
        }
        catch (Exception e) {
            throw new RuntimeException(file.getFileName().toString() + " - Failed to register config, it is likely that you added invalid entries in your config, or that the formatting isn't valid.", e);
        }
    }

    public static <T> void initializeConfigs(Class<T> configClass) {
        Field[] fields;
        for (Field field : fields = configClass.getDeclaredFields()) {
            if (!field.isAnnotationPresent(NecConfig.class)) continue;
            try {
                if (field.getType() != configClass) continue;
                field.setAccessible(true);
                String filePath = (String)field.getType().getMethod("getFile", new Class[0]).invoke(null, new Object[0]);
                Path file = Paths.get(filePath, new String[0]);
                Object configInstance = ConfigBuilder.registerConfig(file, field.getType());
                field.set(field, configInstance);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to initialize config field: " + field.getName(), e);
            }
        }
    }

    private static void insertComment(StringBuffer jsonBuffer, String fieldName, String comment) {
        String searchString = "\"" + fieldName + "\":";
        int fieldIndex = jsonBuffer.indexOf(searchString);
        if (fieldIndex == -1) {
            return;
        }
        int lineStartIndex = jsonBuffer.lastIndexOf("\n", fieldIndex) + 1;
        String commentString = "  // " + comment + "\n";
        jsonBuffer.insert(lineStartIndex, commentString);
    }

    private static String preprocessJson(String json) {
        String[] lines;
        StringJoiner sj = new StringJoiner("\n");
        for (String line : lines = json.split("\n")) {
            String trimmedLine = line.trim();
            if (trimmedLine.startsWith("//")) continue;
            sj.add(line);
        }
        return sj.toString();
    }

    private static <T> void processNestedConfigs(T configInstance, Class<?> configClass) {
        for (Field field : configClass.getDeclaredFields()) {
            if (!field.isAnnotationPresent(NestedConfig.class)) continue;
            field.setAccessible(true);
            try {
                Object nestedConfig = field.get(configInstance);
                if (nestedConfig == null) {
                    nestedConfig = field.getType().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    field.set(configInstance, nestedConfig);
                }
                ConfigBuilder.processNestedConfigs(nestedConfig, field.getType());
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to process nested config field: " + field.getName(), e);
            }
        }
    }
}

