/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.mixin.enchantment;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.Iterator;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import party.lemons.biomemakeover.init.BMEnchantments;
import party.lemons.biomemakeover.item.enchantment.TickableAttributeEnchantment;
import party.lemons.taniwha.util.ItemUtil;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends Entity {
    @Unique
    private final Collection<Pair<EquipmentSlot, ItemStack>> attributeStacks = Lists.newArrayList();

    public LivingEntityMixin(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(at={@At(value="TAIL")}, method={"tick"})
    public void tick(CallbackInfo cbi) {
        if (!this.m_9236_().m_5776_()) {
            Iterator<Pair<EquipmentSlot, ItemStack>> it = this.attributeStacks.iterator();
            while (it.hasNext()) {
                Pair<EquipmentSlot, ItemStack> pair = it.next();
                ItemStack st2 = (ItemStack)pair.getSecond();
                if (this.hasStackEquipInSlot(st2, (EquipmentSlot)pair.getFirst())) continue;
                ItemUtil.forEachEnchantment((en, stack, lvl) -> {
                    if (en instanceof TickableAttributeEnchantment) {
                        ((TickableAttributeEnchantment)en).removeAttributes((LivingEntity)this, (EquipmentSlot)pair.getFirst());
                    }
                }, (ItemStack)st2, (boolean)true);
                it.remove();
            }
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                ItemStack stack2 = this.m_6844_(slot);
                if (stack2.m_41619_()) continue;
                ItemUtil.forEachEnchantment((en, st, lvl) -> {
                    if (en instanceof TickableAttributeEnchantment) {
                        ((TickableAttributeEnchantment)en).onTick((LivingEntity)this, st, lvl);
                        if (!this.hasAttributeStack(st) && ((TickableAttributeEnchantment)en).addAttributes((LivingEntity)this, st, slot, lvl)) {
                            this.attributeStacks.add((Pair<EquipmentSlot, ItemStack>)new Pair((Object)slot, (Object)st));
                        }
                    }
                }, (ItemStack)stack2);
            }
        }
    }

    @ModifyArg(method={"causeFallDamage"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;calculateFallDamage(FF)I"), index=0)
    private float changeFallDistance(float distance) {
        if ((double)distance >= 3.0) {
            return distance + (float)EnchantmentHelper.m_44836_((Enchantment)BMEnchantments.BUCKLING_CURSE.get(), (LivingEntity)((LivingEntity)this));
        }
        return distance;
    }

    @Unique
    private boolean hasStackEquipInSlot(ItemStack stack, EquipmentSlot slot) {
        return this.m_6844_(slot).equals(stack);
    }

    @Unique
    public boolean hasAttributeStack(ItemStack stack) {
        for (Pair<EquipmentSlot, ItemStack> pair : this.attributeStacks) {
            if (!((ItemStack)pair.getSecond()).equals(stack)) continue;
            return true;
        }
        return false;
    }

    @Shadow
    public abstract ItemStack m_6844_(EquipmentSlot var1);
}

