/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.item.enchantment;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import party.lemons.biomemakeover.BMConfig;
import party.lemons.biomemakeover.item.enchantment.BMEnchantment;
import party.lemons.taniwha.util.MathUtils;

public class TickableAttributeEnchantment
extends BMEnchantment {
    private final Map<Attribute, AttributeModifier> attributeModifiers = Maps.newHashMap();

    public TickableAttributeEnchantment(Supplier<BMConfig.EnchantConfig> config, boolean isCurse, Enchantment.Rarity weight, EnchantmentCategory type, EquipmentSlot[] slotTypes) {
        super(config, isCurse, weight, type, slotTypes);
        this.initAttributes();
    }

    public void initAttributes() {
    }

    public void onTick(LivingEntity entity, ItemStack stack, int level) {
    }

    protected void addAttributeModifier(Attribute attribute, String uuid, double amount, AttributeModifier.Operation operation) {
        AttributeModifier entityAttributeModifier = new AttributeModifier(UUID.fromString(uuid), () -> ((TickableAttributeEnchantment)this).m_44704_(), amount, operation);
        this.attributeModifiers.put(attribute, entityAttributeModifier);
    }

    public boolean addAttributes(LivingEntity entity, ItemStack stack, EquipmentSlot slot, int level) {
        if (this.attributeModifiers.size() <= 0 || stack.m_41619_()) {
            return false;
        }
        for (Map.Entry<Attribute, AttributeModifier> attributeEntry : this.attributeModifiers.entrySet()) {
            UUID id = MathUtils.uuidFromString((String)slot.toString());
            AttributeInstance entityAttributeInstance = entity.m_21204_().m_22146_(attributeEntry.getKey());
            if (entityAttributeInstance == null) continue;
            AttributeModifier mod = attributeEntry.getValue();
            entityAttributeInstance.m_22130_(mod);
            entityAttributeInstance.m_22118_(new AttributeModifier(id, this.m_44704_() + " " + level, this.adjustModifierAmount(level, mod), mod.m_22217_()));
        }
        return true;
    }

    public double adjustModifierAmount(int amplifier, AttributeModifier modifier) {
        return modifier.m_22218_() * (double)amplifier;
    }

    public void removeAttributes(LivingEntity entity, EquipmentSlot slot) {
        for (Map.Entry<Attribute, AttributeModifier> attributeEntry : this.attributeModifiers.entrySet()) {
            UUID slotID = MathUtils.uuidFromString((String)slot.toString());
            AttributeInstance entityAttributeInstance = entity.m_21204_().m_22146_(attributeEntry.getKey());
            if (entityAttributeInstance == null) continue;
            AttributeModifier mod = entityAttributeInstance.m_22111_(slotID);
            if (mod != null) {
                entityAttributeInstance.m_22130_(mod);
                continue;
            }
            System.out.println("ERROR REMOVING MODIFIER: DOESNT EXIST??? : " + entityAttributeInstance.m_22099_().m_22087_());
        }
    }
}

