/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.collective_common_forge.events;

import com.mojang.datafixers.util.Pair;
import com.natamus.collective_common_forge.check.RegisterMod;
import com.natamus.collective_common_forge.config.CollectiveConfigHandler;
import com.natamus.collective_common_forge.data.GlobalVariables;
import com.natamus.collective_common_forge.functions.BlockPosFunctions;
import com.natamus.collective_common_forge.functions.EntityFunctions;
import com.natamus.collective_common_forge.functions.SpawnEntityFunctions;
import com.natamus.collective_common_forge.objects.SAMObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class CollectiveEvents {
    public static WeakHashMap<ServerLevel, List<Entity>> entitiesToSpawn = new WeakHashMap();
    public static WeakHashMap<ServerLevel, WeakHashMap<Entity, Entity>> entitiesToRide = new WeakHashMap();
    public static CopyOnWriteArrayList<Pair<Integer, Runnable>> scheduledRunnables = new CopyOnWriteArrayList();

    public static void onWorldTick(ServerLevel serverLevel) {
        if (entitiesToSpawn.computeIfAbsent(serverLevel, k -> new ArrayList()).size() > 0) {
            Entity tospawn = entitiesToSpawn.get(serverLevel).get(0);
            serverLevel.m_47205_(tospawn);
            if (entitiesToRide.computeIfAbsent(serverLevel, k -> new WeakHashMap()).containsKey(tospawn)) {
                Entity rider = entitiesToRide.get(serverLevel).get(tospawn);
                rider.m_20329_(tospawn);
                entitiesToRide.get(serverLevel).remove(tospawn);
            }
            entitiesToSpawn.get(serverLevel).remove(0);
        }
    }

    public static void onServerTick(MinecraftServer minecraftServer) {
        int serverTickCount = minecraftServer.m_129921_();
        for (Pair<Integer, Runnable> pair : scheduledRunnables) {
            if ((Integer)pair.getFirst() > serverTickCount) continue;
            minecraftServer.m_6937_((Runnable)new TickTask(minecraftServer.m_129921_(), (Runnable)pair.getSecond()));
            scheduledRunnables.remove(pair);
        }
    }

    public static boolean onEntityJoinLevel(Level level, Entity entity) {
        if (!(entity instanceof LivingEntity)) {
            return true;
        }
        if (RegisterMod.shouldDoCheck && entity instanceof Player) {
            RegisterMod.joinWorldProcess(level, (Player)entity);
        }
        if (entity.m_213877_()) {
            return true;
        }
        if (GlobalVariables.globalSAMs.isEmpty()) {
            return true;
        }
        Set tags = entity.m_19880_();
        if (tags.contains("collective.checked")) {
            return true;
        }
        entity.m_20049_("collective.checked");
        EntityType entityType = entity.m_6095_();
        if (!GlobalVariables.activeSAMEntityTypes.contains(entityType)) {
            return true;
        }
        boolean isFromSpawner = tags.contains("collective.fromspawner");
        ArrayList<SAMObject> possibles = new ArrayList<SAMObject>();
        for (SAMObject sam : GlobalVariables.globalSAMs) {
            if (sam == null || sam.fromEntityType == null || !sam.fromEntityType.equals((Object)entityType) || sam.onlyFromSpawner && !isFromSpawner || !sam.onlyFromSpawner && isFromSpawner) continue;
            possibles.add(sam);
        }
        int size = possibles.size();
        if (size == 0) {
            return true;
        }
        Vec3 eVec = entity.m_20182_();
        boolean ageable = entity instanceof AgeableMob;
        boolean isOnSurface = BlockPosFunctions.isOnSurface(level, eVec);
        for (SAMObject sam : possibles) {
            LivingEntity le;
            double num = GlobalVariables.random.nextDouble();
            if (num > sam.changeChance || (!sam.onlyOnSurface ? sam.onlyBelowSurface && isOnSurface : !isOnSurface)) continue;
            if (sam.onlyBelowSpecificY && eVec.f_82480_ >= (double)sam.specificY) continue;
            Entity to = sam.toEntityType.m_20615_(level);
            if (to == null) {
                return true;
            }
            to.m_6034_(eVec.f_82479_, eVec.f_82480_, eVec.f_82481_);
            if (ageable && to instanceof AgeableMob) {
                AgeableMob am = (AgeableMob)to;
                am.m_146762_(((AgeableMob)entity).m_146764_());
                to = am;
            }
            boolean ignoreMainhand = false;
            if (sam.itemToHold != null && to instanceof LivingEntity && !(le = (LivingEntity)to).m_21205_().m_41720_().equals(sam.itemToHold)) {
                le.m_21008_(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)sam.itemToHold, 1));
                ignoreMainhand = true;
            }
            boolean ride = false;
            if (EntityFunctions.isHorse(to).booleanValue() && sam.rideNotReplace) {
                AbstractHorse ah = (AbstractHorse)to;
                ah.m_30651_(true);
                ride = true;
            } else if (CollectiveConfigHandler.transferItemsBetweenReplacedEntities) {
                EntityFunctions.transferItemsBetweenEntities(entity, to, ignoreMainhand);
            }
            if (!(level instanceof ServerLevel)) {
                return true;
            }
            ServerLevel serverLevel = (ServerLevel)level;
            if (ride) {
                SpawnEntityFunctions.startRidingEntityOnNextTick(serverLevel, to, entity);
            } else {
                entity.m_142687_(Entity.RemovalReason.DISCARDED);
            }
            to.m_20049_("collective.checked");
            SpawnEntityFunctions.spawnEntityOnNextTick(serverLevel, to);
            return ride;
        }
        return true;
    }
}

