/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createenchantmentindustry.content.contraptions.fluids.experience;

import com.google.common.util.concurrent.AtomicDouble;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;
import plus.dragons.createenchantmentindustry.entry.CeiFluids;

public class FurnaceExpExtractor
implements IFluidHandler {
    final Object2IntOpenHashMap<ResourceLocation> recipesUsed;
    final AbstractFurnaceBlockEntity BE;

    public FurnaceExpExtractor(Object2IntOpenHashMap<ResourceLocation> recipesUsed, AbstractFurnaceBlockEntity BE) {
        this.recipesUsed = recipesUsed;
        this.BE = BE;
    }

    int getTotalExp() {
        AtomicDouble result = new AtomicDouble(0.0);
        for (Object2IntMap.Entry entry : this.recipesUsed.object2IntEntrySet()) {
            this.BE.m_58904_().m_7465_().m_44043_((ResourceLocation)entry.getKey()).ifPresent(recipe -> result.addAndGet((double)(((AbstractCookingRecipe)recipe).m_43750_() * (float)entry.getIntValue())));
        }
        return (int)Math.floor(result.floatValue());
    }

    public int getTanks() {
        return 1;
    }

    @NotNull
    public FluidStack getFluidInTank(int tank) {
        int total = this.getTotalExp();
        if (total > 0) {
            return new FluidStack((Fluid)CeiFluids.EXPERIENCE.get(), total);
        }
        return FluidStack.EMPTY;
    }

    public int getTankCapacity(int tank) {
        return this.getTotalExp();
    }

    public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
        return stack.getFluid().m_6212_((Fluid)CeiFluids.EXPERIENCE.get());
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        return 0;
    }

    @NotNull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (this.getTotalExp() == 0) {
            return FluidStack.EMPTY;
        }
        if (resource.getFluid().m_6212_((Fluid)CeiFluids.EXPERIENCE.get())) {
            int maxDrain = resource.getAmount();
            return this.drain(maxDrain, action);
        }
        return FluidStack.EMPTY;
    }

    @NotNull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        int total = this.getTotalExp();
        if (total == 0) {
            return FluidStack.EMPTY;
        }
        if (maxDrain <= total) {
            if (action.execute()) {
                this.recipesUsed.clear();
            }
            return new FluidStack((Fluid)CeiFluids.EXPERIENCE.get(), total);
        }
        ArrayList allRecipes = new ArrayList();
        for (Object2IntMap.Entry entry : this.recipesUsed.object2IntEntrySet()) {
            this.BE.m_58904_().m_7465_().m_44043_((ResourceLocation)entry.getKey()).ifPresent(recipe -> {
                for (int i = 0; i < entry.getIntValue(); ++i) {
                    allRecipes.add(recipe);
                }
            });
        }
        boolean done = false;
        int result = 0;
        for (Recipe recipe2 : allRecipes) {
            if (done) {
                if (!action.execute()) continue;
                this.BE.m_6029_(recipe2);
                continue;
            }
            float exp = ((AbstractCookingRecipe)recipe2).m_43750_();
            if (exp <= (float)(maxDrain - result)) {
                result = (int)((float)result + exp);
                continue;
            }
            done = true;
            if (!action.execute()) continue;
            this.recipesUsed.clear();
        }
        return new FluidStack((Fluid)CeiFluids.EXPERIENCE.get(), (int)Math.floor(result));
    }
}

