/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.mysticaloaktree.worldgen;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.mehvahdjukaar.mysticaloaktree.MysticalOakTree;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;

public class WiseOakTrunkPlacer
extends TrunkPlacer {
    public static final Codec<WiseOakTrunkPlacer> CODEC = RecordCodecBuilder.create(instance -> WiseOakTrunkPlacer.m_70305_((RecordCodecBuilder.Instance)instance).apply((Applicative)instance, WiseOakTrunkPlacer::new));
    private static final List<BlockPos> BRANCH_POS = BlockPos.m_121886_((int)-1, (int)0, (int)-1, (int)1, (int)0, (int)1).filter(blockPos -> blockPos.m_123343_() != 0 || blockPos.m_123341_() != 0).map(BlockPos::m_7949_).toList();

    public WiseOakTrunkPlacer(int i, int j, int k) {
        super(i, j, k);
    }

    protected TrunkPlacerType<?> m_7362_() {
        return (TrunkPlacerType)MysticalOakTree.WISE_OAK_TRUNK_PLACER.get();
    }

    public List<FoliagePlacer.FoliageAttachment> m_213934_(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> blockSetter, RandomSource random, int freeTreeHeight, BlockPos pos, TreeConfiguration config) {
        ArrayList<FoliagePlacer.FoliageAttachment> foliageAttachments = new ArrayList<FoliagePlacer.FoliageAttachment>();
        BlockPos blockPos = pos.m_7495_();
        if (config.f_161215_) {
            WiseOakTrunkPlacer.m_226169_((LevelSimulatedReader)level, blockSetter, (RandomSource)random, (BlockPos)blockPos, (TreeConfiguration)config);
        }
        int x = pos.m_123341_();
        int y = pos.m_123342_();
        int z = pos.m_123343_();
        int py = y + freeTreeHeight - 1;
        for (int h = 0; h < freeTreeHeight; ++h) {
            int r = y + h;
            BlockPos blockPos2 = new BlockPos(x, r, z);
            if (!TreeFeature.m_67267_((LevelSimulatedReader)level, (BlockPos)blockPos2)) continue;
            this.m_226187_(level, blockSetter, random, blockPos2, config);
        }
        foliageAttachments.add(new FoliagePlacer.FoliageAttachment(new BlockPos(x, py, z), 0, false));
        int branches = 1 + random.m_216339_(0, 3) + random.m_188503_(2);
        ArrayList<BlockPos> dirs = new ArrayList<BlockPos>(BRANCH_POS);
        ArrayList<BlockPos> selected = new ArrayList<BlockPos>();
        for (int j = 0; j < branches && !dirs.isEmpty(); ++j) {
            int i = random.m_188503_(dirs.size());
            BlockPos pp = (BlockPos)dirs.remove(i);
            dirs.removeIf(b -> b.m_123333_((Vec3i)pp) == 1);
            selected.add(pp);
        }
        for (BlockPos v : selected) {
            Direction.Axis axis = v.m_123341_() != 0 ? Direction.Axis.X : Direction.Axis.Z;
            int branchH = -2 - random.m_188503_(3);
            this.m_226175_(level, blockSetter, random, new BlockPos(x + v.m_123341_(), py + branchH, z + v.m_123343_()), config, blockState -> (BlockState)blockState.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)axis));
            foliageAttachments.add(new FoliagePlacer.FoliageAttachment(new BlockPos(x + v.m_123341_(), py - 1, z + v.m_123343_()), 0, false));
        }
        return foliageAttachments;
    }
}

