/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.platform.forge;

import com.faboslav.friendsandfoes.mixin.forge.FireBlockAccessor;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraftforge.common.ForgeSpawnEggItem;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public final class RegistryHelperImpl {
    public static final DeferredRegister<Activity> ACTIVITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ACTIVITIES, (String)"friendsandfoes");
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"friendsandfoes");
    public static final Map<ModelLayerLocation, Supplier<LayerDefinition>> ENTITY_MODEL_LAYERS = new ConcurrentHashMap<ModelLayerLocation, Supplier<LayerDefinition>>();
    public static final Map<Supplier<? extends EntityType<? extends LivingEntity>>, Supplier<AttributeSupplier.Builder>> ENTITY_ATTRIBUTES = new ConcurrentHashMap<Supplier<? extends EntityType<? extends LivingEntity>>, Supplier<AttributeSupplier.Builder>>();
    public static final DeferredRegister<EntityType<?>> ENTITY_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITY_TYPES, (String)"friendsandfoes");
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"friendsandfoes");
    public static final DeferredRegister<MemoryModuleType<?>> MEMORY_MODULE_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.MEMORY_MODULE_TYPES, (String)"friendsandfoes");
    public static final DeferredRegister<SensorType<?>> SENSOR_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.SENSOR_TYPES, (String)"friendsandfoes");
    public static final DeferredRegister<ParticleType<?>> PARTICLE_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.PARTICLE_TYPES, (String)"friendsandfoes");
    public static final DeferredRegister<PoiType> POINT_OF_INTEREST_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.POI_TYPES, (String)"friendsandfoes");
    public static final DeferredRegister<SoundEvent> SOUND_EVENTS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.SOUND_EVENTS, (String)"friendsandfoes");
    public static final DeferredRegister<StructureType<?>> STRUCTURE_TYPES = DeferredRegister.create((ResourceKey)Registries.f_256938_, (String)"friendsandfoes");
    public static final DeferredRegister<StructureProcessorType<?>> STRUCTURE_PROCESSOR_TYPES = DeferredRegister.create((ResourceKey)Registries.f_256983_, (String)"friendsandfoes");
    public static final DeferredRegister<VillagerProfession> VILLAGER_PROFESSIONS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.VILLAGER_PROFESSIONS, (String)"friendsandfoes");
    public static final HashMap<ResourceKey<CreativeModeTab>, HashMap<Item, Item>> ITEMS_TO_ADD_BEFORE = new HashMap();
    public static final HashMap<ResourceKey<CreativeModeTab>, HashMap<Item, Item>> ITEMS_TO_ADD_AFTER = new HashMap();

    public static void addToItemGroupBefore(ResourceKey<CreativeModeTab> itemGroup, Item item, Item before) {
        if (ITEMS_TO_ADD_BEFORE.containsKey(itemGroup)) {
            ITEMS_TO_ADD_BEFORE.get(itemGroup).put(item, before);
        } else {
            HashMap<Item, Item> items = new HashMap<Item, Item>();
            items.put(item, before);
            ITEMS_TO_ADD_BEFORE.put(itemGroup, items);
        }
    }

    public static void addToItemGroupAfter(ResourceKey<CreativeModeTab> itemGroup, Item item, Item after) {
        if (ITEMS_TO_ADD_AFTER.containsKey(itemGroup)) {
            ITEMS_TO_ADD_AFTER.get(itemGroup).put(item, after);
        } else {
            HashMap<Item, Item> items = new HashMap<Item, Item>();
            items.put(item, after);
            ITEMS_TO_ADD_AFTER.put(itemGroup, items);
        }
    }

    public static <T extends Activity> Supplier<T> registerActivity(String name, Supplier<T> activity) {
        return ACTIVITIES.register(name, activity);
    }

    public static <T extends Block> Supplier<T> registerBlock(String name, Supplier<T> block) {
        return BLOCKS.register(name, block);
    }

    public static void registerBlockSetType(Supplier<BlockSetType> blockSetType) {
        BlockSetType.m_272115_((BlockSetType)blockSetType.get());
    }

    public static void registerEntityModelLayer(ModelLayerLocation location, Supplier<LayerDefinition> definition) {
        ENTITY_MODEL_LAYERS.put(location, definition);
    }

    public static <T extends Entity> void registerEntityRenderer(Supplier<EntityType<T>> type, EntityRendererProvider<T> renderProvider) {
        EntityRenderers.m_174036_(type.get(), renderProvider);
    }

    public static <T extends Entity> Supplier<EntityType<T>> registerEntityType(String name, Supplier<EntityType<T>> entityType) {
        return ENTITY_TYPES.register(name, entityType);
    }

    public static void registerEntityAttribute(Supplier<? extends EntityType<? extends LivingEntity>> type, Supplier<AttributeSupplier.Builder> attribute) {
        ENTITY_ATTRIBUTES.put(type, attribute);
    }

    public static <T extends Item> Supplier<T> registerItem(String name, Supplier<T> item) {
        return ITEMS.register(name, item);
    }

    public static <T extends Item> Supplier<T> registerSpawnEggItem(String name, Supplier<? extends EntityType<? extends Mob>> type, int backgroundColor, int highlightColor, Item.Properties props) {
        return RegistryHelperImpl.registerItem(name, () -> new ForgeSpawnEggItem(type, backgroundColor, highlightColor, props));
    }

    public static <T extends MemoryModuleType<?>> Supplier<T> registerMemoryModuleType(String name, Supplier<T> memoryModuleType) {
        return MEMORY_MODULE_TYPES.register(name, memoryModuleType);
    }

    public static <T extends SensorType<?>> Supplier<T> registerSensorType(String name, Supplier<T> sensorType) {
        return SENSOR_TYPES.register(name, sensorType);
    }

    public static void registerParticleType(String name, SimpleParticleType particleType) {
        PARTICLE_TYPES.register(name, () -> particleType);
    }

    public static <T extends PoiType> Supplier<T> registerPointOfInterestType(String name, Supplier<T> pointOfInterestType) {
        return POINT_OF_INTEREST_TYPES.register(name, pointOfInterestType);
    }

    public static void registerRenderType(RenderType type, Block ... blocks) {
        for (Block block : blocks) {
            ItemBlockRenderTypes.setRenderLayer((Block)block, (RenderType)type);
        }
    }

    public static <T extends SoundEvent> Supplier<T> registerSoundEvent(String name, Supplier<T> soundEvent) {
        return SOUND_EVENTS.register(name, soundEvent);
    }

    public static <T extends VillagerProfession> Supplier<T> registerVillagerProfession(String name, Supplier<T> villagerProfession) {
        return VILLAGER_PROFESSIONS.register(name, villagerProfession);
    }

    public static <T extends Block> void registerFlammableBlock(Block fireBlock, Supplier<T> block, int burnChance, int spreadChance) {
        ((FireBlockAccessor)fireBlock).invokeRegisterFlammableBlock((Block)block.get(), burnChance, spreadChance);
    }

    public static <T extends StructureProcessor> void registerStructureProcessorType(String name, StructureProcessorType<T> structureProcessorType) {
        STRUCTURE_PROCESSOR_TYPES.register(name, () -> structureProcessorType);
    }

    public static <T extends Structure> void registerStructureType(String name, StructureType<T> structureType) {
        STRUCTURE_TYPES.register(name, () -> structureType);
    }
}

