/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.network.packet;

import com.faboslav.friendsandfoes.FriendsAndFoes;
import com.faboslav.friendsandfoes.init.FriendsAndFoesItems;
import com.faboslav.friendsandfoes.init.FriendsAndFoesParticleTypes;
import com.faboslav.friendsandfoes.network.MessageHandler;
import com.faboslav.friendsandfoes.network.base.Packet;
import com.faboslav.friendsandfoes.network.base.PacketContext;
import com.faboslav.friendsandfoes.network.base.PacketHandler;
import com.faboslav.friendsandfoes.util.TotemUtil;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public record TotemEffectPacket(ItemStack itemStack, int entityId) implements Packet<TotemEffectPacket>
{
    public static Gson gson = new GsonBuilder().create();
    public static final ResourceLocation ID = FriendsAndFoes.makeID("totem_effect_packet");
    public static final Handler HANDLER = new Handler();

    public static void sendToClient(Player player, ItemStack itemStack) {
        TotemEffectPacket totemEffectPacket = new TotemEffectPacket(itemStack, player.m_19879_());
        MessageHandler.DEFAULT_CHANNEL.sendToPlayer(totemEffectPacket, player);
        MessageHandler.DEFAULT_CHANNEL.sendToAllLoaded(totemEffectPacket, player.m_9236_(), player.m_20183_());
    }

    @Override
    public ResourceLocation getID() {
        return ID;
    }

    @Override
    public PacketHandler<TotemEffectPacket> getHandler() {
        return HANDLER;
    }

    public static class Handler
    implements PacketHandler<TotemEffectPacket> {
        @Override
        public PacketContext handle(TotemEffectPacket packet) {
            return (player, level) -> {
                Entity entity = level.m_6815_(packet.entityId());
                if (entity == null || player.m_19879_() != entity.m_19879_()) {
                    return;
                }
                if (packet.itemStack.m_41720_() == FriendsAndFoesItems.TOTEM_OF_FREEZING.get()) {
                    TotemUtil.playActivateAnimation(packet.itemStack, entity, (ParticleOptions)FriendsAndFoesParticleTypes.TOTEM_OF_FREEZING);
                } else if (packet.itemStack.m_41720_() == FriendsAndFoesItems.TOTEM_OF_ILLUSION.get()) {
                    TotemUtil.playActivateAnimation(packet.itemStack, entity, (ParticleOptions)FriendsAndFoesParticleTypes.TOTEM_OF_FREEZING);
                }
            };
        }

        @Override
        public TotemEffectPacket decode(FriendlyByteBuf buf) {
            FriendsAndFoes.getLogger().info(String.valueOf(buf));
            return new TotemEffectPacket(buf.m_130267_(), buf.readInt());
        }

        @Override
        public void encode(TotemEffectPacket packet, FriendlyByteBuf buf) {
            buf.m_130055_(packet.itemStack);
            buf.writeInt(packet.entityId);
        }
    }
}

