/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.mixin;

import com.faboslav.friendsandfoes.FriendsAndFoes;
import com.faboslav.friendsandfoes.block.Oxidizable;
import com.faboslav.friendsandfoes.client.render.entity.animation.KeyframeAnimation;
import com.faboslav.friendsandfoes.entity.CopperGolemEntity;
import com.faboslav.friendsandfoes.entity.ai.brain.CopperGolemBrain;
import com.faboslav.friendsandfoes.entity.pose.CopperGolemEntityPose;
import com.faboslav.friendsandfoes.init.FriendsAndFoesBlocks;
import com.faboslav.friendsandfoes.init.FriendsAndFoesEntityTypes;
import com.faboslav.friendsandfoes.mixin.LightningRodBlockBlockMixin;
import com.faboslav.friendsandfoes.util.CopperGolemBuildPatternPredicates;
import java.util.ArrayList;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CarvedPumpkinBlock;
import net.minecraft.world.level.block.LightningRodBlock;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.WeatheringCopperFullBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.block.state.pattern.BlockPattern;
import net.minecraft.world.level.block.state.pattern.BlockPatternBuilder;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LightningRodBlock.class})
public abstract class LightningRodBlockMixin
extends LightningRodBlockBlockMixin {
    @Nullable
    private BlockPattern friendsandfoes_copperGolemPattern;

    @Inject(method={"onBlockAdded"}, at={@At(value="HEAD")})
    private void friendsandfoes_onBlockAdded(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean notify, CallbackInfo ci) {
        if (!oldState.m_60713_(state.m_60734_())) {
            this.friendsandfoes_tryToSpawnCopperGolem(world, pos);
        }
    }

    private void friendsandfoes_tryToSpawnCopperGolem(Level world, BlockPos pos) {
        WeatheringCopper.WeatherState bodyOxidationLevel;
        if (!FriendsAndFoes.getConfig().enableCopperGolem) {
            return;
        }
        BlockPattern.BlockPatternMatch patternSearchResult = this.friendsandfoes_getCopperGolemPattern().m_61184_((LevelReader)world, pos);
        if (patternSearchResult == null) {
            return;
        }
        BlockState lightningRodBlockState = patternSearchResult.m_61229_(0, 0, 0).m_61168_();
        BlockState headBlockState = patternSearchResult.m_61229_(0, 1, 0).m_61168_();
        BlockState bodyBlockState = patternSearchResult.m_61229_(0, 2, 0).m_61168_();
        WeatheringCopper.WeatherState lightningRodOxidationLevel = lightningRodBlockState.m_60713_(FriendsAndFoesBlocks.WAXED_LIGHTNING_ROD.get()) ? WeatheringCopper.WeatherState.UNAFFECTED : (lightningRodBlockState.m_60713_(FriendsAndFoesBlocks.WAXED_WEATHERED_LIGHTNING_ROD.get()) ? WeatheringCopper.WeatherState.WEATHERED : (lightningRodBlockState.m_60713_(FriendsAndFoesBlocks.WAXED_EXPOSED_LIGHTNING_ROD.get()) ? WeatheringCopper.WeatherState.EXPOSED : (lightningRodBlockState.m_60713_(FriendsAndFoesBlocks.WAXED_OXIDIZED_LIGHTNING_ROD.get()) ? WeatheringCopper.WeatherState.OXIDIZED : (WeatheringCopper.WeatherState)((Oxidizable)lightningRodBlockState.m_60734_()).m_142297_())));
        if (lightningRodOxidationLevel != (bodyOxidationLevel = bodyBlockState.m_60713_(Blocks.f_152571_) ? WeatheringCopper.WeatherState.UNAFFECTED : (bodyBlockState.m_60713_(Blocks.f_152572_) ? WeatheringCopper.WeatherState.WEATHERED : (bodyBlockState.m_60713_(Blocks.f_152573_) ? WeatheringCopper.WeatherState.EXPOSED : (bodyBlockState.m_60713_(Blocks.f_152574_) ? WeatheringCopper.WeatherState.OXIDIZED : ((WeatheringCopperFullBlock)bodyBlockState.m_60734_()).m_142297_()))))) {
            return;
        }
        for (int i = 0; i < this.friendsandfoes_getCopperGolemPattern().m_61202_(); ++i) {
            BlockInWorld cachedBlockPosition = patternSearchResult.m_61229_(0, i, 0);
            world.m_7731_(cachedBlockPosition.m_61176_(), Blocks.f_50016_.m_49966_(), 2);
            world.m_46796_(2001, cachedBlockPosition.m_61176_(), Block.m_49956_((BlockState)cachedBlockPosition.m_61168_()));
        }
        BlockPos cachedBlockPosition = patternSearchResult.m_61229_(0, 2, 0).m_61176_();
        float copperGolemYaw = ((Direction)headBlockState.m_61143_((Property)CarvedPumpkinBlock.f_51367_)).m_122435_();
        CopperGolemEntity copperGolem = (CopperGolemEntity)FriendsAndFoesEntityTypes.COPPER_GOLEM.get().m_20615_(world);
        copperGolem.m_6034_((double)cachedBlockPosition.m_123341_() + 0.5, (double)cachedBlockPosition.m_123342_() + 0.05, (double)cachedBlockPosition.m_123343_() + 0.5);
        copperGolem.setSpawnYaw(copperGolemYaw);
        copperGolem.setOxidationLevel(bodyOxidationLevel);
        if (lightningRodOxidationLevel == WeatheringCopper.WeatherState.OXIDIZED) {
            ArrayList<CopperGolemEntityPose> possiblePoses = new ArrayList<CopperGolemEntityPose>(){
                {
                    this.add(CopperGolemEntityPose.SPIN_HEAD);
                    this.add(CopperGolemEntityPose.PRESS_BUTTON_UP);
                    this.add(CopperGolemEntityPose.PRESS_BUTTON_DOWN);
                }
            };
            int randomPoseIndex = copperGolem.m_217043_().m_188503_(possiblePoses.size());
            CopperGolemEntityPose randomPose = (CopperGolemEntityPose)((Object)possiblePoses.get(randomPoseIndex));
            copperGolem.setPose(randomPose);
            KeyframeAnimation keyframeAnimation = copperGolem.getKeyframeAnimationByPose();
            if (keyframeAnimation != null) {
                int keyFrameAnimationLengthInTicks = keyframeAnimation.getAnimationLengthInTicks();
                int randomKeyframeAnimationTick = copperGolem.m_217043_().m_216332_(keyFrameAnimationLengthInTicks / 6, keyFrameAnimationLengthInTicks - keyFrameAnimationLengthInTicks / 6);
                copperGolem.setKeyframeAnimationTicks(randomKeyframeAnimationTick);
            }
        } else {
            boolean isHeadBlockWaxed = this.friendsandfoes_isCopperBlockWaxed(headBlockState);
            boolean isBodyBlockWaxed = this.friendsandfoes_isCopperBlockWaxed(bodyBlockState);
            boolean isWaxed = isHeadBlockWaxed && isBodyBlockWaxed;
            copperGolem.setIsWaxed(isWaxed);
        }
        CopperGolemBrain.setSpinHeadCooldown(copperGolem);
        CopperGolemBrain.setPressButtonCooldown(copperGolem);
        world.m_7967_((Entity)copperGolem);
        for (ServerPlayer serverPlayerEntity : world.m_45976_(ServerPlayer.class, copperGolem.m_20191_().m_82400_(5.0))) {
            CriteriaTriggers.f_10580_.m_68256_(serverPlayerEntity, (Entity)copperGolem);
        }
        for (int j = 0; j < this.friendsandfoes_getCopperGolemPattern().m_61202_(); ++j) {
            BlockInWorld cachedBlockPosition2 = patternSearchResult.m_61229_(0, j, 0);
            world.m_6289_(cachedBlockPosition2.m_61176_(), Blocks.f_50016_);
        }
    }

    private BlockPattern friendsandfoes_getCopperGolemPattern() {
        if (this.friendsandfoes_copperGolemPattern == null) {
            this.friendsandfoes_copperGolemPattern = BlockPatternBuilder.m_61243_().m_61247_(new String[]{"|", "^", "#"}).m_61244_('|', BlockInWorld.m_61169_(CopperGolemBuildPatternPredicates.IS_COPPER_GOLEM_LIGHTNING_ROD_PREDICATE)).m_61244_('^', BlockInWorld.m_61169_(CopperGolemBuildPatternPredicates.IS_GOLEM_HEAD_PREDICATE)).m_61244_('#', BlockInWorld.m_61169_(CopperGolemBuildPatternPredicates.IS_COPPER_GOLEM_BODY_PREDICATE)).m_61249_();
        }
        return this.friendsandfoes_copperGolemPattern;
    }

    private boolean friendsandfoes_isCopperBlockWaxed(BlockState blockState) {
        return blockState.m_60713_(Blocks.f_152571_) || blockState.m_60713_(Blocks.f_152572_) || blockState.m_60713_(Blocks.f_152573_) || blockState.m_60713_(Blocks.f_152574_) || blockState.m_60713_(FriendsAndFoesBlocks.WAXED_LIGHTNING_ROD.get()) || blockState.m_60713_(FriendsAndFoesBlocks.WAXED_WEATHERED_LIGHTNING_ROD.get()) || blockState.m_60713_(FriendsAndFoesBlocks.WAXED_EXPOSED_LIGHTNING_ROD.get()) || blockState.m_60713_(FriendsAndFoesBlocks.WAXED_OXIDIZED_LIGHTNING_ROD.get());
    }
}

