/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zetter.painting.tools;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import me.dantaeusb.zetter.painting.parameters.BrushParameters;
import me.dantaeusb.zetter.painting.pipes.BlendingPipe;
import me.dantaeusb.zetter.painting.pipes.DitheringPipe;
import me.dantaeusb.zetter.painting.pipes.Pipe;
import me.dantaeusb.zetter.painting.tools.AbstractTool;
import me.dantaeusb.zetter.painting.tools.brush.Bezier;
import me.dantaeusb.zetter.storage.CanvasData;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Tuple;

public class Brush
extends AbstractTool<BrushParameters> {
    public static final int HOTKEY = 66;
    private final Component translatableComponent = Component.m_237115_((String)"container.zetter.painting.tools.brush");
    private final Bezier brushBezier = new Bezier(0.455, 0.03, 0.515, 0.955);

    public Brush() {
        super((List<Pipe>)new ArrayList<Pipe>(){
            {
                this.add(new DitheringPipe());
                this.add(new BlendingPipe());
            }
        });
    }

    @Override
    public AbstractTool.ToolShape getShape(BrushParameters params) {
        return null;
    }

    @Override
    public Component getTranslatableComponent() {
        return this.translatableComponent;
    }

    @Override
    public boolean shouldAddAction(CanvasData canvasData, BrushParameters params, float newPosX, float newPosY, @Nullable Float lastPosX, @Nullable Float lastPosY) {
        int maxActiveDistance = (int)Math.ceil(params.getSize() / 2.0f);
        if (newPosX < (float)(-maxActiveDistance) || newPosX > (float)(canvasData.getWidth() + maxActiveDistance)) {
            return false;
        }
        if (newPosY < (float)(-maxActiveDistance) || newPosY > (float)(canvasData.getHeight() + maxActiveDistance)) {
            return false;
        }
        if (lastPosX == null || lastPosY == null) {
            return true;
        }
        double distance = Math.sqrt(Math.pow(newPosX - lastPosX.floatValue(), 2.0) + Math.pow(newPosY - lastPosY.floatValue(), 2.0));
        return distance > 1.0;
    }

    @Override
    public int useTool(CanvasData canvasData, BrushParameters params, int color, float posX, float posY) {
        int width = canvasData.getWidth();
        int height = canvasData.getHeight();
        float intensity = params.getIntensity();
        float brushSize = params.getSize();
        double totalDamage = 0.0;
        List<Tuple<Integer, Integer>> affectedPixels = Brush.getPixelsInDistance(canvasData, posX, posY, brushSize);
        for (Tuple<Integer, Integer> pixel : affectedPixels) {
            double distanceToCenter = Math.sqrt(Math.pow((double)posX - ((double)((Integer)pixel.m_14418_()).intValue() + 0.5), 2.0) + Math.pow((double)posY - ((double)((Integer)pixel.m_14419_()).intValue() + 0.5), 2.0));
            double proximity = Brush.clamp(1.0 - distanceToCenter / (double)brushSize, 0.0, 1.0);
            if (proximity == 0.0) continue;
            int localIndex = (Integer)pixel.m_14419_() * width + (Integer)pixel.m_14418_();
            double localIntensity = this.brushBezier.solve(proximity, 0.001);
            this.pixelChange(canvasData, params, color, localIndex, (float)localIntensity);
            totalDamage += localIntensity;
        }
        return (int)Math.round(totalDamage * (double)intensity);
    }

    private static List<Tuple<Integer, Integer>> getPixelsInDistance(CanvasData canvasData, float posX, float posY, float size) {
        float radius = size / 2.0f;
        int minX = (int)Brush.clamp(Math.floor(posX - radius), 0.0, canvasData.getWidth() - 1);
        int maxX = (int)Brush.clamp(Math.ceil(posX + radius), 0.0, canvasData.getWidth() - 1);
        int minY = (int)Brush.clamp(Math.floor(posY - radius), 0.0, canvasData.getHeight() - 1);
        int maxY = (int)Brush.clamp(Math.ceil(posY + radius), 0.0, canvasData.getHeight() - 1);
        ArrayList<Tuple<Integer, Integer>> pixels = new ArrayList<Tuple<Integer, Integer>>();
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                pixels.add((Tuple<Integer, Integer>)new Tuple((Object)x, (Object)y));
            }
        }
        return pixels;
    }

    private static double clamp(double value, double min, double max) {
        return Math.min(Math.max(value, min), max);
    }
}

