/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zetter.painting.pipes;

import me.dantaeusb.zetter.core.tools.Color;
import me.dantaeusb.zetter.painting.parameters.AbstractToolParameters;
import me.dantaeusb.zetter.painting.parameters.BlendingParameterHolder;
import me.dantaeusb.zetter.painting.parameters.IntensityParameterHolder;
import me.dantaeusb.zetter.painting.pipes.Pipe;
import me.dantaeusb.zetter.painting.tools.AbstractTool;
import me.dantaeusb.zetter.painting.tools.Brush;
import me.dantaeusb.zetter.storage.CanvasData;
import net.minecraft.network.chat.Component;
import org.apache.commons.lang3.function.TriFunction;

public class BlendingPipe
implements Pipe {
    @Override
    public boolean shouldUsePipe(AbstractTool tool, AbstractToolParameters params) {
        if (tool instanceof Brush) {
            return true;
        }
        if (params instanceof IntensityParameterHolder) {
            return ((IntensityParameterHolder)((Object)params)).getIntensity() < 1.0f;
        }
        return false;
    }

    @Override
    public int applyPipe(CanvasData canvas, AbstractToolParameters params, int color, int index, float localIntensity) {
        int originalColor = canvas.getColorAt(index);
        float intensity = 1.0f;
        if (params instanceof IntensityParameterHolder) {
            intensity = ((IntensityParameterHolder)((Object)params)).getIntensity();
        }
        intensity *= localIntensity;
        BlendingOption blending = BlendingOption.DEFAULT;
        if (params instanceof BlendingParameterHolder) {
            blending = ((BlendingParameterHolder)((Object)params)).getBlending();
        }
        return (Integer)blending.blendingFunction.apply((Object)color, (Object)originalColor, (Object)Float.valueOf(intensity));
    }

    public static int blendRGB(int newColor, int oldColor, float intensity) {
        Color newColorModel = new Color(newColor);
        Color oldColorModel = new Color(oldColor);
        return new Color(((float)newColorModel.getRed() * intensity + (float)oldColorModel.getRed() * (1.0f - intensity)) / 255.0f, ((float)newColorModel.getGreen() * intensity + (float)oldColorModel.getGreen() * (1.0f - intensity)) / 255.0f, ((float)newColorModel.getBlue() * intensity + (float)oldColorModel.getBlue() * (1.0f - intensity)) / 255.0f).getRGB();
    }

    public static int blendRYB(int newColor, int oldColor, float intensity) {
        intensity = Math.max(0.0f, Math.min(1.0f, intensity));
        float[] newFloat = BlendingPipe.protectPitchBlack(new Color(newColor).getRGBfloat());
        float[] oldFloat = BlendingPipe.protectPitchBlack(new Color(oldColor).getRGBfloat());
        float[] rybNew = BlendingPipe.rgbToRyb(newFloat);
        float[] rybOld = BlendingPipe.rgbToRyb(oldFloat);
        float negativeIntensity = 1.0f - intensity;
        float[] rybResult = new float[]{intensity * rybNew[0] + negativeIntensity * rybOld[0], intensity * rybNew[1] + negativeIntensity * rybOld[1], intensity * rybNew[2] + negativeIntensity * rybOld[2]};
        float[] rgbResult = BlendingPipe.protectOverflow(BlendingPipe.rybToRgb(rybResult));
        return new Color(rgbResult[0], rgbResult[1], rgbResult[2]).getRGB();
    }

    private static float[] rgbToRyb(float[] rgb) {
        float w = Math.min(Math.min(rgb[0], rgb[1]), rgb[2]);
        float rgbR = rgb[0] - w;
        float rgbG = rgb[1] - w;
        float rgbB = rgb[2] - w;
        float rybR = rgbR - Math.min(rgbR, rgbG);
        float rybY = 0.5f * (rgbG + Math.min(rgbR, rgbG));
        float rybB = 0.5f * (rgbB + rgbG - Math.min(rgbR, rgbG));
        float n = Math.max(Math.max(rybR, rybY), rybB) / Math.max(Math.max(rgbR, rgbG), rgbB);
        if (Float.isNaN(n) || n == 0.0f) {
            n = 1.0f;
        }
        float b = Math.min(Math.min(1.0f - rgb[0], 1.0f - rgb[1]), 1.0f - rgb[2]);
        return new float[]{(rybR /= n) + b, (rybY /= n) + b, (rybB /= n) + b};
    }

    private static float[] rybToRgb(float[] ryb) {
        float w = Math.min(Math.min(ryb[0], ryb[1]), ryb[2]);
        float rybR = ryb[0] - w;
        float rybY = ryb[1] - w;
        float rybB = ryb[2] - w;
        float rgbR = rybR + rybY - Math.min(rybY, rybB);
        float rgbG = rybY + Math.min(rybY, rybB);
        float rgbB = 2.0f * (rybB - Math.min(rybY, rybB));
        float n = Math.max(Math.max(rgbR, rgbG), rgbB) / Math.max(Math.max(rybR, rybY), rybB);
        n = n == 0.0f || Float.isNaN(n) ? 1.0f : n;
        float b = Math.min(Math.min(1.0f - ryb[0], 1.0f - ryb[1]), 1.0f - ryb[2]);
        return new float[]{(rgbR /= n) + b, (rgbG /= n) + b, (rgbB /= n) + b};
    }

    public static int blendRGBC(int newColor, int oldColor, float intensity) {
        return BlendingPipe.blendRYB(newColor, oldColor, intensity);
    }

    private static float[] protectPitchBlack(float[] rgb) {
        return new float[]{Math.max(rgb[0], 0.004f), Math.max(rgb[1], 0.004f), Math.max(rgb[2], 0.004f)};
    }

    private static float[] protectOverflow(float[] rgb) {
        return new float[]{Math.min(Math.max(rgb[0], 0.0f), 1.0f), Math.min(Math.max(rgb[1], 0.0f), 1.0f), Math.min(Math.max(rgb[2], 0.0f), 1.0f)};
    }

    public static enum BlendingOption {
        RGB((TriFunction<Integer, Integer, Float, Integer>)((TriFunction)BlendingPipe::blendRGB), (Component)Component.m_237115_((String)"container.zetter.painting.blending.additive")),
        RYB((TriFunction<Integer, Integer, Float, Integer>)((TriFunction)BlendingPipe::blendRYB), (Component)Component.m_237115_((String)"container.zetter.painting.blending.subtractive")),
        RGBC((TriFunction<Integer, Integer, Float, Integer>)((TriFunction)BlendingPipe::blendRGBC), (Component)Component.m_237115_((String)"container.zetter.painting.blending.realistic"));

        public static final BlendingOption DEFAULT;
        public final TriFunction<Integer, Integer, Float, Integer> blendingFunction;
        public final Component translatableComponent;

        private BlendingOption(TriFunction<Integer, Integer, Float, Integer> blendingFunction, Component translatableComponent) {
            this.blendingFunction = blendingFunction;
            this.translatableComponent = translatableComponent;
        }

        static {
            DEFAULT = RYB;
        }
    }
}

