/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zetter.item.crafting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import me.dantaeusb.zetter.core.ZetterCraftingRecipes;
import me.dantaeusb.zetter.core.ZetterItems;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class PaletteRechargeRecipe
extends CustomRecipe {
    private final Ingredient inputPalette;
    private final Ingredient inputRecharge;

    public PaletteRechargeRecipe(ResourceLocation id, Ingredient inputPalette, Ingredient inputRecharge) {
        super(id, CraftingBookCategory.MISC);
        this.inputPalette = inputPalette;
        this.inputRecharge = inputRecharge;
    }

    public String toString() {
        return "PaletteRechargeRecipe [inputPalette=" + this.inputPalette + ", inputRecharge=" + this.inputRecharge + "]";
    }

    public boolean matches(CraftingContainer craftingInventory, Level world) {
        ItemStack paletteStack = ItemStack.f_41583_;
        ItemStack rechargeStack = ItemStack.f_41583_;
        for (int i = 0; i < craftingInventory.m_6643_(); ++i) {
            if (craftingInventory.m_8020_(i).m_41619_()) continue;
            if (this.inputPalette.test(craftingInventory.m_8020_(i))) {
                if (!paletteStack.m_41619_()) {
                    return false;
                }
                paletteStack = craftingInventory.m_8020_(i);
                continue;
            }
            if (!this.inputRecharge.test(craftingInventory.m_8020_(i))) continue;
            if (!rechargeStack.m_41619_()) {
                return false;
            }
            rechargeStack = craftingInventory.m_8020_(i);
        }
        return !paletteStack.m_41619_() && paletteStack.m_41782_() && paletteStack.m_41773_() > 0 && !rechargeStack.m_41619_();
    }

    @NotNull
    public ItemStack assemble(CraftingContainer craftingInventory, RegistryAccess registryAccess) {
        ItemStack paletteStack = ItemStack.f_41583_;
        ItemStack rechargeStack = ItemStack.f_41583_;
        for (int i = 0; i < craftingInventory.m_6643_(); ++i) {
            if (this.inputPalette.test(craftingInventory.m_8020_(i))) {
                if (!paletteStack.m_41619_()) {
                    return ItemStack.f_41583_;
                }
                paletteStack = craftingInventory.m_8020_(i);
                continue;
            }
            if (!this.inputRecharge.test(craftingInventory.m_8020_(i))) continue;
            if (!rechargeStack.m_41619_()) {
                return ItemStack.f_41583_;
            }
            rechargeStack = craftingInventory.m_8020_(i);
        }
        if (!paletteStack.m_41619_() && paletteStack.m_41782_() && paletteStack.m_41773_() > 0 && !rechargeStack.m_41619_()) {
            ItemStack outStack = paletteStack.m_41777_();
            int newDamage = paletteStack.m_41773_();
            if (rechargeStack.m_150930_((Item)ZetterItems.PALETTE.get()) && rechargeStack.m_41773_() > 0) {
                newDamage -= rechargeStack.m_41776_() - rechargeStack.m_41773_();
                newDamage = Math.max(newDamage, 0);
            } else {
                newDamage = 0;
            }
            CompoundTag compoundnbt = paletteStack.m_41783_().m_6426_();
            outStack.m_41751_(compoundnbt);
            outStack.m_41721_(newDamage);
            return outStack;
        }
        return ItemStack.f_41583_;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ZetterCraftingRecipes.PALETTE_RECHARGE.get();
    }

    public boolean m_8004_(int width, int height) {
        return width >= 2 && height >= 2;
    }

    public static class Serializer
    implements RecipeSerializer<PaletteRechargeRecipe> {
        public PaletteRechargeRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            JsonObject inputFrameJson = GsonHelper.m_13930_((JsonObject)json, (String)"palette");
            Ingredient inputFrame = Ingredient.m_43917_((JsonElement)inputFrameJson);
            JsonObject inputPaintingJson = GsonHelper.m_13930_((JsonObject)json, (String)"recharge");
            Ingredient inputPainting = Ingredient.m_43917_((JsonElement)inputPaintingJson);
            return new PaletteRechargeRecipe(recipeId, inputFrame, inputPainting);
        }

        public PaletteRechargeRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            Ingredient frameIngredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            Ingredient paintingIngredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            return new PaletteRechargeRecipe(recipeId, frameIngredient, paintingIngredient);
        }

        public void toNetwork(FriendlyByteBuf buffer, PaletteRechargeRecipe recipe) {
            recipe.inputPalette.m_43923_(buffer);
            recipe.inputRecharge.m_43923_(buffer);
        }
    }
}

