/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zetter.client.gui.easel;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import me.dantaeusb.zetter.client.gui.EaselScreen;
import me.dantaeusb.zetter.client.gui.easel.AbstractEaselWidget;
import me.dantaeusb.zetter.menu.EaselMenu;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class ZoomWidget
extends AbstractEaselWidget
implements Renderable {
    private final List<ZoomButton> buttons;
    public static final int ZOOM_OUT_HOTKEY = 45;
    public static final int ZOOM_IN_HOTKEY = 61;
    static final int ZOOM_BUTTON_WIDTH = 12;
    static final int ZOOM_BUTTON_HEIGHT = 12;
    static final int ZOOM_BUTTONS_U = 208;
    static final int ZOOM_BUTTONS_V = 197;

    public ZoomWidget(final EaselScreen parentScreen, int x, int y) {
        super(parentScreen, x, y, 24, 12, (Component)Component.m_237115_((String)"container.zetter.painting.zoom"));
        this.buttons = new ArrayList<ZoomButton>(){
            {
                this.add(new ZoomButton(((EaselMenu)parentScreen.m_6262_())::canIncreaseCanvasScale, ((EaselMenu)parentScreen.m_6262_())::increaseCanvasScale, 208, 197, 12, 12, (Component)Component.m_237115_((String)"container.zetter.painting.zoom.in")));
                this.add(new ZoomButton(((EaselMenu)parentScreen.m_6262_())::canDecreaseCanvasScale, ((EaselMenu)parentScreen.m_6262_())::decreaseCanvasScale, 220, 197, 12, 12, (Component)Component.m_237115_((String)"container.zetter.painting.zoom.out")));
            }
        };
    }

    @Override
    @Nullable
    public Component getTooltip(int mouseX, int mouseY) {
        int i = 0;
        for (ZoomButton zoomButton : this.buttons) {
            int fromX = this.m_252754_() + i * 12;
            if (EaselScreen.isInRect(fromX, this.m_252907_(), 12, 12, mouseX, mouseY)) {
                return zoomButton.getTooltip();
            }
            ++i;
        }
        return null;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        int iMouseX = (int)mouseX;
        int iMouseY = (int)mouseY;
        if (!this.m_5953_(mouseX, mouseY)) {
            return false;
        }
        int i = 0;
        for (ZoomButton zoomButton : this.buttons) {
            int fromX = this.m_252754_() + i * 12;
            if (EaselScreen.isInRect(fromX, this.m_252907_(), 12, 12, iMouseX, iMouseY)) {
                zoomButton.action.get();
                this.m_7435_(Minecraft.m_91087_().m_91106_());
            }
            ++i;
        }
        return false;
    }

    @Override
    protected void m_168797_(NarrationElementOutput narrationElementOutput) {
        narrationElementOutput.m_169146_(NarratedElementType.TITLE, (Component)this.m_5646_());
    }

    public void m_87963_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)AbstractEaselWidget.EASEL_WIDGETS_TEXTURE_RESOURCE);
        guiGraphics.m_280218_(AbstractEaselWidget.EASEL_WIDGETS_TEXTURE_RESOURCE, this.m_252754_(), this.m_252907_(), 184, 197, 12 * this.buttons.size(), 12);
        int i = 0;
        for (ZoomButton zoomButton : this.buttons) {
            int fromX = this.m_252754_() + i * 12;
            int uOffset = zoomButton.uPosition + (zoomButton.active.get() != false ? 0 : 24);
            guiGraphics.m_280218_(AbstractEaselWidget.EASEL_WIDGETS_TEXTURE_RESOURCE, fromX, this.m_252907_(), uOffset, zoomButton.vPosition, zoomButton.width, zoomButton.height);
            ++i;
        }
    }

    public boolean undo() {
        return false;
    }

    public boolean redo() {
        return false;
    }

    public class ZoomButton {
        public final Supplier<Boolean> active;
        public final Supplier<Boolean> action;
        public final int uPosition;
        public final int vPosition;
        public final int height;
        public final int width;
        public final Component label;

        ZoomButton(Supplier<Boolean> active, Supplier<Boolean> action, int uPosition, int vPosition, int width, int height, Component label) {
            this.active = active;
            this.action = action;
            this.uPosition = uPosition;
            this.vPosition = vPosition;
            this.height = height;
            this.width = width;
            this.label = label;
        }

        public Component getTooltip() {
            return this.label;
        }
    }
}

