/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zetter.client.gui.easel;

import java.util.function.Consumer;
import javax.annotation.Nullable;
import me.dantaeusb.zetter.client.gui.EaselScreen;
import me.dantaeusb.zetter.client.gui.easel.AbstractEaselWidget;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;

public class SliderWidget
extends AbstractEaselWidget
implements Renderable {
    static final int WIDTH = 150;
    static final int HEIGHT = 9;
    private float sliderState = 0.0f;
    private boolean sliderDragging = false;
    private BackgroundConsumer backgroundLambda;
    private ForegroundColorFunction foregroundLambda;
    private Consumer<Float> positionConsumer;

    public SliderWidget(EaselScreen parentScreen, int x, int y, Component translatableComponent, Consumer<Float> positionConsumer, @Nullable BackgroundConsumer backgroundLambda, @Nullable ForegroundColorFunction foregroundLambda) {
        super(parentScreen, x, y, 150, 9, translatableComponent);
        this.backgroundLambda = backgroundLambda;
        this.foregroundLambda = foregroundLambda;
        this.positionConsumer = positionConsumer;
    }

    public float getSliderState() {
        return this.sliderState;
    }

    public void setSliderState(float percent) {
        this.sliderState = percent;
    }

    @Override
    @Nullable
    public Component getTooltip(int mouseX, int mouseY) {
        return null;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        int iMouseX = (int)mouseX;
        int iMouseY = (int)mouseY;
        if (this.m_5953_(mouseX, mouseY)) {
            this.handleSliderInteraction(iMouseX, iMouseY);
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.sliderDragging) {
            int iMouseX = (int)mouseX;
            int iMouseY = (int)mouseY;
            this.handleSliderInteraction(iMouseX, iMouseY);
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (this.sliderDragging) {
            // empty if block
        }
        this.sliderDragging = false;
        return super.m_6348_(mouseX, mouseY, button);
    }

    public void m_87963_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.drawSliderBackground(guiGraphics);
        this.drawSliderForeground(guiGraphics);
        this.drawHandler(guiGraphics);
    }

    protected void drawSliderBackground(GuiGraphics guiGraphics) {
        int SLIDER_POSITION_U = 5;
        int SLIDER_POSITION_V = 80;
        int sliderV = 80;
        if (this.sliderDragging) {
            sliderV += 9;
        }
        guiGraphics.m_280218_(AbstractEaselWidget.EASEL_WIDGETS_TEXTURE_RESOURCE, this.m_252754_(), this.m_252907_(), 5, sliderV, 150, 9);
    }

    protected void drawSliderForeground(GuiGraphics guiGraphics) {
        int sliderContentGlobalLeft = this.m_252754_() + 3;
        int sliderContentGlobalTop = this.m_252907_() + 3;
        int sliderContentWidth = 144;
        int sliderContentHeight = 3;
        if (this.sliderDragging) {
            sliderContentGlobalTop -= 2;
            sliderContentHeight += 4;
            if (this.backgroundLambda != null) {
                this.backgroundLambda.accept(guiGraphics, sliderContentGlobalLeft, sliderContentGlobalTop, sliderContentWidth, sliderContentHeight);
            }
        } else if (this.backgroundLambda != null) {
            this.backgroundLambda.accept(guiGraphics, sliderContentGlobalLeft, sliderContentGlobalTop, sliderContentWidth, sliderContentHeight);
        }
        for (int i = 0; i < sliderContentWidth; ++i) {
            int color = this.foregroundLambda.accept((float)i / (float)sliderContentWidth);
            guiGraphics.m_280509_(sliderContentGlobalLeft + i, sliderContentGlobalTop, sliderContentGlobalLeft + i + 1, sliderContentGlobalTop + sliderContentHeight, color);
        }
    }

    protected void handleSliderInteraction(int mouseX, int mouseY) {
        this.sliderDragging = true;
        float percent = (float)(mouseX - this.m_252754_() - 3) / 143.0f;
        this.sliderState = percent = Mth.m_14036_((float)percent, (float)0.0f, (float)1.0f);
        this.positionConsumer.accept(Float.valueOf(percent));
    }

    protected void drawHandler(GuiGraphics guiGraphics) {
        boolean HANDLER_POSITION_U = false;
        int HANDLER_POSITION_V = 79;
        int HANDLER_WIDTH = 5;
        int HANDLER_HEIGHT = 11;
        int sliderContentWidth = 143;
        int sliderGlobalLeft = this.m_252754_() + (int)((float)sliderContentWidth * this.sliderState) + 3 - 2;
        int sliderGlobalTop = this.m_252907_() - 1;
        int sliderV = 79;
        if (this.sliderDragging) {
            sliderV += 11;
        }
        guiGraphics.m_280218_(AbstractEaselWidget.EASEL_WIDGETS_TEXTURE_RESOURCE, sliderGlobalLeft, sliderGlobalTop, 0, sliderV, 5, 11);
    }

    @FunctionalInterface
    public static interface BackgroundConsumer {
        public void accept(GuiGraphics var1, int var2, int var3, int var4, int var5);
    }

    @FunctionalInterface
    public static interface ForegroundColorFunction {
        public int accept(float var1);
    }
}

