/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zetter.client.gui.easel;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import me.dantaeusb.zetter.client.gui.EaselScreen;
import me.dantaeusb.zetter.client.gui.easel.AbstractEaselWidget;
import me.dantaeusb.zetter.menu.EaselMenu;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public class HistoryWidget
extends AbstractEaselWidget
implements Renderable {
    private final List<HistoryButton> buttons;
    public static final int UNDO_HOTKEY = 90;
    public static final int REDO_HOTKEY = 89;
    static final int HISTORY_BUTTON_WIDTH = 22;
    static final int HISTORY_BUTTON_HEIGHT = 13;
    static final int HISTORY_BUTTONS_U = 209;
    static final int HISTORY_BUTTONS_V = 210;

    public HistoryWidget(final EaselScreen parentScreen, int x, int y) {
        super(parentScreen, x, y, 24, 29, (Component)Component.m_237115_((String)"container.zetter.painting.history"));
        this.buttons = new ArrayList<HistoryButton>(){
            {
                this.add(new HistoryButton(((EaselMenu)parentScreen.m_6262_())::canUndo, ((EaselMenu)parentScreen.m_6262_())::undo, 209, 210, 22, 13, (Component)Component.m_237115_((String)"container.zetter.painting.history.undo")));
                this.add(new HistoryButton(((EaselMenu)parentScreen.m_6262_())::canRedo, ((EaselMenu)parentScreen.m_6262_())::redo, 209, 224, 22, 13, (Component)Component.m_237115_((String)"container.zetter.painting.history.redo")));
            }
        };
    }

    @Override
    @Nullable
    public Component getTooltip(int mouseX, int mouseY) {
        int i = 0;
        for (HistoryButton historyButton : this.buttons) {
            int fromY = this.m_252907_() + 1 + i * 13 + i;
            if (EaselScreen.isInRect(this.m_252754_() + 1, fromY, 22, 13, mouseX, mouseY)) {
                return historyButton.getTooltip();
            }
            ++i;
        }
        return null;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        int iMouseX = (int)mouseX;
        int iMouseY = (int)mouseY;
        if (!this.m_5953_(mouseX, mouseY)) {
            return false;
        }
        int i = 0;
        for (HistoryButton historyButton : this.buttons) {
            int fromY = this.m_252907_() + 1 + i * 13 + i;
            if (EaselScreen.isInRect(this.m_252754_() + 1, fromY, historyButton.width, historyButton.height, iMouseX, iMouseY) && this.m_7972_(button)) {
                historyButton.action.get();
                this.m_7435_(Minecraft.m_91087_().m_91106_());
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    protected void m_168797_(NarrationElementOutput narrationElementOutput) {
        narrationElementOutput.m_169146_(NarratedElementType.TITLE, (Component)this.m_5646_());
    }

    public void m_87963_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        guiGraphics.m_280218_(AbstractEaselWidget.EASEL_WIDGETS_TEXTURE_RESOURCE, this.m_252754_(), this.m_252907_(), 184, 209, 24, 13 * this.buttons.size() + 3);
        int i = 0;
        for (HistoryButton historyButton : this.buttons) {
            int fromY = this.m_252907_() + 1 + i * 13 + i;
            int uOffset = historyButton.uPosition + (historyButton.active.get() != false ? 0 : 24);
            guiGraphics.m_280218_(AbstractEaselWidget.EASEL_WIDGETS_TEXTURE_RESOURCE, this.m_252754_() + 1, fromY, uOffset, historyButton.vPosition, historyButton.width, historyButton.height);
            ++i;
        }
    }

    public boolean undo() {
        return false;
    }

    public boolean redo() {
        return false;
    }

    public class HistoryButton {
        public final Supplier<Boolean> active;
        public final Supplier<Boolean> action;
        public final int uPosition;
        public final int vPosition;
        public final int height;
        public final int width;
        public final Component label;

        HistoryButton(Supplier<Boolean> active, Supplier<Boolean> action, int uPosition, int vPosition, int width, int height, Component label) {
            this.active = active;
            this.action = action;
            this.uPosition = uPosition;
            this.vPosition = vPosition;
            this.height = height;
            this.width = width;
            this.label = label;
        }

        public Component getTooltip() {
            return this.label;
        }
    }
}

