/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.client.model.backpack;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3d;

public abstract class BackpackModel
extends Model {
    private static final Vector3d DEFAULT_OFFSET = new Vector3d(0.0, 9.0, -6.0);
    protected final ResourceLocation texture;
    protected final ModelPart backpack;
    protected final ModelPart bag;
    protected final ModelPart strap;

    public BackpackModel(ModelPart root, ResourceLocation texture) {
        this(root, texture, RenderType::m_110458_);
    }

    public BackpackModel(ModelPart root, ResourceLocation texture, Function<ResourceLocation, RenderType> renderType) {
        super(renderType);
        this.texture = texture;
        this.backpack = root.m_171324_("backpack");
        this.bag = this.backpack.m_171324_("bag");
        this.strap = this.bag.m_171324_("strap");
    }

    public void setupAngles(@Nullable Player player, int animationTick, float partialTick) {
    }

    public void transformToPlayerBody(ModelPart body, boolean armour) {
        ModelPart root = this.getRoot();
        root.m_104315_(body);
        ModelPart bag = this.getBag();
        bag.m_104227_(0.0f, -0.2f, 2.0f + (armour ? 1.0f : 0.0f));
        ModelPart straps = this.getStraps();
        straps.f_104207_ = !armour;
    }

    public void m_7695_(PoseStack matrixStack, VertexConsumer builder, int p_225598_3_, int p_225598_4_, float p_225598_5_, float p_225598_6_, float p_225598_7_, float p_225598_8_) {
        matrixStack.m_85841_(1.05f, 1.05f, 1.05f);
        this.getRoot().m_104301_(matrixStack, builder, p_225598_3_, p_225598_4_);
    }

    public void tickForPlayer(Vec3 pos, Player player) {
    }

    protected ModelPart getRoot() {
        return this.backpack;
    }

    public ModelPart getBag() {
        return this.bag;
    }

    public ModelPart getStraps() {
        return this.strap;
    }

    public ResourceLocation getTextureLocation() {
        return this.texture;
    }

    public Vector3d getShelfOffset() {
        return DEFAULT_OFFSET;
    }
}

