/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.entities.ai.tasks;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.Unit;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.phys.Vec3;
import net.orcinus.galosphere.entities.Berserker;
import net.orcinus.galosphere.init.GMemoryModuleTypes;
import net.orcinus.galosphere.init.GSoundEvents;

public class Smash
extends Behavior<Berserker> {
    private static final int DURATION = Mth.m_14167_((float)27.0f);
    private static final int MAX_DURATION = 60;

    public Smash() {
        super((Map)ImmutableMap.of((Object)((MemoryModuleType)GMemoryModuleTypes.RAMPAGE_TICKS.get()), (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.f_26371_, (Object)MemoryStatus.REGISTERED, (Object)MemoryModuleType.f_26372_, (Object)MemoryStatus.VALUE_PRESENT, (Object)MemoryModuleType.f_148205_, (Object)MemoryStatus.VALUE_PRESENT, (Object)((MemoryModuleType)GMemoryModuleTypes.IS_SMASHING.get()), (Object)MemoryStatus.REGISTERED, (Object)((MemoryModuleType)GMemoryModuleTypes.IS_IMPALING.get()), (Object)MemoryStatus.VALUE_ABSENT, (Object)((MemoryModuleType)GMemoryModuleTypes.IS_SUMMONING.get()), (Object)MemoryStatus.VALUE_ABSENT, (Object)((MemoryModuleType)GMemoryModuleTypes.SMASHING_COOLDOWN.get()), (Object)MemoryStatus.VALUE_ABSENT), 60);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean checkExtraStartConditions(ServerLevel serverLevel, Berserker livingEntity) {
        Optional memory = livingEntity.m_6274_().m_21952_(MemoryModuleType.f_26372_);
        if (!livingEntity.shouldAttack()) return false;
        if (!memory.filter(arg_0 -> ((Berserker)livingEntity).m_217066_(arg_0)).isPresent()) return false;
        return true;
    }

    protected boolean canStillUse(ServerLevel serverLevel, Berserker livingEntity, long l) {
        return true;
    }

    protected void start(ServerLevel serverLevel, Berserker livingEntity, long l) {
        Brain<Berserker> brain = livingEntity.m_6274_();
        brain.m_21882_(MemoryModuleType.f_26373_, (Object)true, (long)DURATION);
        brain.m_21882_((MemoryModuleType)GMemoryModuleTypes.IS_SMASHING.get(), (Object)Unit.INSTANCE, 60L);
        livingEntity.setPhase(Berserker.Phase.SMASH);
        livingEntity.m_5496_((SoundEvent)GSoundEvents.BERSERKER_DUO_SMASH.get(), 10.0f, 1.0f);
    }

    protected void tick(ServerLevel level, Berserker self, long l) {
        self.m_6274_().m_21952_(MemoryModuleType.f_26372_).ifPresent(target -> self.m_21563_().m_24964_(target.m_20182_()));
        self.m_6274_().m_21936_(MemoryModuleType.f_26370_);
        if (self.m_6274_().m_21874_(MemoryModuleType.f_26373_)) {
            return;
        }
        List<LivingEntity> list = level.m_45976_(LivingEntity.class, self.m_20191_().m_82400_(8.0)).stream().filter(self::canTargetEntity).filter(e -> e.m_20148_() != self.m_20148_()).toList();
        for (LivingEntity enemy : list) {
            Vec3 selfPos = self.m_20182_().m_82520_(0.0, (double)1.6f, 0.0);
            Vec3 enemyPos = enemy.m_146892_().m_82546_(selfPos);
            Vec3 normalizedDirection = enemyPos.m_82541_();
            double knockbackX = 0.5 * (1.0 - enemy.m_21133_(Attributes.f_22278_));
            double knockbackY = 2.5 * (1.0 - enemy.m_21133_(Attributes.f_22278_));
            double distanceFromEnemy = self.m_20270_((Entity)enemy);
            boolean canDamage = true;
            if (distanceFromEnemy > 3.0 && !enemy.m_20096_()) {
                canDamage = false;
            }
            if (!canDamage) continue;
            self.m_7327_((Entity)enemy);
            self.m_5634_(10.0f);
            enemy.m_5997_(normalizedDirection.m_7096_() * knockbackY, normalizedDirection.m_7098_() * knockbackX, normalizedDirection.m_7094_() * knockbackY);
        }
        self.m_9236_().m_7605_((Entity)self, (byte)32);
        self.m_6274_().m_21882_(MemoryModuleType.f_26373_, (Object)true, (long)(60 - DURATION));
    }

    protected void stop(ServerLevel serverLevel, Berserker livingEntity, long l) {
        livingEntity.setPhase(Berserker.Phase.IDLING);
    }
}

