/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.createtweaker.recipe.handler;

import com.blamejared.crafttweaker.api.fluid.IFluidStack;
import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.recipe.handler.IRecipeHandler;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import com.blamejared.crafttweaker.api.util.random.Percentaged;
import com.blamejared.createtweaker.CreateTweakerHelper;
import com.blamejared.createtweaker.recipe.handler.IProcessingRecipeHandler;
import com.blamejared.createtweaker.service.Services;
import com.mojang.datafixers.util.Either;
import com.simibubi.create.content.kinetics.mixer.MixingRecipe;
import com.simibubi.create.content.processing.recipe.ProcessingRecipe;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeBuilder;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import net.minecraft.world.item.crafting.Recipe;

@IRecipeHandler.For(value=MixingRecipe.class)
public class MixingRecipeHandler
implements IProcessingRecipeHandler<MixingRecipe> {
    public String dumpToCommandString(IRecipeManager iRecipeManager, MixingRecipe recipe) {
        List<IFluidStack> fluidResults = Services.PLATFORM.getRecipeFluidResults((ProcessingRecipe<?>)recipe);
        Either result = !fluidResults.isEmpty() ? Either.right((Object)fluidResults.get(0)) : Either.left(recipe.getRollableResults().stream().map(CreateTweakerHelper::mapProcessingResult));
        Object[] objectArray = new Object[6];
        objectArray[0] = recipe.m_6423_();
        objectArray[1] = recipe.getRequiredHeat().name().toLowerCase(Locale.ENGLISH);
        objectArray[2] = result.map(results -> results.map(Percentaged::getCommandString).collect(Collectors.joining(", ")), IFluidStack::getCommandString);
        objectArray[3] = recipe.m_7527_().stream().map(IIngredient::fromIngredient).map(IIngredient::getCommandString).collect(Collectors.joining(", "));
        objectArray[4] = recipe.getFluidIngredients().stream().map(Services.PLATFORM::getMatchingFluidStacks).flatMap(Collection::stream).map(IFluidStack::getCommandString).collect(Collectors.joining(", "));
        objectArray[5] = Services.PLATFORM.getRecipeFluidResults((ProcessingRecipe<?>)recipe).stream().map(IFluidStack::getCommandString).collect(Collectors.joining(", "));
        return String.format("<recipetype:create:mixing>.addRecipe(\"%s\", <constant:create:heat_condition:%s>, [%s], [%s], [%s], [%s]);", objectArray);
    }

    @Override
    public boolean isGoodRecipe(Recipe<?> recipe) {
        return recipe instanceof MixingRecipe;
    }

    @Override
    public ProcessingRecipeBuilder.ProcessingRecipeFactory<MixingRecipe> factory() {
        return MixingRecipe::new;
    }
}

