/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_model_features.models.animation.animation_math_parser;

import traben.entity_model_features.models.animation.animation_math_parser.MathComponent;
import traben.entity_model_features.utils.EMFManager;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum MathAction implements MathComponent
{
    ADD{

        @Override
        public float execute(MathComponent first, MathComponent second) {
            return first.get() + second.get();
        }
    }
    ,
    SUBTRACT{

        @Override
        public float execute(MathComponent first, MathComponent second) {
            return first.get() - second.get();
        }
    }
    ,
    MULTIPLY{

        @Override
        public float execute(MathComponent first, MathComponent second) {
            return first.get() * second.get();
        }
    }
    ,
    DIVIDE{

        @Override
        public float execute(MathComponent first, MathComponent second) {
            float sec = second.get();
            if (sec == 0.0f && !second.isConstant() && EMFManager.getInstance().isAnimationValidationPhase) {
                return first.get();
            }
            return first.get() / sec;
        }
    }
    ,
    DIVISION_REMAINDER{

        @Override
        public float execute(MathComponent first, MathComponent second) {
            float sec = second.get();
            if (sec == 0.0f && !second.isConstant() && EMFManager.getInstance().isAnimationValidationPhase) {
                return first.get();
            }
            return first.get() % sec;
        }
    }
    ,
    COMMA,
    OPEN_BRACKET,
    CLOSED_BRACKET,
    NONE,
    AND{

        @Override
        public float execute(MathComponent first, MathComponent second) {
            return first.get() == 1.0f && second.get() == 1.0f ? 1.0f : 0.0f;
        }
    }
    ,
    OR{

        @Override
        public float execute(MathComponent first, MathComponent second) {
            return first.get() == 1.0f || second.get() == 1.0f ? 1.0f : 0.0f;
        }
    }
    ,
    LARGER_THAN{

        @Override
        public float execute(MathComponent first, MathComponent second) {
            return first.get() > second.get() ? 1.0f : 0.0f;
        }
    }
    ,
    SMALLER_THAN{

        @Override
        public float execute(MathComponent first, MathComponent second) {
            return first.get() < second.get() ? 1.0f : 0.0f;
        }
    }
    ,
    LARGER_THAN_OR_EQUALS{

        @Override
        public float execute(MathComponent first, MathComponent second) {
            return first.get() >= second.get() ? 1.0f : 0.0f;
        }
    }
    ,
    SMALLER_THAN_OR_EQUALS{

        @Override
        public float execute(MathComponent first, MathComponent second) {
            return first.get() <= second.get() ? 1.0f : 0.0f;
        }
    }
    ,
    EQUALS{

        @Override
        public float execute(MathComponent first, MathComponent second) {
            return first.get() == second.get() ? 1.0f : 0.0f;
        }
    }
    ,
    NOT_EQUALS{

        @Override
        public float execute(MathComponent first, MathComponent second) {
            return first.get() != second.get() ? 1.0f : 0.0f;
        }
    }
    ,
    BOOLEAN_CHAR;


    public static MathAction getAction(char ch) {
        return switch (ch) {
            case '+' -> ADD;
            case '-' -> SUBTRACT;
            case '*' -> MULTIPLY;
            case '/' -> DIVIDE;
            case ',' -> COMMA;
            case '(' -> OPEN_BRACKET;
            case ')' -> CLOSED_BRACKET;
            case '%' -> DIVISION_REMAINDER;
            case '!', '&', '<', '=', '>', '|' -> BOOLEAN_CHAR;
            default -> NONE;
        };
    }

    public float execute(MathComponent first, MathComponent second) {
        return Float.NaN;
    }

    @Override
    public boolean isConstant() {
        return true;
    }

    @Override
    public float get() {
        System.out.println("ERROR: math action incorrectly called [" + this + "].");
        return Float.NaN;
    }
}

