/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.item;

import com.github.alexmodguy.alexscaves.AlexsCaves;
import com.github.alexmodguy.alexscaves.client.particle.ACParticleRegistry;
import com.github.alexmodguy.alexscaves.server.item.ACItemRegistry;
import com.github.alexmodguy.alexscaves.server.misc.ACSoundRegistry;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;

public class ResistorShieldItem
extends ShieldItem {
    public ResistorShieldItem() {
        super(new Item.Properties().m_41487_(1).m_41503_(1000).m_41497_(Rarity.UNCOMMON));
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept((IClientItemExtensions)AlexsCaves.PROXY.getISTERProperties());
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand interactionHand) {
        ItemStack itemstack = player.m_21120_(interactionHand);
        player.m_6672_(interactionHand);
        if (player.m_6144_()) {
            ResistorShieldItem.setPolarity(itemstack, !ResistorShieldItem.isScarlet(itemstack));
        }
        player.m_216990_((SoundEvent)ACSoundRegistry.RESITOR_SHIELD_SPIN.get());
        return InteractionResultHolder.m_19096_((Object)itemstack);
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add((Component)Component.m_237115_((String)"item.alexscaves.resistor_shield.desc").m_130940_(ChatFormatting.GRAY));
    }

    public void m_5929_(Level level, LivingEntity living, ItemStack stack, int timeUsing) {
        super.m_5929_(level, living, stack, timeUsing);
        int i = this.m_8105_(stack) - timeUsing;
        boolean scarlet = ResistorShieldItem.isScarlet(stack);
        boolean firstHit = i >= 10 && i <= 12;
        float range = 5.0f;
        if (level.f_46443_) {
            ResistorShieldItem.setUseTime(stack, i);
            if (i == 10) {
                living.m_216990_((SoundEvent)ACSoundRegistry.RESITOR_SHIELD_SLAM.get());
            }
            if (i >= 10 && i % 5 == 0) {
                AlexsCaves.PROXY.playWorldSound(living, (byte)(scarlet ? 9 : 10));
                Vec3 particlesFrom = living.m_20182_().m_82520_(0.0, 0.2, 0.0);
                float particleMax = 5 + living.m_217043_().m_188503_(5);
                int particles = 0;
                while ((float)particles < particleMax) {
                    Vec3 vec3 = new Vec3(((double)living.m_217043_().m_188501_() - 0.5) * (double)0.3f, ((double)living.m_217043_().m_188501_() - 0.5) * (double)0.3f, (double)(range * 0.5f + range * 0.5f * living.m_217043_().m_188501_())).m_82524_((float)((double)((float)particles / particleMax) * Math.PI * 2.0)).m_82549_(particlesFrom);
                    if (scarlet) {
                        level.m_7106_((ParticleOptions)ACParticleRegistry.SCARLET_SHIELD_LIGHTNING.get(), vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, particlesFrom.f_82479_, particlesFrom.f_82480_, particlesFrom.f_82481_);
                    } else {
                        level.m_7106_((ParticleOptions)ACParticleRegistry.AZURE_SHIELD_LIGHTNING.get(), particlesFrom.f_82479_, particlesFrom.f_82480_, particlesFrom.f_82481_, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
                    }
                    ++particles;
                }
            }
        }
        if (i >= 10 && i % 5 == 0) {
            AABB bashBox = living.m_20191_().m_82377_(5.0, 1.0, 5.0);
            for (LivingEntity entity : living.m_9236_().m_45976_(LivingEntity.class, bashBox)) {
                if (living.m_7307_((Entity)entity) || entity.equals((Object)living) || !(entity.m_20270_((Entity)living) <= range)) continue;
                entity.m_6469_(living.m_269291_().m_269333_(living), firstHit ? 6.0f : 2.0f);
                if (scarlet) {
                    entity.m_147240_(firstHit ? 0.5 : 0.2, entity.m_20185_() - living.m_20185_(), entity.m_20189_() - living.m_20189_());
                    continue;
                }
                entity.m_147240_(firstHit ? 0.5 : 0.2, living.m_20185_() - living.m_20185_(), living.m_20189_() - entity.m_20189_());
            }
        }
        if (i == 10 && !level.f_46443_) {
            stack.m_41622_(1, living, player1 -> player1.m_21190_(player1.m_7655_()));
        }
    }

    public boolean m_6832_(ItemStack item, ItemStack repairItem) {
        return repairItem.m_150930_((Item)ACItemRegistry.SCARLET_NEODYMIUM_INGOT.get()) || repairItem.m_150930_((Item)ACItemRegistry.AZURE_NEODYMIUM_INGOT.get()) || super.m_6832_(item, repairItem);
    }

    public void m_5551_(ItemStack stack, Level level, LivingEntity player, int useTimeLeft) {
        super.m_5551_(stack, level, player, useTimeLeft);
        AlexsCaves.PROXY.clearSoundCacheFor((Entity)player);
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int i, boolean held) {
        LivingEntity living;
        super.m_6883_(stack, level, entity, i, held);
        if (ResistorShieldItem.getUseTime(stack) != 0 && entity instanceof LivingEntity && !(living = (LivingEntity)entity).m_21211_().equals(stack)) {
            ResistorShieldItem.setUseTime(stack, 0);
            stack.m_41784_().m_128405_("PrevUseTime", 0);
        }
        if (level.f_46443_) {
            boolean scarlet = ResistorShieldItem.isScarlet(stack);
            int switchTime = ResistorShieldItem.getSwitchTime(stack);
            CompoundTag tag = stack.m_41784_();
            if (tag.m_128451_("PrevSwitchTime") != tag.m_128451_("SwitchTime")) {
                tag.m_128405_("PrevSwitchTime", ResistorShieldItem.getSwitchTime(stack));
            }
            if (scarlet && (float)switchTime < 5.0f) {
                ResistorShieldItem.setSwitchTime(stack, switchTime + 1);
            }
            if (!scarlet && (float)switchTime > 0.0f) {
                ResistorShieldItem.setSwitchTime(stack, switchTime - 1);
            }
        }
    }

    public static void setUseTime(ItemStack stack, int useTime) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128405_("PrevUseTime", ResistorShieldItem.getUseTime(stack));
        tag.m_128405_("UseTime", useTime);
    }

    public static void setSwitchTime(ItemStack stack, int useTime) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128405_("PrevSwitchTime", ResistorShieldItem.getSwitchTime(stack));
        tag.m_128405_("SwitchTime", useTime);
    }

    public static void setPolarity(ItemStack stack, boolean scarlet) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128379_("Polarity", scarlet);
    }

    public static int getUseTime(ItemStack stack) {
        CompoundTag compoundtag = stack.m_41783_();
        return compoundtag != null ? compoundtag.m_128451_("UseTime") : 0;
    }

    public static float getLerpedUseTime(ItemStack stack, float f) {
        CompoundTag compoundtag = stack.m_41783_();
        float prev = compoundtag != null ? (float)compoundtag.m_128451_("PrevUseTime") : 0.0f;
        float current = compoundtag != null ? (float)compoundtag.m_128451_("UseTime") : 0.0f;
        return prev + f * (current - prev);
    }

    public static int getSwitchTime(ItemStack stack) {
        CompoundTag compoundtag = stack.m_41783_();
        return compoundtag != null ? compoundtag.m_128451_("SwitchTime") : 0;
    }

    public static float getLerpedSwitchTime(ItemStack stack, float f) {
        CompoundTag compoundtag = stack.m_41783_();
        float prev = compoundtag != null ? (float)compoundtag.m_128451_("PrevSwitchTime") : 0.0f;
        float current = compoundtag != null ? (float)compoundtag.m_128451_("SwitchTime") : 0.0f;
        return prev + f * (current - prev);
    }

    public static boolean isScarlet(ItemStack stack) {
        CompoundTag compoundtag = stack.m_41783_();
        return compoundtag != null ? compoundtag.m_128471_("Polarity") : false;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return !oldStack.m_150930_((Item)ACItemRegistry.RESISTOR_SHIELD.get()) || !newStack.m_150930_((Item)ACItemRegistry.RESISTOR_SHIELD.get());
    }
}

