/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.item;

import com.github.alexmodguy.alexscaves.AlexsCaves;
import com.github.alexmodguy.alexscaves.server.entity.item.WaveEntity;
import com.github.alexmodguy.alexscaves.server.misc.ACSoundRegistry;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.Vanishable;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;

public class OrtholanceItem
extends Item
implements Vanishable {
    private final Multimap<Attribute, AttributeModifier> defaultModifiers;

    public OrtholanceItem(Item.Properties properties) {
        super(properties);
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Tool modifier", 5.0, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Tool modifier", (double)-2.4f, AttributeModifier.Operation.ADDITION));
        this.defaultModifiers = builder.build();
    }

    public UseAnim m_6164_(ItemStack p_43417_) {
        return UseAnim.BOW;
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot equipmentSlot) {
        return equipmentSlot == EquipmentSlot.MAINHAND ? this.defaultModifiers : super.m_7167_(equipmentSlot);
    }

    public int m_6473_() {
        return 1;
    }

    public int m_8105_(ItemStack itemStack) {
        return 72000;
    }

    public void m_5551_(ItemStack stack, Level level, LivingEntity livingEntity, int useTime) {
        int i = Mth.m_14045_((int)(this.m_8105_(stack) - useTime), (int)0, (int)60);
        if (i > 0) {
            float f = 0.1f * (float)i;
            Vec3 vec3 = livingEntity.m_20184_().m_82549_(livingEntity.m_20252_(1.0f).m_82541_().m_82542_((double)f, (double)(f * 0.15f), (double)f));
            if (i >= 10 && !level.f_46443_) {
                level.m_6269_(null, (Entity)livingEntity, (SoundEvent)ACSoundRegistry.ORTHOLANCE_WAVE.get(), SoundSource.NEUTRAL, 4.0f, 1.0f);
                stack.m_41622_(1, livingEntity, player1 -> player1.m_21190_(player1.m_7655_()));
                int maxWaves = i / 5;
                for (int wave = 0; wave < maxWaves; ++wave) {
                    float f1 = (float)wave / (float)maxWaves;
                    int lifespan = 3 + (int)((1.0f - f1) * 3.0f);
                    Vec3 waveCenterPos = livingEntity.m_20182_().m_82549_(vec3.m_82490_((double)(f1 * 2.0f)));
                    WaveEntity leftWaveEntity = new WaveEntity(level, livingEntity);
                    leftWaveEntity.m_6034_(waveCenterPos.f_82479_, livingEntity.m_20186_(), waveCenterPos.f_82481_);
                    leftWaveEntity.setLifespan(lifespan);
                    leftWaveEntity.m_146922_(-((float)(Mth.m_14136_((double)vec3.f_82479_, (double)vec3.f_82481_) * 57.2957763671875)) + 60.0f - (float)(15 * wave));
                    level.m_7967_((Entity)leftWaveEntity);
                    WaveEntity rightWaveEntity = new WaveEntity(level, livingEntity);
                    rightWaveEntity.m_6034_(waveCenterPos.f_82479_, livingEntity.m_20186_(), waveCenterPos.f_82481_);
                    rightWaveEntity.setLifespan(lifespan);
                    rightWaveEntity.m_146922_(-((float)(Mth.m_14136_((double)vec3.f_82479_, (double)vec3.f_82481_) * 57.2957763671875)) - 60.0f + (float)(15 * wave));
                    level.m_7967_((Entity)rightWaveEntity);
                }
                AABB aabb = new AABB(livingEntity.m_20182_(), livingEntity.m_20182_().m_82549_(vec3.m_82490_((double)maxWaves))).m_82400_(1.0);
                DamageSource source = livingEntity.m_269291_().m_269333_(livingEntity);
                double d = 0.0;
                for (AttributeModifier modifier : stack.m_41638_(EquipmentSlot.MAINHAND).get((Object)Attributes.f_22281_)) {
                    d += modifier.m_22218_();
                }
                for (LivingEntity entity : level.m_45976_(LivingEntity.class, aabb)) {
                    if (livingEntity.m_7307_((Entity)entity) || livingEntity.equals((Object)entity) || !livingEntity.m_142582_((Entity)entity)) continue;
                    entity.m_6469_(source, (float)d);
                    entity.m_8127_();
                }
            }
            livingEntity.m_20256_(vec3.m_82520_(0.0, livingEntity.m_20096_() ? (double)0.2f : 0.0, 0.0));
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand interactionHand) {
        ItemStack itemstack = player.m_21120_(interactionHand);
        if (itemstack.m_41773_() >= itemstack.m_41776_() - 1) {
            return InteractionResultHolder.m_19100_((Object)itemstack);
        }
        player.m_6672_(interactionHand);
        return InteractionResultHolder.m_19096_((Object)itemstack);
    }

    public boolean m_7579_(ItemStack stack, LivingEntity livingEntity, LivingEntity livingEntity1) {
        stack.m_41622_(1, livingEntity1, entity -> entity.m_21166_(EquipmentSlot.MAINHAND));
        return true;
    }

    public boolean m_6813_(ItemStack itemStack, Level level, BlockState state, BlockPos blockPos, LivingEntity livingEntity) {
        if ((double)state.m_60800_((BlockGetter)level, blockPos) != 0.0) {
            itemStack.m_41622_(2, livingEntity, entity -> entity.m_21166_(EquipmentSlot.MAINHAND));
        }
        return true;
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept((IClientItemExtensions)AlexsCaves.PROXY.getISTERProperties());
    }
}

