/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.item;

import com.github.alexmodguy.alexscaves.AlexsCaves;
import com.github.alexmodguy.alexscaves.client.particle.ACParticleRegistry;
import com.github.alexmodguy.alexscaves.server.entity.item.DarkArrowEntity;
import com.github.alexmodguy.alexscaves.server.item.ACItemRegistry;
import com.github.alexmodguy.alexscaves.server.misc.ACSoundRegistry;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.registries.ForgeRegistries;

public class DreadbowItem
extends ProjectileWeaponItem {
    public static final int LOAD_TIME = 40;

    public DreadbowItem() {
        super(new Item.Properties().m_41497_(ACItemRegistry.RARITY_DEMONIC).m_41503_(500));
    }

    @Nullable
    public static EntityType getTypeOfArrow(ItemStack itemStackIn) {
        if (itemStackIn.m_41783_() != null && itemStackIn.m_41783_().m_128441_("LastUsedArrowType")) {
            String str = itemStackIn.m_41783_().m_128461_("LastUsedArrowType");
            return (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation(str));
        }
        return null;
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept((IClientItemExtensions)AlexsCaves.PROXY.getISTERProperties());
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand interactionHand) {
        ItemStack itemstack = player.m_21120_(interactionHand);
        ItemStack ammo = player.m_6298_(itemstack);
        boolean flag = player.m_7500_();
        if (flag || !ammo.m_41619_()) {
            AbstractArrow lastArrow = this.createArrow(player, itemstack, ItemStack.f_41583_);
            EntityType lastArrowType = lastArrow == null ? EntityType.f_20548_ : lastArrow.m_6095_();
            itemstack.m_41784_().m_128359_("LastUsedArrowType", ForgeRegistries.ENTITY_TYPES.getKey((Object)lastArrowType).toString());
            player.m_6672_(interactionHand);
            return InteractionResultHolder.m_19096_((Object)itemstack);
        }
        return InteractionResultHolder.m_19100_((Object)itemstack);
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int i, boolean held) {
        LivingEntity living;
        super.m_6883_(stack, level, entity, i, held);
        boolean using = entity instanceof LivingEntity && (living = (LivingEntity)entity).m_21211_().equals(stack);
        int useTime = DreadbowItem.getUseTime(stack);
        if (level.f_46443_) {
            CompoundTag tag = stack.m_41784_();
            if (tag.m_128451_("PrevUseTime") != tag.m_128451_("UseTime")) {
                tag.m_128405_("PrevUseTime", DreadbowItem.getUseTime(stack));
            }
            if (using && useTime < 40) {
                DreadbowItem.setUseTime(stack, useTime + 1);
            }
            if (!using && (float)useTime > 0.0f) {
                DreadbowItem.setUseTime(stack, Math.max(0, useTime - 5));
            }
            if (using) {
                Vec3 particlePos = entity.m_20182_().m_82520_((double)((level.f_46441_.m_188501_() - 0.5f) * 2.5f), 0.0, (double)((level.f_46441_.m_188501_() - 0.5f) * 2.5f));
                level.m_7106_((ParticleOptions)ACParticleRegistry.UNDERZEALOT_MAGIC.get(), particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, entity.m_20185_(), entity.m_20227_(0.5), entity.m_20189_());
            }
        }
    }

    public static int getUseTime(ItemStack stack) {
        CompoundTag compoundtag = stack.m_41783_();
        return compoundtag != null ? compoundtag.m_128451_("UseTime") : 0;
    }

    public static void setUseTime(ItemStack stack, int useTime) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128405_("PrevUseTime", DreadbowItem.getUseTime(stack));
        tag.m_128405_("UseTime", useTime);
    }

    public static float getLerpedUseTime(ItemStack stack, float f) {
        CompoundTag compoundtag = stack.m_41783_();
        float prev = compoundtag != null ? (float)compoundtag.m_128451_("PrevUseTime") : 0.0f;
        float current = compoundtag != null ? (float)compoundtag.m_128451_("UseTime") : 0.0f;
        return prev + f * (current - prev);
    }

    public static float getPullingAmount(ItemStack itemStack, float partialTicks) {
        return Math.min(DreadbowItem.getLerpedUseTime(itemStack, partialTicks) / 40.0f, 1.0f);
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BOW;
    }

    public static float getPowerForTime(int i) {
        float f = (float)i / 40.0f;
        if ((f = (f * f + f * 2.0f) / 3.0f) > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    public void m_5551_(ItemStack itemStack, Level level, LivingEntity livingEntity, int i1) {
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            int i = this.m_8105_(itemStack) - i1;
            float f = DreadbowItem.getPowerForTime(i);
            if ((double)f > 0.1) {
                player.m_216990_((SoundEvent)ACSoundRegistry.DREADBOW_RELEASE.get());
                ItemStack ammoStack = player.m_6298_(itemStack);
                AbstractArrow abstractArrow = this.createArrow(player, itemStack, ammoStack);
                if (abstractArrow != null) {
                    float maxDist = 128.0f * f;
                    HitResult realHitResult = ProjectileUtil.m_278180_((Entity)player, Entity::m_271807_, (double)maxDist);
                    if (realHitResult.m_6662_() == HitResult.Type.MISS) {
                        realHitResult = ProjectileUtil.m_278180_((Entity)player, Entity::m_271807_, (double)(f * 42.0f));
                    }
                    BlockPos.MutableBlockPos mutableSkyPos = new BlockPos.MutableBlockPos(realHitResult.m_82450_().f_82479_, realHitResult.m_82450_().f_82480_ + 1.5, realHitResult.m_82450_().f_82481_);
                    int maxFallHeight = 15;
                    for (int k = 0; mutableSkyPos.m_123342_() < level.m_151558_() && level.m_46859_((BlockPos)mutableSkyPos) && k < maxFallHeight; ++k) {
                        mutableSkyPos = mutableSkyPos.m_7494_();
                    }
                    boolean darkArrows = DreadbowItem.isConvertibleArrow((Entity)abstractArrow);
                    int maxArrows = darkArrows ? 30 : 8;
                    abstractArrow.f_36705_ = AbstractArrow.Pickup.ALLOWED;
                    int j = 0;
                    while ((double)j < Math.ceil((float)maxArrows * f)) {
                        if (darkArrows) {
                            abstractArrow = new DarkArrowEntity(level, livingEntity);
                        }
                        Vec3 vec3 = mutableSkyPos.m_252807_().m_82520_((double)(level.f_46441_.m_188501_() * 16.0f - 8.0f), (double)(level.f_46441_.m_188501_() * 4.0f - 2.0f), (double)(level.f_46441_.m_188501_() * 16.0f - 8.0f));
                        for (int clearTries = 0; clearTries < 6 && !level.m_46859_(BlockPos.m_274446_((Position)vec3)) && level.m_6425_(BlockPos.m_274446_((Position)vec3)).m_76178_(); ++clearTries) {
                            vec3 = mutableSkyPos.m_252807_().m_82520_((double)(level.f_46441_.m_188501_() * 16.0f - 8.0f), (double)(level.f_46441_.m_188501_() * 4.0f - 2.0f), (double)(level.f_46441_.m_188501_() * 16.0f - 8.0f));
                        }
                        if (!level.m_46859_(BlockPos.m_274446_((Position)vec3)) && level.m_6425_(BlockPos.m_274446_((Position)vec3)).m_76178_()) {
                            vec3 = mutableSkyPos.m_252807_();
                        }
                        abstractArrow.m_146884_(vec3);
                        Vec3 vec31 = realHitResult.m_82450_().m_82546_(vec3);
                        float randomness = (darkArrows ? 20.0f : 5.0f) + level.f_46441_.m_188501_() * 10.0f;
                        if (level.f_46441_.m_188501_() < 0.25f) {
                            randomness = level.f_46441_.m_188501_();
                        }
                        abstractArrow.m_6686_(vec31.f_82479_, vec31.f_82480_, vec31.f_82481_, 0.5f + 1.5f * level.f_46441_.m_188501_(), randomness);
                        level.m_7967_((Entity)abstractArrow);
                        abstractArrow = this.createArrow(player, itemStack, ammoStack);
                        abstractArrow.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
                        ++j;
                    }
                    if (darkArrows) {
                        Vec3 vec3 = realHitResult.m_82450_();
                        level.m_6263_((Player)null, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, (SoundEvent)ACSoundRegistry.DREADBOW_RAIN.get(), SoundSource.PLAYERS, 12.0f, 1.0f);
                    }
                    if (!player.m_7500_()) {
                        ammoStack.m_41774_(1);
                        itemStack.m_41622_(1, (LivingEntity)player, player1 -> player1.m_21190_(player1.m_7655_()));
                    }
                }
            }
        }
    }

    private AbstractArrow createArrow(Player player, ItemStack bowStack, ItemStack ammoIn) {
        ItemStack ammo = ammoIn.m_41619_() ? player.m_6298_(bowStack) : ammoIn;
        ArrowItem arrowitem = (ArrowItem)(ammo.m_41720_() instanceof ArrowItem ? ammo.m_41720_() : Items.f_42412_);
        AbstractArrow abstractArrow = arrowitem.m_6394_(player.m_9236_(), ammo, (LivingEntity)player);
        return abstractArrow;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return !oldStack.m_150930_((Item)ACItemRegistry.DREADBOW.get()) || !newStack.m_150930_((Item)ACItemRegistry.DREADBOW.get());
    }

    public static boolean isConvertibleArrow(Entity arrowEntity) {
        Arrow arrow;
        return arrowEntity instanceof Arrow && (arrow = (Arrow)arrowEntity).m_36889_() == -1;
    }

    public Predicate<ItemStack> m_6437_() {
        return f_43005_;
    }

    public int m_6615_() {
        return 64;
    }
}

