/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.entity.living;

import com.github.alexmodguy.alexscaves.AlexsCaves;
import com.github.alexmodguy.alexscaves.server.entity.ai.MobTarget3DGoal;
import com.github.alexmodguy.alexscaves.server.entity.living.BoundroidWinchEntity;
import com.github.alexmodguy.alexscaves.server.misc.ACSoundRegistry;
import com.github.alexmodguy.alexscaves.server.potion.ACEffectRegistry;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BoundroidEntity
extends Monster {
    private static final EntityDataAccessor<Optional<UUID>> WINCH_UUID = SynchedEntityData.m_135353_(BoundroidEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Integer> WINCH_ID = SynchedEntityData.m_135353_(BoundroidEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> SLAMMING = SynchedEntityData.m_135353_(BoundroidEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> SCARED = SynchedEntityData.m_135353_(BoundroidEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private float groundProgress;
    private float prevGroundProgress;
    public boolean draggedClimable = false;
    public boolean stopGravity = false;
    public int stopSlammingFor = 0;
    private int stayOnGroundFor = 0;
    private static final AttributeModifier REMOVED_GRAVITY_MODIFIER = new AttributeModifier(UUID.fromString("B5B6CF2A-2F7C-31EF-9022-7C3E7D5E6BBA"), "remove gravity reduction", -0.08, AttributeModifier.Operation.ADDITION);

    public BoundroidEntity(EntityType<? extends Monster> entityType, Level level) {
        super(entityType, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22281_, 5.0).m_22268_(Attributes.f_22284_, 20.0).m_22268_(Attributes.f_22279_, 0.2).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22276_, 20.0);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 15.0f));
        this.f_21345_.m_25352_(1, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new MobTarget3DGoal((Mob)this, Player.class, true));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(WINCH_UUID, Optional.empty());
        this.f_19804_.m_135372_(WINCH_ID, (Object)-1);
        this.f_19804_.m_135372_(SCARED, (Object)false);
        this.f_19804_.m_135372_(SLAMMING, (Object)false);
    }

    @Nullable
    public UUID getWinchUUID() {
        return ((Optional)this.f_19804_.m_135370_(WINCH_UUID)).orElse(null);
    }

    public void setWinchUUID(@Nullable UUID uniqueId) {
        this.f_19804_.m_135381_(WINCH_UUID, Optional.ofNullable(uniqueId));
    }

    public Entity getWinch() {
        if (!this.m_9236_().f_46443_) {
            UUID id = this.getWinchUUID();
            return id == null ? null : ((ServerLevel)this.m_9236_()).m_8791_(id);
        }
        int id = (Integer)this.f_19804_.m_135370_(WINCH_ID);
        return id == -1 ? null : this.m_9236_().m_6815_(id);
    }

    public void m_8119_() {
        super.m_8119_();
        this.prevGroundProgress = this.groundProgress;
        this.f_20883_ = this.m_146908_();
        if (this.m_20096_() && this.groundProgress < 5.0f) {
            this.groundProgress += 1.0f;
        }
        if (!this.m_20096_() && this.groundProgress > 0.0f) {
            this.groundProgress -= 1.0f;
        }
        if (!this.m_9236_().f_46443_) {
            Vec3 distanceVec;
            Entity winch = this.getWinch();
            if (winch == null) {
                LivingEntity created = this.createWinch();
                this.m_9236_().m_7967_((Entity)created);
                this.setWinchUUID(created.m_20148_());
                this.f_19804_.m_135381_(WINCH_ID, (Object)created.m_19879_());
            } else if (winch instanceof BoundroidWinchEntity) {
                BoundroidWinchEntity winchEntity = (BoundroidWinchEntity)winch;
                winchEntity.linkWithHead((Entity)this);
            }
            LivingEntity target = this.m_5448_();
            if (target != null && target.m_6084_() && (distanceVec = target.m_20182_().m_82546_(this.m_20182_())).m_165924_() < 1.2 && this.stopSlammingFor == 0) {
                this.setSlamming(true);
            }
            if (this.isSlamming()) {
                this.m_20256_(new Vec3(this.m_20184_().f_82479_, -1.0, this.m_20184_().f_82481_));
                if (this.m_20096_()) {
                    this.setSlamming(false);
                    this.m_216990_((SoundEvent)ACSoundRegistry.BOUNDROID_SLAM.get());
                    this.stayOnGroundFor = 10;
                    this.stopSlammingFor = 30 + this.f_19796_.m_188503_(20);
                    this.m_9236_().m_7605_((Entity)this, (byte)45);
                    AABB bashBox = new AABB(-1.5, -2.0, -1.5, 1.5, 1.0, 1.5);
                    bashBox = bashBox.m_82383_(this.m_20182_());
                    for (Entity entity : this.m_9236_().m_45976_(LivingEntity.class, bashBox)) {
                        if (this.m_7307_(entity) || entity instanceof BoundroidEntity || entity instanceof BoundroidWinchEntity) continue;
                        entity.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), 5.0f);
                    }
                }
            }
        } else if (this.m_6084_()) {
            AlexsCaves.PROXY.playWorldSound((Object)this, (byte)12);
        }
        if (this.stopSlammingFor > 0) {
            --this.stopSlammingFor;
        }
        if (this.stayOnGroundFor > 0) {
            --this.stayOnGroundFor;
        }
    }

    public void m_7822_(byte b) {
        if (b == 45) {
            this.spawnGroundEffects();
        } else {
            super.m_7822_(b);
        }
    }

    public void m_142687_(Entity.RemovalReason removalReason) {
        AlexsCaves.PROXY.clearSoundCacheFor((Entity)this);
        super.m_142687_(removalReason);
    }

    public void spawnGroundEffects() {
        float radius = 1.35f;
        for (int i = 0; i < 4; ++i) {
            for (int i1 = 0; i1 < 10 + this.f_19796_.m_188503_(10); ++i1) {
                double motionX = this.m_217043_().m_188583_() * 0.07;
                double motionY = this.m_217043_().m_188583_() * 0.07;
                double motionZ = this.m_217043_().m_188583_() * 0.07;
                float angle = (float)Math.PI / 180 * this.f_20883_ + (float)i1;
                double extraX = radius * Mth.m_14031_((float)((float)(Math.PI + (double)angle)));
                double extraY = 0.8f;
                double extraZ = radius * Mth.m_14089_((float)angle);
                Vec3 center = this.m_20182_().m_82549_(new Vec3(0.0, 3.0, 0.0).m_82524_((float)Math.toRadians(-this.f_20883_)));
                BlockPos ground = BlockPos.m_274446_((Position)this.getGroundBelowPosition(new Vec3((double)Mth.m_14107_((double)(center.f_82479_ + extraX)), (double)(Mth.m_14107_((double)(center.f_82480_ + extraY)) - 1), (double)Mth.m_14107_((double)(center.f_82481_ + extraZ)))));
                BlockState state = this.m_9236_().m_8055_(ground);
                if (!state.m_280296_() || !this.m_9236_().f_46443_) continue;
                this.m_9236_().m_6493_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, state), true, center.f_82479_ + extraX, (double)ground.m_123342_() + extraY, center.f_82481_ + extraZ, motionX, motionY, motionZ);
            }
        }
    }

    private Vec3 getGroundBelowPosition(Vec3 in) {
        Optional closest;
        BlockPos pos = BlockPos.m_274446_((Position)in);
        while (pos.m_123342_() > this.m_9236_().m_141937_() && this.m_9236_().m_8055_(pos).m_60812_((BlockGetter)this.m_9236_(), pos).m_83281_()) {
            pos = pos.m_7495_();
        }
        BlockState state = this.m_9236_().m_8055_(pos);
        VoxelShape shape = state.m_60812_((BlockGetter)this.m_9236_(), pos);
        float top = shape.m_83281_() ? 0.0f : ((closest = shape.m_166067_(this.m_20182_())).isPresent() ? (float)((Vec3)closest.get()).f_82480_ : 0.0f);
        return Vec3.m_82514_((Vec3i)pos, (double)top);
    }

    public boolean m_6147_() {
        return super.m_6147_() || this.f_19862_ && this.draggedClimable;
    }

    public float getGroundProgress(float partialTicks) {
        return (this.prevGroundProgress + (this.groundProgress - this.prevGroundProgress) * partialTicks) * 0.2f;
    }

    protected void m_7840_(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public boolean m_6673_(DamageSource damageSource) {
        return super.m_6673_(damageSource) || damageSource.m_276093_(DamageTypes.f_268612_);
    }

    public boolean isScared() {
        return (Boolean)this.f_19804_.m_135370_(SCARED);
    }

    public void setScared(boolean scared) {
        this.f_19804_.m_135381_(SCARED, (Object)scared);
    }

    public boolean isSlamming() {
        return (Boolean)this.f_19804_.m_135370_(SLAMMING);
    }

    public boolean stopPullingUp() {
        return this.isSlamming() || this.stayOnGroundFor > 0;
    }

    public void setSlamming(boolean slamming) {
        this.f_19804_.m_135381_(SLAMMING, (Object)slamming);
    }

    public boolean m_7301_(MobEffectInstance effectInstance) {
        return super.m_7301_(effectInstance) && effectInstance.m_19544_() != ACEffectRegistry.MAGNETIZING.get();
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128403_("WinchUUID")) {
            this.setWinchUUID(compound.m_128342_("WinchUUID"));
        }
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        if (this.getWinchUUID() != null) {
            compound.m_128362_("WinchUUID", this.getWinchUUID());
        }
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ACSoundRegistry.BOUNDROID_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)ACSoundRegistry.BOUNDROID_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ACSoundRegistry.BOUNDROID_DEATH.get();
    }

    private LivingEntity createWinch() {
        return new BoundroidWinchEntity(this);
    }
}

