/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.entity.item;

import com.github.alexmodguy.alexscaves.server.entity.ACEntityRegistry;
import com.github.alexmodguy.alexscaves.server.item.ACItemRegistry;
import com.github.alexmodguy.alexscaves.server.misc.ACDamageTypes;
import com.github.alexmodguy.alexscaves.server.misc.ACSoundRegistry;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;

public class DesolateDaggerEntity
extends Entity {
    private static final EntityDataAccessor<Integer> TARGET_ID = SynchedEntityData.m_135353_(DesolateDaggerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> STAB = SynchedEntityData.m_135353_(DesolateDaggerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Integer> PLAYER_ID = SynchedEntityData.m_135353_(DesolateDaggerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected final RandomSource orbitRandom = RandomSource.m_216327_();
    private float orbitOffset = 0.0f;
    private float prevStab = 0.0f;
    private int orbitFor = 20;
    public ItemStack daggerStack = new ItemStack((ItemLike)ACItemRegistry.DESOLATE_DAGGER.get());
    private int lSteps;
    private double lx;
    private double ly;
    private double lz;
    private double lyr;
    private double lxr;
    private double lxd;
    private double lyd;
    private double lzd;
    private boolean playedSummonNoise = false;

    public DesolateDaggerEntity(EntityType<?> entityType, Level level) {
        super(entityType, level);
        this.orbitFor = 20 + level.f_46441_.m_188503_(10);
    }

    public DesolateDaggerEntity(PlayMessages.SpawnEntity spawnEntity, Level level) {
        this((EntityType)ACEntityRegistry.DESOLATE_DAGGER.get(), level);
        this.m_20011_(this.m_142242_());
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void m_8119_() {
        super.m_8119_();
        this.prevStab = this.getStab();
        Entity entity = this.getTargetEntity();
        if (this.m_9236_().f_46443_) {
            this.m_9236_().m_7106_((ParticleOptions)DustParticleOptions.f_123656_, this.m_20208_(0.75), this.m_20187_(), this.m_20262_(0.75), 0.0, 0.0, 0.0);
        }
        if (!this.playedSummonNoise) {
            this.m_216990_((SoundEvent)ACSoundRegistry.DESOLATE_DAGGER_SUMMON.get());
            this.playedSummonNoise = true;
        }
        if (entity != null) {
            this.f_19794_ = true;
            float invStab = 1.0f - this.getStab();
            Vec3 orbitAround = entity.m_20182_().m_82520_(0.0, (double)(entity.m_20206_() * 0.25f), 0.0);
            this.orbitRandom.m_188584_((long)this.m_19879_());
            if (this.orbitOffset == 0.0f) {
                this.orbitOffset = this.orbitRandom.m_188503_(360);
            }
            Vec3 orbitAdd = new Vec3(0.0, (double)((this.orbitRandom.m_188501_() + entity.m_20206_()) * invStab), (double)((this.orbitRandom.m_188501_() + entity.m_20205_()) * invStab)).m_82524_((float)Math.toRadians(this.orbitOffset));
            this.m_20256_(orbitAround.m_82549_(orbitAdd).m_82546_(this.m_20182_()));
            if (!this.m_9236_().f_46443_) {
                if (this.orbitFor > 0 && entity.m_6084_()) {
                    --this.orbitFor;
                } else {
                    this.setStab(Math.min(this.getStab() + 0.2f, 1.0f));
                }
                if (this.getStab() >= 1.0f) {
                    DesolateDaggerEntity damageFrom;
                    Entity player = this.getPlayer();
                    DesolateDaggerEntity desolateDaggerEntity = damageFrom = player == null ? this : player;
                    if (entity.m_6469_(ACDamageTypes.causeDesolateDaggerDamage(this.m_9236_().m_9598_(), damageFrom), 2.0f)) {
                        this.m_216990_((SoundEvent)ACSoundRegistry.DESOLATE_DAGGER_HIT.get());
                    }
                    this.m_146870_();
                }
            }
            double d1 = entity.m_20189_() - this.m_20189_();
            double d3 = entity.m_20188_() - this.m_20188_();
            double d2 = entity.m_20185_() - this.m_20185_();
            float f = Mth.m_14116_((float)((float)(d2 * d2 + d1 * d1)));
            this.m_146922_(-((float)Mth.m_14136_((double)d2, (double)d1)) * 57.295776f);
            this.m_146926_(-((float)(Mth.m_14136_((double)d3, (double)f) * 57.2957763671875)));
        } else if (this.f_19797_ > 3) {
            this.f_19794_ = false;
            this.m_146870_();
        }
        this.m_6478_(MoverType.SELF, this.m_20184_());
        this.m_20256_(this.m_20184_().m_82490_((double)0.9f));
        if (this.m_9236_().f_46443_) {
            if (this.lSteps > 0) {
                double d5 = this.m_20185_() + (this.lx - this.m_20185_()) / (double)this.lSteps;
                double d6 = this.m_20186_() + (this.ly - this.m_20186_()) / (double)this.lSteps;
                double d7 = this.m_20189_() + (this.lz - this.m_20189_()) / (double)this.lSteps;
                this.m_146922_(Mth.m_14177_((float)((float)this.lyr)));
                this.m_146926_(this.m_146909_() + (float)(this.lxr - (double)this.m_146909_()) / (float)this.lSteps);
                --this.lSteps;
                this.m_6034_(d5, d6, d7);
            } else {
                this.m_20090_();
            }
        }
    }

    public void m_6453_(double x, double y, double z, float yr, float xr, int steps, boolean b) {
        this.lx = x;
        this.ly = y;
        this.lz = z;
        this.lyr = yr;
        this.lxr = xr;
        this.lSteps = steps;
        this.m_20334_(this.lxd, this.lyd, this.lzd);
    }

    public void m_6001_(double lerpX, double lerpY, double lerpZ) {
        this.lxd = lerpX;
        this.lyd = lerpY;
        this.lzd = lerpZ;
        this.m_20334_(this.lxd, this.lyd, this.lzd);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(TARGET_ID, (Object)-1);
        this.f_19804_.m_135372_(PLAYER_ID, (Object)-1);
        this.f_19804_.m_135372_(STAB, (Object)Float.valueOf(0.0f));
    }

    protected void m_7378_(CompoundTag tag) {
    }

    protected void m_7380_(CompoundTag tag) {
    }

    private int getTargetId() {
        return (Integer)this.f_19804_.m_135370_(TARGET_ID);
    }

    public void setTargetId(int id) {
        this.f_19804_.m_135381_(TARGET_ID, (Object)id);
    }

    private int getPlayerId() {
        return (Integer)this.f_19804_.m_135370_(PLAYER_ID);
    }

    public void setPlayerId(int id) {
        this.f_19804_.m_135381_(PLAYER_ID, (Object)id);
    }

    public float getStab() {
        return ((Float)this.f_19804_.m_135370_(STAB)).floatValue();
    }

    public float getStab(float partialTicks) {
        return this.prevStab + (this.getStab() - this.prevStab) * partialTicks;
    }

    public void setStab(float stab) {
        this.f_19804_.m_135381_(STAB, (Object)Float.valueOf(stab));
    }

    private Entity getTargetEntity() {
        int id = this.getTargetId();
        return id == -1 ? null : this.m_9236_().m_6815_(id);
    }

    private Entity getPlayer() {
        int id = this.getPlayerId();
        return id == -1 ? null : this.m_9236_().m_6815_(id);
    }
}

