/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.block.blockentity;

import com.github.alexmodguy.alexscaves.AlexsCaves;
import com.github.alexmodguy.alexscaves.server.block.blockentity.ACBlockEntityRegistry;
import com.github.alexmodguy.alexscaves.server.misc.ACSoundRegistry;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;

public class HologramProjectorBlockEntity
extends BlockEntity {
    public int tickCount;
    private EntityType entityType;
    private CompoundTag entityTag;
    private Entity displayEntity;
    private Entity prevDisplayEntity;
    private float prevSwitchProgress;
    private float switchProgress;
    private float previousRotation;
    private float rotation;
    private UUID lastPlayerUUID;

    public HologramProjectorBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ACBlockEntityRegistry.HOLOGRAM_PROJECTOR.get(), pos, state);
    }

    public static void tick(Level level, BlockPos blockPos, BlockState state, HologramProjectorBlockEntity entity) {
        float redstoneSignal;
        ++entity.tickCount;
        entity.prevSwitchProgress = entity.switchProgress;
        entity.previousRotation = entity.rotation;
        if (entity.prevDisplayEntity != entity.displayEntity || entity.isPlayerRender()) {
            if (entity.displayEntity == null && !entity.isPlayerRender()) {
                if (entity.switchProgress > 0.0f) {
                    if (entity.switchProgress == 10.0f) {
                        level.m_247517_((Player)null, blockPos, (SoundEvent)ACSoundRegistry.HOLOGRAM_STOP.get(), SoundSource.BLOCKS);
                    }
                    entity.switchProgress -= 1.0f;
                } else {
                    entity.prevDisplayEntity = null;
                    entity.markUpdated();
                }
            } else {
                if (entity.switchProgress < 10.0f) {
                    if (entity.switchProgress == 0.0f) {
                        level.m_247517_((Player)null, blockPos, (SoundEvent)ACSoundRegistry.HOLOGRAM_STOP.get(), SoundSource.BLOCKS);
                    }
                    entity.switchProgress += 1.0f;
                } else {
                    entity.prevDisplayEntity = entity.displayEntity;
                    entity.markUpdated();
                }
                if (!entity.m_58901_() && level.f_46443_) {
                    AlexsCaves.PROXY.playWorldSound((Object)entity, (byte)3);
                }
            }
        }
        if (entity.isPlayerRender() && entity.lastPlayerUUID == null) {
            entity.lastPlayerUUID = entity.entityTag.m_128342_("UUID");
            entity.markUpdated();
        }
        if ((redstoneSignal = (float)level.m_277086_(blockPos) * 1.0f) > 0.0f) {
            entity.rotation += redstoneSignal;
        }
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128441_("EntityType")) {
            String str = tag.m_128461_("EntityType");
            this.entityType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation(str));
        }
        if (tag.m_128441_("EntityTag")) {
            this.entityTag = tag.m_128469_("EntityTag");
        }
        this.rotation = tag.m_128457_("Rotation");
        if (tag.m_128441_("LastPlayerUUID")) {
            this.lastPlayerUUID = tag.m_128342_("LastPlayerUUID");
        }
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (this.entityType != null) {
            tag.m_128359_("EntityType", ForgeRegistries.ENTITY_TYPES.getKey((Object)this.entityType).toString());
        }
        if (this.entityTag != null) {
            tag.m_128365_("EntityTag", (Tag)this.entityTag);
        }
        tag.m_128350_("Rotation", this.rotation);
        if (this.lastPlayerUUID != null) {
            tag.m_128362_("LastPlayerUUID", this.lastPlayerUUID);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public AABB getRenderBoundingBox() {
        BlockPos pos = this.m_58899_();
        float f = this.displayEntity == null ? 1.0f : Math.max(this.displayEntity.m_20205_(), this.displayEntity.m_20206_());
        return new AABB(pos.m_7918_(-1, -1, -1), pos.m_7918_(2, 2, 2)).m_82400_((double)Math.max(f - 0.5f, 1.0f));
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet) {
        if (packet != null && packet.m_131708_() != null) {
            if (packet.m_131708_().m_128441_("EntityType")) {
                String str = packet.m_131708_().m_128461_("EntityType");
                this.entityType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation(str));
            }
            this.entityTag = packet.m_131708_().m_128469_("EntityTag");
            this.rotation = packet.m_131708_().m_128457_("Rotation");
            if (packet.m_131708_().m_128441_("LastPlayerUUID")) {
                this.lastPlayerUUID = packet.m_131708_().m_128342_("LastPlayerUUID");
            }
        }
    }

    public CompoundTag m_5995_() {
        CompoundTag compoundtag = new CompoundTag();
        if (this.entityType != null) {
            compoundtag.m_128359_("EntityType", ForgeRegistries.ENTITY_TYPES.getKey((Object)this.entityType).toString());
        }
        if (this.entityTag != null) {
            compoundtag.m_128365_("EntityTag", (Tag)this.entityTag);
        }
        compoundtag.m_128350_("Rotation", this.rotation);
        if (this.lastPlayerUUID != null) {
            compoundtag.m_128362_("LastPlayerUUID", this.lastPlayerUUID);
        }
        return compoundtag;
    }

    public void setEntity(EntityType entityType, CompoundTag entityTag, float playerRot) {
        this.entityType = entityType;
        this.entityTag = entityTag;
        this.rotation = playerRot;
        this.displayEntity = null;
        this.lastPlayerUUID = null;
    }

    public boolean isPlayerRender() {
        return this.entityType == EntityType.f_20532_;
    }

    public UUID getLastPlayerUUID() {
        return this.isPlayerRender() ? this.lastPlayerUUID : null;
    }

    public Entity getDisplayEntity(Level level) {
        if (this.isPlayerRender()) {
            return null;
        }
        if (this.displayEntity == null && this.entityType != null) {
            this.displayEntity = EntityType.m_20645_((CompoundTag)this.entityTag, (Level)level, Function.identity());
        }
        if (this.displayEntity == null && this.prevDisplayEntity != null) {
            return this.prevDisplayEntity;
        }
        return this.displayEntity;
    }

    public float getSwitchAmount(float partialTicks) {
        return (this.prevSwitchProgress + (this.switchProgress - this.prevSwitchProgress) * partialTicks) * 0.1f;
    }

    public float getRotation(float partialTicks) {
        return this.previousRotation + (this.rotation - this.previousRotation) * partialTicks;
    }

    private void markUpdated() {
        this.m_6596_();
        this.m_58904_().m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
    }

    public void m_7651_() {
        AlexsCaves.PROXY.clearSoundCacheFor(this);
        this.f_58857_.m_247517_((Player)null, this.m_58899_(), (SoundEvent)ACSoundRegistry.HOLOGRAM_STOP.get(), SoundSource.BLOCKS);
        super.m_7651_();
    }
}

