/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.block;

import com.github.alexmodguy.alexscaves.client.particle.ACParticleRegistry;
import com.github.alexmodguy.alexscaves.server.block.ACSoundTypes;
import com.github.alexmodguy.alexscaves.server.block.fluid.ACFluidRegistry;
import com.github.alexmodguy.alexscaves.server.item.ACItemRegistry;
import com.github.alexmodguy.alexscaves.server.misc.ACMath;
import com.github.alexmodguy.alexscaves.server.misc.ACSoundRegistry;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class UraniumRodBlock
extends RotatedPillarBlock
implements SimpleWaterloggedBlock {
    private static final VoxelShape SHAPE_X = ACMath.buildShape(Block.m_49796_((double)2.0, (double)6.0, (double)6.0, (double)14.0, (double)10.0, (double)10.0), Block.m_49796_((double)14.0, (double)5.0, (double)5.0, (double)16.0, (double)11.0, (double)11.0), Block.m_49796_((double)0.0, (double)5.0, (double)5.0, (double)2.0, (double)11.0, (double)11.0));
    private static final VoxelShape SHAPE_Y = ACMath.buildShape(Block.m_49796_((double)6.0, (double)2.0, (double)6.0, (double)10.0, (double)14.0, (double)10.0), Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)2.0, (double)11.0), Block.m_49796_((double)5.0, (double)14.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0));
    private static final VoxelShape SHAPE_Z = ACMath.buildShape(Block.m_49796_((double)6.0, (double)6.0, (double)2.0, (double)10.0, (double)10.0, (double)14.0), Block.m_49796_((double)5.0, (double)5.0, (double)14.0, (double)11.0, (double)11.0, (double)16.0), Block.m_49796_((double)5.0, (double)5.0, (double)0.0, (double)11.0, (double)11.0, (double)2.0));
    public static final IntegerProperty LIQUID_LOGGED = IntegerProperty.m_61631_((String)"liquid_logged", (int)0, (int)2);

    public UraniumRodBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283916_).m_60978_(1.5f).m_60953_(state -> 9).m_60991_((state, level, pos) -> true).m_60918_(ACSoundTypes.URANIUM));
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)LIQUID_LOGGED, (Comparable)Integer.valueOf(0))).m_61124_((Property)f_55923_, (Comparable)Direction.Axis.Y));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        switch ((Direction.Axis)state.m_61143_((Property)f_55923_)) {
            case X: {
                return SHAPE_X;
            }
            case Y: {
                return SHAPE_Y;
            }
            case Z: {
                return SHAPE_Z;
            }
        }
        return SHAPE_Y;
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource randomSource) {
        if (randomSource.m_188503_(80) == 0) {
            level.m_7785_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, (SoundEvent)ACSoundRegistry.URANIUM_HUM.get(), SoundSource.BLOCKS, 0.5f, randomSource.m_188501_() * 0.4f + 0.8f, false);
        }
        if (randomSource.m_188503_(10) == 0) {
            Vec3 center = Vec3.m_82514_((Vec3i)pos, (double)0.5);
            level.m_7106_((ParticleOptions)ACParticleRegistry.PROTON.get(), center.f_82479_, center.f_82480_, center.f_82481_, center.f_82479_, center.f_82480_, center.f_82481_);
        }
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState state1, LevelAccessor levelAccessor, BlockPos blockPos, BlockPos blockPos1) {
        int liquidType = (Integer)state.m_61143_((Property)LIQUID_LOGGED);
        if (liquidType == 1) {
            levelAccessor.m_186469_(blockPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)levelAccessor));
        } else if (liquidType == 2) {
            levelAccessor.m_186469_(blockPos, (Fluid)ACFluidRegistry.ACID_FLUID_SOURCE.get(), ((FlowingFluid)ACFluidRegistry.ACID_FLUID_SOURCE.get()).m_6718_((LevelReader)levelAccessor));
        }
        if (!levelAccessor.m_5776_()) {
            levelAccessor.m_186460_(blockPos, (Block)this, 1);
        }
        return super.m_7417_(state, direction, state1, levelAccessor, blockPos, blockPos1);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Level levelaccessor = context.m_43725_();
        BlockPos blockpos = context.m_8083_();
        return (BlockState)super.m_5573_(context).m_61124_((Property)LIQUID_LOGGED, (Comparable)Integer.valueOf(UraniumRodBlock.getLiquidType(levelaccessor.m_6425_(blockpos))));
    }

    public boolean m_6044_(BlockGetter getter, BlockPos blockPos, BlockState blockState, Fluid fluid) {
        return fluid == Fluids.f_76193_ || fluid.getFluidType() == ACFluidRegistry.ACID_FLUID_TYPE.get();
    }

    public boolean m_7361_(LevelAccessor levelAccessor, BlockPos pos, BlockState blockState, FluidState fluidState) {
        int liquidType = (Integer)blockState.m_61143_((Property)LIQUID_LOGGED);
        if (liquidType == 0) {
            if (!levelAccessor.m_5776_()) {
                if (fluidState.m_76152_() == Fluids.f_76193_) {
                    levelAccessor.m_7731_(pos, (BlockState)blockState.m_61124_((Property)LIQUID_LOGGED, (Comparable)Integer.valueOf(1)), 3);
                } else if (fluidState.getFluidType() == ACFluidRegistry.ACID_FLUID_TYPE.get()) {
                    levelAccessor.m_7731_(pos, (BlockState)blockState.m_61124_((Property)LIQUID_LOGGED, (Comparable)Integer.valueOf(2)), 3);
                }
                levelAccessor.m_186469_(pos, fluidState.m_76152_(), fluidState.m_76152_().m_6718_((LevelReader)levelAccessor));
            }
            return true;
        }
        return false;
    }

    public ItemStack m_142598_(LevelAccessor levelAccessor, BlockPos blockPos, BlockState state) {
        int liquidType = (Integer)state.m_61143_((Property)LIQUID_LOGGED);
        if (liquidType > 0) {
            levelAccessor.m_7731_(blockPos, (BlockState)state.m_61124_((Property)LIQUID_LOGGED, (Comparable)Integer.valueOf(0)), 3);
            if (!state.m_60710_((LevelReader)levelAccessor, blockPos)) {
                levelAccessor.m_46961_(blockPos, true);
            }
            return new ItemStack((ItemLike)(liquidType == 1 ? Items.f_42447_ : (ItemLike)ACItemRegistry.ACID_BUCKET.get()));
        }
        return ItemStack.f_41583_;
    }

    public Optional<SoundEvent> m_142298_() {
        return Fluids.f_76193_.m_142520_();
    }

    public FluidState m_5888_(BlockState state) {
        int liquidType = (Integer)state.m_61143_((Property)LIQUID_LOGGED);
        return liquidType == 1 ? Fluids.f_76193_.m_76068_(false) : (liquidType == 2 ? ((FlowingFluid)ACFluidRegistry.ACID_FLUID_SOURCE.get()).m_76068_(false) : super.m_5888_(state));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> blockStateBuilder) {
        blockStateBuilder.m_61104_(new Property[]{LIQUID_LOGGED, f_55923_});
    }

    public static int getLiquidType(FluidState fluidState) {
        if (fluidState.m_76152_() == Fluids.f_76193_) {
            return 1;
        }
        if (fluidState.getFluidType() == ACFluidRegistry.ACID_FLUID_TYPE.get()) {
            return 2;
        }
        return 0;
    }
}

