/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.client.render.entity;

import com.github.alexmodguy.alexscaves.client.model.WaveModel;
import com.github.alexmodguy.alexscaves.server.entity.item.WaveEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.biome.Biome;

public class WaveRenderer
extends EntityRenderer<WaveEntity> {
    private static final ResourceLocation TEXTURE_0 = new ResourceLocation("alexscaves", "textures/entity/deep_one/wave_0.png");
    private static final ResourceLocation TEXTURE_1 = new ResourceLocation("alexscaves", "textures/entity/deep_one/wave_1.png");
    private static final ResourceLocation TEXTURE_2 = new ResourceLocation("alexscaves", "textures/entity/deep_one/wave_2.png");
    private static final ResourceLocation TEXTURE_3 = new ResourceLocation("alexscaves", "textures/entity/deep_one/wave_3.png");
    private static final ResourceLocation OVERLAY_TEXTURE_0 = new ResourceLocation("alexscaves", "textures/entity/deep_one/wave_overlay_0.png");
    private static final ResourceLocation OVERLAY_TEXTURE_1 = new ResourceLocation("alexscaves", "textures/entity/deep_one/wave_overlay_1.png");
    private static final ResourceLocation OVERLAY_TEXTURE_2 = new ResourceLocation("alexscaves", "textures/entity/deep_one/wave_overlay_2.png");
    private static final ResourceLocation OVERLAY_TEXTURE_3 = new ResourceLocation("alexscaves", "textures/entity/deep_one/wave_overlay_3.png");
    private static final WaveModel MODEL = new WaveModel();

    public WaveRenderer(EntityRendererProvider.Context renderManagerIn) {
        super(renderManagerIn);
    }

    public void render(WaveEntity entityIn, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        matrixStackIn.m_85836_();
        matrixStackIn.m_85837_(0.0, 1.5, 0.0);
        matrixStackIn.m_252781_(Axis.f_252392_.m_252977_(Mth.m_14179_((float)partialTicks, (float)entityIn.f_19859_, (float)entityIn.m_146908_()) + 180.0f));
        float ageInTicks = (float)entityIn.f_19797_ + partialTicks;
        float f = ageInTicks / 10.0f;
        matrixStackIn.m_85837_(0.0, (double)(-0.1f + (1.0f - f) * -1.0f), -0.5);
        matrixStackIn.m_85841_(1.0f, -(0.2f + f * 0.9f), 1.0f);
        MODEL.setupAnim(entityIn, 0.0f, 0.0f, ageInTicks, 0.0f, 0.0f);
        VertexConsumer ivertexbuilder = bufferIn.m_6299_(RenderType.m_110473_((ResourceLocation)this.getWaveTexture(entityIn.f_19797_)));
        int waterColorAt = ((Biome)entityIn.m_9236_().m_204166_(entityIn.m_20183_()).get()).m_47560_();
        float colorR = (float)(waterColorAt >> 16 & 0xFF) / 255.0f;
        float colorG = (float)(waterColorAt >> 8 & 0xFF) / 255.0f;
        float colorB = (float)(waterColorAt & 0xFF) / 255.0f;
        MODEL.m_7695_(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.f_118083_, colorR, colorG, colorB, 1.0f);
        VertexConsumer ivertexbuilder2 = bufferIn.m_6299_(RenderType.m_110473_((ResourceLocation)this.getOverlayTexture(entityIn.f_19797_)));
        MODEL.m_7695_(matrixStackIn, ivertexbuilder2, packedLightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStackIn.m_85849_();
        super.m_7392_((Entity)entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
    }

    public ResourceLocation getTextureLocation(WaveEntity entity) {
        return this.getWaveTexture(entity.f_19797_);
    }

    private ResourceLocation getWaveTexture(int tickCount) {
        int j = tickCount % 12 / 3;
        switch (j) {
            case 0: {
                return TEXTURE_0;
            }
            case 1: {
                return TEXTURE_1;
            }
            case 2: {
                return TEXTURE_2;
            }
        }
        return TEXTURE_3;
    }

    private ResourceLocation getOverlayTexture(int tickCount) {
        int j = tickCount % 12 / 3;
        switch (j) {
            case 0: {
                return OVERLAY_TEXTURE_0;
            }
            case 1: {
                return OVERLAY_TEXTURE_1;
            }
            case 2: {
                return OVERLAY_TEXTURE_2;
            }
        }
        return OVERLAY_TEXTURE_3;
    }
}

