/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.client.render.blockentity;

import com.github.alexmodguy.alexscaves.client.ClientProxy;
import com.github.alexmodguy.alexscaves.client.render.ACRenderTypes;
import com.github.alexmodguy.alexscaves.client.render.entity.NotorRenderer;
import com.github.alexmodguy.alexscaves.server.block.blockentity.HologramProjectorBlockEntity;
import com.github.alexmodguy.alexscaves.server.misc.ACMath;
import com.github.alexthe666.citadel.client.shader.PostEffectRegistry;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class HologramProjectorBlockRenderer<T extends HologramProjectorBlockEntity>
implements BlockEntityRenderer<T> {
    private static final Map<BlockPos, HologramProjectorBlockEntity> allOnScreen = new HashMap<BlockPos, HologramProjectorBlockEntity>();
    private static final Map<UUID, PlayerInfo> playerInfo = new HashMap<UUID, PlayerInfo>();

    public HologramProjectorBlockRenderer(BlockEntityRendererProvider.Context rendererDispatcherIn) {
    }

    public static void renderEntireBatch(LevelRenderer levelRenderer, PoseStack poseStack, int renderTick, Camera camera, float partialTick) {
        if (!allOnScreen.isEmpty()) {
            ArrayList<BlockPos> sortedPoses = new ArrayList<BlockPos>(allOnScreen.keySet());
            Collections.sort(sortedPoses, (blockPos1, blockPos2) -> HologramProjectorBlockRenderer.sortBlockPos(camera, blockPos1, blockPos2));
            poseStack.m_85836_();
            Vec3 cameraPos = camera.m_90583_();
            poseStack.m_85837_(-cameraPos.f_82479_, -cameraPos.f_82480_, -cameraPos.f_82481_);
            for (BlockPos pos : sortedPoses) {
                MultiBufferSource.BufferSource multibuffersource$buffersource = Minecraft.m_91087_().m_91269_().m_110104_();
                Vec3 blockAt = Vec3.m_82512_((Vec3i)pos);
                poseStack.m_85836_();
                poseStack.m_85837_(blockAt.f_82479_, blockAt.f_82480_, blockAt.f_82481_);
                HologramProjectorBlockRenderer.renderAt(allOnScreen.get(pos), partialTick, poseStack, (MultiBufferSource)multibuffersource$buffersource);
                poseStack.m_85849_();
                multibuffersource$buffersource.m_109911_();
            }
            poseStack.m_85849_();
        }
        allOnScreen.clear();
    }

    private static int sortBlockPos(Camera camera, BlockPos blockPos1, BlockPos blockPos2) {
        double d1 = camera.m_90583_().m_82554_(Vec3.m_82512_((Vec3i)blockPos1));
        double d2 = camera.m_90583_().m_82554_(Vec3.m_82512_((Vec3i)blockPos2));
        return Double.compare(d2, d1);
    }

    public void render(T hologram, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        if (!hologram.m_58901_()) {
            allOnScreen.put(hologram.m_58899_(), (HologramProjectorBlockEntity)((Object)hologram));
        } else {
            allOnScreen.remove(hologram.m_58899_());
        }
    }

    private static void renderAt(HologramProjectorBlockEntity projectorBlockEntity, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn) {
        PostEffectRegistry.renderEffectForNextTick((ResourceLocation)ClientProxy.HOLOGRAM_SHADER);
        Entity holoEntity = projectorBlockEntity.getDisplayEntity((Level)Minecraft.m_91087_().f_91073_);
        float amount = projectorBlockEntity.getSwitchAmount(partialTicks);
        float ticks = (float)projectorBlockEntity.tickCount + partialTicks;
        float bob1 = (float)(Math.sin(ticks * 0.05f + amount) * (double)0.1f);
        float bob2 = (float)(Math.cos(ticks * 0.05f + amount) * (double)0.1f);
        float length = (1.0f + bob1) * amount;
        float width = ((holoEntity == null ? 0.8f : holoEntity.m_20205_()) + bob2) * amount;
        VertexConsumer lightConsumer = bufferIn.m_6299_(ACRenderTypes.getHologramLights());
        poseStack.m_85836_();
        float padStart = 0.125f;
        float padEnd = 1.0f - padStart;
        poseStack.m_85836_();
        poseStack.m_252880_(-0.5f, -0.235f, -0.5f);
        float cameraY = Minecraft.m_91087_().m_91290_().f_114358_.m_90590_();
        PoseStack.Pose posestack$pose = poseStack.m_85850_();
        Matrix4f matrix4f1 = posestack$pose.m_252922_();
        Matrix3f matrix3f1 = posestack$pose.m_252943_();
        lightConsumer.m_252986_(matrix4f1, padStart, 0.0f, padEnd).m_6122_(220, 220, 255, (int)(amount * 150.0f)).m_7421_(0.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(240).m_252939_(matrix3f1, 0.0f, 1.0f, 0.0f).m_5752_();
        lightConsumer.m_252986_(matrix4f1, padEnd, 0.0f, padEnd).m_6122_(220, 220, 255, (int)(amount * 150.0f)).m_7421_(1.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(240).m_252939_(matrix3f1, 0.0f, 1.0f, 0.0f).m_5752_();
        lightConsumer.m_252986_(matrix4f1, padEnd, 0.0f, padStart).m_6122_(220, 220, 255, (int)(amount * 150.0f)).m_7421_(1.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(240).m_252939_(matrix3f1, 0.0f, 1.0f, 0.0f).m_5752_();
        lightConsumer.m_252986_(matrix4f1, padStart, 0.0f, padStart).m_6122_(220, 220, 255, (int)(amount * 150.0f)).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(240).m_252939_(matrix3f1, 0.0f, 1.0f, 0.0f).m_5752_();
        poseStack.m_85849_();
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, -0.2f, 0.0f);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f - cameraY));
        PoseStack.Pose posestack$pose1 = poseStack.m_85850_();
        Matrix4f matrix4f2 = posestack$pose1.m_252922_();
        Matrix3f matrix3f2 = posestack$pose1.m_252943_();
        HologramProjectorBlockRenderer.shineOriginVertex(lightConsumer, matrix4f2, matrix3f2, 0.0f, 0.0f);
        HologramProjectorBlockRenderer.shineLeftCornerVertex(lightConsumer, matrix4f2, matrix3f2, length, width, 0.0f, 0.0f);
        HologramProjectorBlockRenderer.shineRightCornerVertex(lightConsumer, matrix4f2, matrix3f2, length, width, 0.0f, 0.0f);
        HologramProjectorBlockRenderer.shineLeftCornerVertex(lightConsumer, matrix4f2, matrix3f2, length, width, 0.0f, 0.0f);
        if (projectorBlockEntity.isPlayerRender()) {
            poseStack.m_85836_();
            poseStack.m_85841_(1.0f, amount, 1.0f);
            poseStack.m_252880_(0.0f, length + 1.5f, 0.0f);
            poseStack.m_252781_(Axis.f_252392_.m_252977_(180.0f - cameraY + projectorBlockEntity.getRotation(partialTicks)));
            HologramProjectorBlockRenderer.renderPlayerHologram(projectorBlockEntity.getLastPlayerUUID(), partialTicks, poseStack, bufferIn, 240);
            poseStack.m_85849_();
        } else if (holoEntity != null) {
            poseStack.m_85836_();
            poseStack.m_85841_(1.0f, amount, 1.0f);
            poseStack.m_252880_(0.0f, length + 1.5f, 0.0f);
            poseStack.m_252781_(Axis.f_252392_.m_252977_(180.0f - cameraY + projectorBlockEntity.getRotation(partialTicks)));
            NotorRenderer.renderEntityInHologram(holoEntity, 0.0, 0.0, 0.0, 0.0f, partialTicks, poseStack, bufferIn, 240);
            poseStack.m_85849_();
        }
        poseStack.m_85849_();
        poseStack.m_85849_();
    }

    private static PlayerInfo getPlayerInfo(UUID uuid) {
        if (!playerInfo.containsKey(uuid)) {
            playerInfo.put(uuid, Minecraft.m_91087_().m_91403_().m_104949_(uuid));
        }
        return playerInfo.get(uuid);
    }

    private static String getPlayerModelName(PlayerInfo playerInfo, UUID uuid) {
        return playerInfo == null ? DefaultPlayerSkin.m_118629_((UUID)uuid) : playerInfo.m_105336_();
    }

    private static ResourceLocation getPlayerSkinTextureLocation(PlayerInfo playerInfo, UUID uuid) {
        return playerInfo == null ? DefaultPlayerSkin.m_118627_((UUID)uuid) : playerInfo.m_105337_();
    }

    private static void renderPlayerHologram(UUID lastPlayerUUID, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, int i) {
        PostEffectRegistry.renderEffectForNextTick((ResourceLocation)ClientProxy.HOLOGRAM_SHADER);
        PlayerInfo playerInfo = HologramProjectorBlockRenderer.getPlayerInfo(lastPlayerUUID);
        String modelName = HologramProjectorBlockRenderer.getPlayerModelName(playerInfo, lastPlayerUUID);
        EntityRenderDispatcher manager = Minecraft.m_91087_().m_91290_();
        EntityRenderer renderer = (EntityRenderer)manager.getSkinMap().get(modelName);
        if (renderer instanceof LivingEntityRenderer) {
            HumanoidModel humanoidModel;
            LivingEntityRenderer livingEntityRenderer = (LivingEntityRenderer)renderer;
            EntityModel model = livingEntityRenderer.m_7200_();
            VertexConsumer ivertexbuilder = bufferIn.m_6299_(ACRenderTypes.getHologram(HologramProjectorBlockRenderer.getPlayerSkinTextureLocation(playerInfo, lastPlayerUUID)));
            poseStack.m_85836_();
            model.f_102610_ = false;
            model.f_102609_ = false;
            model.f_102608_ = 0.0f;
            boolean prevCrouching = false;
            if (model instanceof HumanoidModel) {
                humanoidModel = (HumanoidModel)model;
                prevCrouching = humanoidModel.f_102817_;
                humanoidModel.f_102817_ = false;
            }
            poseStack.m_85841_(1.0f, -1.0f, 1.0f);
            if (model instanceof PlayerModel) {
                PlayerModel playerModel = (PlayerModel)model;
                playerModel.f_102812_.f_104203_ = 0.0f;
                playerModel.f_102812_.f_104204_ = 0.0f;
                playerModel.f_102812_.f_104205_ = 0.0f;
                playerModel.f_102811_.f_104203_ = 0.0f;
                playerModel.f_102811_.f_104204_ = 0.0f;
                playerModel.f_102811_.f_104205_ = 0.0f;
                playerModel.f_102814_.f_104203_ = 0.0f;
                playerModel.f_102814_.f_104204_ = 0.0f;
                playerModel.f_102814_.f_104205_ = 0.0f;
                playerModel.f_102813_.f_104203_ = 0.0f;
                playerModel.f_102813_.f_104204_ = 0.0f;
                playerModel.f_102813_.f_104205_ = 0.0f;
                playerModel.f_102808_.f_104203_ = 0.0f;
                playerModel.f_102808_.f_104204_ = 0.0f;
                playerModel.f_102808_.f_104205_ = 0.0f;
                playerModel.f_102810_.f_104203_ = 0.0f;
                playerModel.f_102810_.f_104204_ = 0.0f;
                playerModel.f_102810_.f_104205_ = 0.0f;
                playerModel.f_103376_.m_104315_(playerModel.f_102814_);
                playerModel.f_103377_.m_104315_(playerModel.f_102813_);
                playerModel.f_103374_.m_104315_(playerModel.f_102812_);
                playerModel.f_103375_.m_104315_(playerModel.f_102811_);
                playerModel.f_103378_.m_104315_(playerModel.f_102810_);
                playerModel.f_102809_.m_104315_(playerModel.f_102808_);
            }
            model.m_7695_(poseStack, ivertexbuilder, 240, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            poseStack.m_85849_();
            if (model instanceof HumanoidModel) {
                humanoidModel = (HumanoidModel)model;
                humanoidModel.f_102817_ = prevCrouching;
            }
        }
        Minecraft.m_91087_().m_91385_().m_83947_(false);
    }

    private static void shineOriginVertex(VertexConsumer p_114220_, Matrix4f p_114221_, Matrix3f p_114092_, float xOffset, float yOffset) {
        p_114220_.m_252986_(p_114221_, 0.0f, 0.0f, 0.0f).m_6122_(255, 255, 255, 230).m_7421_(xOffset + 0.5f, yOffset).m_86008_(OverlayTexture.f_118083_).m_85969_(240).m_252939_(p_114092_, 0.0f, 1.0f, 0.0f).m_5752_();
    }

    private static void shineLeftCornerVertex(VertexConsumer p_114215_, Matrix4f p_114216_, Matrix3f p_114092_, float p_114217_, float p_114218_, float xOffset, float yOffset) {
        p_114215_.m_252986_(p_114216_, -ACMath.HALF_SQRT_3 * p_114218_, p_114217_, 0.0f).m_6122_(0, 0, 255, 0).m_7421_(xOffset, yOffset + 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(240).m_252939_(p_114092_, 0.0f, -1.0f, 0.0f).m_5752_();
    }

    private static void shineRightCornerVertex(VertexConsumer p_114224_, Matrix4f p_114225_, Matrix3f p_114092_, float p_114226_, float p_114227_, float xOffset, float yOffset) {
        p_114224_.m_252986_(p_114225_, ACMath.HALF_SQRT_3 * p_114227_, p_114226_, 0.0f).m_6122_(0, 0, 255, 0).m_7421_(xOffset + 1.0f, yOffset + 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(240).m_252939_(p_114092_, 0.0f, -1.0f, 0.0f).m_5752_();
    }

    public int m_142163_() {
        return 128;
    }
}

