/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.client.render.blockentity;

import com.github.alexmodguy.alexscaves.server.block.blockentity.AmberMonolithBlockEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.ForgeRenderTypes;

public class AmberMonolithBlockRenderer<T extends AmberMonolithBlockEntity>
implements BlockEntityRenderer<T> {
    protected final RandomSource random = RandomSource.m_216327_();

    public AmberMonolithBlockRenderer(BlockEntityRendererProvider.Context rendererDispatcherIn) {
    }

    public void render(T amber, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        Entity currentEntity = ((AmberMonolithBlockEntity)((Object)amber)).getDisplayEntity((Level)Minecraft.m_91087_().f_91073_);
        float age = (float)((AmberMonolithBlockEntity)((Object)amber)).tickCount + partialTicks;
        float spin = ((AmberMonolithBlockEntity)((Object)amber)).getRotation(partialTicks);
        poseStack.m_85836_();
        poseStack.m_252880_(0.5f, 1.65f, 0.5f);
        if (currentEntity != null) {
            float f = 0.45f;
            float f1 = Math.max(currentEntity.m_20205_(), currentEntity.m_20206_());
            if ((double)f1 > 1.0) {
                f /= f1 * 1.5f;
            }
            poseStack.m_252880_(0.0f, f * 1.5f - 1.25f + (float)(Math.cos((double)age * 0.05) * (double)0.05f), 0.0f);
            poseStack.m_85841_(f, f, f);
            poseStack.m_252781_(Axis.f_252436_.m_252977_(spin));
            AmberMonolithBlockRenderer.renderEntityInAmber(currentEntity, 0.0, 0.0, 0.0, 0.0f, partialTicks, poseStack, bufferIn, 1.0f);
        }
        poseStack.m_85849_();
    }

    public static <E extends Entity> void renderEntityInAmber(E entityIn, double x, double y, double z, float yaw, float partialTicks, PoseStack matrixStack, MultiBufferSource bufferIn, float transparency) {
        EntityRenderer render = null;
        EntityRenderDispatcher manager = Minecraft.m_91087_().m_91290_();
        try {
            render = manager.m_114382_(entityIn);
            float animSpeed = 0.0f;
            float animSpeedOld = 0.0f;
            float animPos = 0.0f;
            float xRot = entityIn.m_146909_();
            float xRotOld = entityIn.f_19860_;
            float yRot = entityIn.m_146908_();
            float yRotOld = entityIn.f_19859_;
            float yBodyRot = 0.0f;
            float yBodyRotOld = 0.0f;
            float headRot = 0.0f;
            float headRotOld = 0.0f;
            if (entityIn instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entityIn;
                headRot = living.f_20885_;
                headRotOld = living.f_20886_;
                yBodyRot = living.f_20883_;
                yBodyRotOld = living.f_20884_;
                living.f_20885_ = 0.0f;
                living.f_20886_ = 0.0f;
                living.f_20883_ = 0.0f;
                living.f_20884_ = 0.0f;
                entityIn.m_146926_(0.0f);
                entityIn.f_19860_ = 0.0f;
                entityIn.m_146922_(0.0f);
                entityIn.f_19859_ = 0.0f;
                if (render instanceof LivingEntityRenderer) {
                    HumanoidModel humanoidModel;
                    LivingEntityRenderer renderer = (LivingEntityRenderer)render;
                    EntityModel model = renderer.m_7200_();
                    VertexConsumer ivertexbuilder = bufferIn.m_6299_(ForgeRenderTypes.getUnlitTranslucent((ResourceLocation)render.m_5478_(entityIn)));
                    matrixStack.m_85836_();
                    boolean shouldSit = entityIn.m_20159_() && entityIn.m_20202_() != null && entityIn.m_20202_().shouldRiderSit();
                    model.f_102610_ = living.m_6162_();
                    model.f_102609_ = shouldSit;
                    model.f_102608_ = living.m_21324_(partialTicks);
                    boolean prevCrouching = false;
                    if (model instanceof HumanoidModel) {
                        humanoidModel = (HumanoidModel)model;
                        prevCrouching = humanoidModel.f_102817_;
                        humanoidModel.f_102817_ = false;
                    }
                    model.m_6973_((Entity)living, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f);
                    matrixStack.m_85841_(living.m_6134_(), -living.m_6134_(), living.m_6134_());
                    model.m_7695_(matrixStack, ivertexbuilder, 240, OverlayTexture.f_118083_, 0.3f, 0.16f, 0.2f, transparency);
                    matrixStack.m_85849_();
                    if (model instanceof HumanoidModel) {
                        humanoidModel = (HumanoidModel)model;
                        humanoidModel.f_102817_ = prevCrouching;
                    }
                }
                entityIn.m_146926_(xRot);
                entityIn.f_19860_ = xRotOld;
                entityIn.m_146922_(yRot);
                entityIn.f_19859_ = yRotOld;
                living.f_20885_ = headRot;
                living.f_20886_ = headRotOld;
                living.f_20883_ = yBodyRot;
                living.f_20884_ = yBodyRotOld;
            }
            Minecraft.m_91087_().m_91385_().m_83947_(false);
        }
        catch (Throwable throwable3) {
            CrashReport crashreport = CrashReport.m_127521_((Throwable)throwable3, (String)"Rendering entity in world");
            CrashReportCategory crashreportcategory = crashreport.m_127514_("Entity being rendered");
            entityIn.m_7976_(crashreportcategory);
            CrashReportCategory crashreportcategory1 = crashreport.m_127514_("Renderer details");
            crashreportcategory1.m_128159_("Assigned renderer", (Object)render);
            crashreportcategory1.m_128159_("Rotation", (Object)Float.valueOf(yaw));
            crashreportcategory1.m_128159_("Delta", (Object)Float.valueOf(partialTicks));
            throw new ReportedException(crashreport);
        }
    }
}

