/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.zeta.util;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;
import org.violetmoon.zeta.Zeta;
import org.violetmoon.zeta.block.IZetaBlock;

public class RegistryUtil {
    protected final Zeta z;

    public static <T> List<T> massRegistryGet(Collection<String> coll, Registry<T> reg) {
        return coll.stream().map(ResourceLocation::new).map(arg_0 -> reg.m_7745_(arg_0)).filter(Objects::nonNull).toList();
    }

    public static <T> List<T> getTagValues(RegistryAccess access, TagKey<T> tag) {
        return access.m_175515_(tag.f_203867_()).m_203431_(tag).map(holderset -> holderset.m_203614_().map(Holder::m_203334_).toList()).orElseGet(Collections::emptyList);
    }

    public RegistryUtil(Zeta z) {
        this.z = z;
    }

    @Nullable
    public String inheritQuark(IZetaBlock parent, String format) {
        return this.inherit(parent.getBlock(), format);
    }

    @Nullable
    public String inherit(Block parent, String format) {
        ResourceLocation parentName = this.z.registry.getRegistryName(parent, BuiltInRegistries.f_256975_);
        if (parentName == null) {
            return null;
        }
        return String.format(String.format("%s:%s", this.z.modid, format), parentName.m_135815_());
    }

    @Nullable
    public String inherit(Block parent, Function<String, String> fun) {
        ResourceLocation parentName = this.z.registry.getRegistryName(parent, BuiltInRegistries.f_256975_);
        if (parentName == null) {
            return null;
        }
        return String.format(String.format("%s:%s", this.z.modid, fun.apply(parentName.m_135815_())), new Object[0]);
    }
}

