/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.spelunkery.events;

import com.ordana.spelunkery.events.ClientBoundParticlePacket;
import com.ordana.spelunkery.events.ClientBoundSendKnockbackPacket;
import com.ordana.spelunkery.reg.ModParticles;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;

public class ClientReceivers {
    private static void withLevelDo(Consumer<Level> action) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level != null) {
            action.accept((Level)level);
        }
    }

    public static void handleSendBombKnockbackPacket(ClientBoundSendKnockbackPacket message) {
        ClientReceivers.withLevelDo(l -> {
            Entity e = l.m_6815_(message.id);
            if (e != null) {
                e.m_20256_(e.m_20184_().m_82520_(message.knockbackX, message.knockbackY, message.knockbackZ));
            }
        });
    }

    public static void handleSpawnBlockParticlePacket(ClientBoundParticlePacket message) {
        ClientReceivers.withLevelDo(l -> {
            if (message.id == ClientBoundParticlePacket.EventType.SLUICE) {
                // empty if block
            }
            if (message.id == ClientBoundParticlePacket.EventType.SULFUR_VENT) {
                Vec3 vec = Vec3.m_82512_((Vec3i)BlockPos.m_274446_((Position)message.pos));
                Direction dir = (Direction)l.m_8055_(BlockPos.m_274446_((Position)vec)).m_61143_((Property)BlockStateProperties.f_61372_);
                boolean water = l.m_6425_(BlockPos.m_274446_((Position)vec).m_121945_(dir)).m_192917_((Fluid)Fluids.f_76193_);
                BlockPos dustBlockPos = BlockPos.m_274446_((Position)vec).m_121945_(dir.m_122424_());
                BlockState dustBlockState = l.m_8055_(dustBlockPos);
                Block dustBlock = dustBlockState.m_60734_();
                Vec3i norm = dir.m_122436_();
                int x = norm.m_123341_();
                int y = norm.m_123342_();
                int z = norm.m_123343_();
                int orientation = dir.m_122411_();
                int color = 0;
                if (dustBlock instanceof FallingBlock) {
                    FallingBlock block = (FallingBlock)dustBlock;
                    color = block.m_6248_(dustBlockState, (BlockGetter)l, dustBlockPos);
                }
                for (int j = 0; j < 40; ++j) {
                    if (water) {
                        double ySpeed;
                        double xSpeed;
                        double d = x == 0 ? Mth.m_216263_((RandomSource)l.f_46441_, (double)-0.6, (double)0.6) : (xSpeed = x < 0 ? (double)x - Mth.m_216263_((RandomSource)l.f_46441_, (double)0.1, (double)3.5) : (double)x + Mth.m_216263_((RandomSource)l.f_46441_, (double)0.1, (double)3.5));
                        double d2 = y == 0 ? Mth.m_216263_((RandomSource)l.f_46441_, (double)-0.6, (double)0.6) : (ySpeed = y < 0 ? (double)y - Mth.m_216263_((RandomSource)l.f_46441_, (double)0.1, (double)3.5) : (double)y + Mth.m_216263_((RandomSource)l.f_46441_, (double)0.1, (double)3.5));
                        double zSpeed = z == 0 ? Mth.m_216263_((RandomSource)l.f_46441_, (double)-0.6, (double)0.6) : (z < 0 ? (double)z - Mth.m_216263_((RandomSource)l.f_46441_, (double)0.1, (double)3.5) : (double)z + Mth.m_216263_((RandomSource)l.f_46441_, (double)0.1, (double)3.5));
                        l.m_6485_((ParticleOptions)ParticleTypes.f_123774_, true, vec.f_82479_ + (double)((float)x / 2.0f), vec.f_82480_ + (double)((float)y / 2.0f), vec.f_82481_ + (double)((float)z / 2.0f), xSpeed, ySpeed, zSpeed);
                        continue;
                    }
                    l.m_6485_((ParticleOptions)ModParticles.SULFUR.get(), true, vec.f_82479_ + (double)((float)x / 2.0f), vec.f_82480_ + (double)((float)y / 2.0f), vec.f_82481_ + (double)((float)z / 2.0f), 0.0, (double)orientation, 0.0);
                    if (color == 0) continue;
                    l.m_6485_((ParticleOptions)ModParticles.SULFUR_DUSTING.get(), true, vec.f_82479_ + (double)((float)x / 2.0f), vec.f_82480_ + (double)((float)y / 2.0f), vec.f_82481_ + (double)((float)z / 2.0f), (double)color, (double)orientation, 0.0);
                }
            }
        });
    }
}

