/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.spelunkery.entities;

import com.ordana.spelunkery.reg.ModItems;
import com.ordana.spelunkery.reg.ModParticles;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.ClimbOnTopOfPowderSnowGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class DustBunnyEntity
extends PathfinderMob {
    private static final EntityDataAccessor<Integer> DATA_TYPE_ID = SynchedEntityData.m_135353_(DustBunnyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    int moreCarrotTicks;

    public DustBunnyEntity(EntityType<? extends PathfinderMob> entityType, Level level) {
        super(entityType, level);
        this.f_21342_ = new RabbitMoveControl(this);
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            CriteriaTriggers.f_10565_.m_61494_(serverPlayer, itemStack, (Entity)this);
        }
        player.m_5496_(SoundEvents.f_12639_, 1.0f, 1.0f);
        player.m_36356_(new ItemStack((ItemLike)ModItems.DUST_BUN.get()));
        if (this.m_9236_().f_46443_) {
            for (int i = 0; i < 20; ++i) {
                double d0 = this.f_19796_.m_188583_() * 0.02;
                double d1 = this.f_19796_.m_188583_() * 0.02;
                double d2 = this.f_19796_.m_188583_() * 0.02;
                this.m_9236_().m_7106_((ParticleOptions)ModParticles.DUST_POOF.get(), this.m_20185_() - d0 * 10.0, this.m_20187_() - d1 * 10.0, this.m_20189_() - d2 * 10.0, d0, d1, d2);
            }
        }
        this.m_142687_(Entity.RemovalReason.DISCARDED);
        return InteractionResult.SUCCESS;
    }

    public boolean m_6126_() {
        return false;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new ClimbOnTopOfPowderSnowGoal((Mob)this, this.m_9236_()));
        this.f_21345_.m_25352_(1, (Goal)new RabbitPanicGoal(this, 2.2));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 1.0, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42619_, Items.f_42677_, Blocks.f_50111_}), false));
        this.f_21345_.m_25352_(4, new RabbitAvoidEntityGoal<Player>(this, Player.class, 8.0f, 2.2, 2.2));
        this.f_21345_.m_25352_(4, new RabbitAvoidEntityGoal<Wolf>(this, Wolf.class, 10.0f, 2.2, 2.2));
        this.f_21345_.m_25352_(4, new RabbitAvoidEntityGoal<Monster>(this, Monster.class, 4.0f, 2.2, 2.2));
        this.f_21345_.m_25352_(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.6));
        this.f_21345_.m_25352_(11, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 10.0f));
    }

    public void setSpeedModifier(double speedModifier) {
        this.m_21573_().m_26517_(speedModifier);
        this.f_21342_.m_6849_(this.f_21342_.m_25000_(), this.f_21342_.m_25001_(), this.f_21342_.m_25002_(), speedModifier);
    }

    public void m_8024_() {
        if (this.moreCarrotTicks > 0) {
            this.moreCarrotTicks -= this.f_19796_.m_188503_(3);
            if (this.moreCarrotTicks < 0) {
                this.moreCarrotTicks = 0;
            }
        }
        this.m_20096_();
    }

    public boolean m_5843_() {
        return false;
    }

    public void m_8107_() {
        super.m_8107_();
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 3.0).m_22268_(Attributes.f_22279_, 0.3);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("MoreCarrotTicks", this.moreCarrotTicks);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.moreCarrotTicks = compound.m_128451_("MoreCarrotTicks");
    }

    protected SoundEvent getJumpSound() {
        return SoundEvents.f_12354_;
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12297_;
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return SoundEvents.f_12353_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12352_;
    }

    public SoundSource m_5720_() {
        return SoundSource.NEUTRAL;
    }

    private static boolean isTemptingItem(ItemStack stack) {
        return stack.m_150930_(Items.f_42619_) || stack.m_150930_(Items.f_42677_) || stack.m_150930_(Blocks.f_50111_.m_5456_());
    }

    public boolean isFood(ItemStack stack) {
        return DustBunnyEntity.isTemptingItem(stack);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag dataTag) {
        return super.m_6518_(level, difficulty, reason, spawnData, dataTag);
    }

    public static boolean checkRabbitSpawnRules(EntityType<Rabbit> rabbit, LevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return level.m_8055_(pos.m_7495_()).m_204336_(BlockTags.f_184234_);
    }

    boolean wantsMoreFood() {
        return this.moreCarrotTicks <= 0;
    }

    public void m_7822_(byte id) {
        if (id == 1) {
            this.m_20076_();
        } else {
            super.m_7822_(id);
        }
    }

    public Vec3 m_7939_() {
        return new Vec3(0.0, (double)(0.6f * this.m_20192_()), (double)(this.m_20205_() * 0.4f));
    }

    private static class RabbitMoveControl
    extends MoveControl {
        private final DustBunnyEntity rabbit;

        public RabbitMoveControl(DustBunnyEntity rabbit) {
            super((Mob)rabbit);
            this.rabbit = rabbit;
        }

        public void m_8126_() {
            super.m_8126_();
        }

        public void m_6849_(double x, double y, double z, double speed) {
            if (this.rabbit.m_20069_()) {
                speed = 1.5;
            }
            super.m_6849_(x, y, z, speed);
        }
    }

    static class RabbitPanicGoal
    extends PanicGoal {
        private final DustBunnyEntity rabbit;

        public RabbitPanicGoal(DustBunnyEntity rabbit, double d) {
            super((PathfinderMob)rabbit, d);
            this.rabbit = rabbit;
        }

        public void m_8037_() {
            super.m_8037_();
            this.rabbit.setSpeedModifier(this.f_25685_);
        }
    }

    static class RabbitAvoidEntityGoal<T extends LivingEntity>
    extends AvoidEntityGoal<T> {
        private final DustBunnyEntity rabbit;

        public RabbitAvoidEntityGoal(DustBunnyEntity rabbit, Class<T> class_, float f, double d, double e) {
            super((PathfinderMob)rabbit, class_, f, d, e);
            this.rabbit = rabbit;
        }

        public boolean m_8036_() {
            return super.m_8036_();
        }
    }
}

