/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.spelunkery.blocks.entity;

import com.ordana.spelunkery.Spelunkery;
import com.ordana.spelunkery.blocks.SluiceBlock;
import com.ordana.spelunkery.reg.ModBlocks;
import com.ordana.spelunkery.reg.ModEntities;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.BooleanSupplier;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.ParticleUtils;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class SluiceBlockEntity
extends RandomizableContainerBlockEntity {
    private NonNullList<ItemStack> items = NonNullList.m_122780_((int)9, (Object)ItemStack.f_41583_);
    private final ContainerOpenersCounter openersCounter = new ContainerOpenersCounter(){

        protected void m_142292_(Level level, BlockPos pos, BlockState state) {
            SluiceBlockEntity.this.playSound(state, SoundEvents.f_11725_);
        }

        protected void m_142289_(Level level, BlockPos pos, BlockState state) {
            SluiceBlockEntity.this.playSound(state, SoundEvents.f_11724_);
        }

        protected void m_142148_(Level level, BlockPos pos, BlockState state, int count, int openCount) {
        }

        protected boolean m_142718_(Player player) {
            if (player.f_36096_ instanceof ChestMenu) {
                Container container = ((ChestMenu)player.f_36096_).m_39261_();
                return container == SluiceBlockEntity.this;
            }
            return false;
        }
    };
    private int cooldownTime;
    private long tickedGameTime;

    public SluiceBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(blockState.m_60713_(ModBlocks.WOODEN_SLUICE.get()) ? ModEntities.WOODEN_SLUICE.get() : ModEntities.STONE_SLUICE.get(), blockPos, blockState);
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (!this.m_59634_(tag)) {
            ContainerHelper.m_18973_((CompoundTag)tag, this.items);
        }
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        if (!this.m_59631_(tag)) {
            ContainerHelper.m_18980_((CompoundTag)tag, this.items);
        }
    }

    public int m_6643_() {
        return 9;
    }

    protected NonNullList<ItemStack> m_7086_() {
        return this.items;
    }

    protected void m_6520_(NonNullList<ItemStack> itemStacks) {
        this.items = itemStacks;
    }

    protected Component m_6820_() {
        return Component.m_237115_((String)"container.spelunkery.sluice");
    }

    protected AbstractContainerMenu m_6555_(int containerId, Inventory inventory) {
        return new ChestMenu(MenuType.f_39957_, containerId, inventory, (Container)this, 1);
    }

    public void m_5856_(Player player) {
        if (!this.f_58859_ && !player.m_5833_()) {
            this.openersCounter.m_155452_(player, this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
    }

    public void m_5785_(Player player) {
        if (!this.f_58859_ && !player.m_5833_()) {
            this.openersCounter.m_155468_(player, this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
    }

    public void recheckOpen() {
        if (!this.f_58859_) {
            this.openersCounter.m_155476_(this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
    }

    void playSound(BlockState state, SoundEvent sound) {
        double d = (double)this.f_58858_.m_123341_() + 0.5;
        double e = (double)this.f_58858_.m_123342_() + 0.5;
        double f = (double)this.f_58858_.m_123343_() + 0.5;
        this.f_58857_.m_6263_((Player)null, d, e, f, sound, SoundSource.BLOCKS, 0.5f, this.f_58857_.f_46441_.m_188501_() * 0.1f + 0.9f);
    }

    private void setCooldown(int cooldownTime) {
        this.cooldownTime = cooldownTime;
    }

    private boolean isOnCooldown() {
        return this.cooldownTime > 0;
    }

    public static void pushItemsTick(Level level, BlockPos pos, BlockState state, SluiceBlockEntity blockEntity) {
        --blockEntity.cooldownTime;
        blockEntity.tickedGameTime = level.m_46467_();
        if (!blockEntity.isOnCooldown()) {
            blockEntity.setCooldown(0);
            int flow = SluiceBlock.getFlow(level, state, pos);
            SluiceBlockEntity.tryFilterItems(level, pos, state, blockEntity, flow, () -> SluiceBlockEntity.createFilteredItems(pos, level, blockEntity));
        }
    }

    public static boolean tryFilterItems(Level level, BlockPos pos, BlockState state, SluiceBlockEntity blockEntity, int flow, BooleanSupplier validator) {
        if (!level.f_46443_ && !blockEntity.isOnCooldown()) {
            boolean bl = false;
            int delay = 20;
            for (int i = 0; i < flow; ++i) {
                blockEntity.setCooldown(level.f_46441_.m_188503_(blockEntity.cooldownTime + delay));
                if (!blockEntity.inventoryFull()) {
                    bl |= validator.getAsBoolean();
                    continue;
                }
                bl = false;
            }
            SluiceBlockEntity.m_155232_((Level)level, (BlockPos)pos, (BlockState)state);
            return bl;
        }
        return false;
    }

    private boolean inventoryFull() {
        ItemStack itemStack;
        Iterator var1 = this.items.iterator();
        do {
            if (var1.hasNext()) continue;
            return true;
        } while (!(itemStack = (ItemStack)var1.next()).m_41619_() && itemStack.m_41613_() == itemStack.m_41741_());
        return false;
    }

    public static List getItemsAtAndAbove(BlockPos pos, Level level) {
        AABB aABB = new AABB(pos.m_7494_());
        return new ArrayList(level.m_6443_(ItemEntity.class, aABB, EntitySelector.f_20402_));
    }

    public static boolean createFilteredItems(BlockPos pos, Level level, SluiceBlockEntity entity) {
        Iterator itemList = SluiceBlockEntity.getItemsAtAndAbove(pos, level).iterator();
        if (!itemList.hasNext()) {
            return false;
        }
        ItemEntity itemEntity = (ItemEntity)itemList.next();
        String itemName = Utils.getID((Item)itemEntity.m_32055_().m_41720_()).m_135815_();
        String fluidName = Utils.getID((Fluid)level.m_6425_(pos.m_7494_()).m_76152_()).m_135815_();
        if (fluidName.contains("flowing_")) {
            fluidName = fluidName.replace("flowing_", "");
        }
        if (!Objects.equals(fluidName, "empty")) {
            SpawnEggItem egg;
            Entity eggEntity;
            LootParams.Builder builder;
            ResourceLocation tablePath = Spelunkery.res("gameplay/sluice/" + fluidName + "/" + itemName);
            LootTable lootTable = Objects.requireNonNull(level.m_7654_()).m_278653_().m_278676_(tablePath);
            ObjectArrayList lootList = lootTable.m_287195_((builder = new LootParams.Builder((ServerLevel)level).m_287286_(LootContextParams.f_81461_, (Object)level.m_8055_(pos)).m_287286_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)pos)).m_287286_(LootContextParams.f_81463_, (Object)ItemStack.f_41583_).m_287289_(LootContextParams.f_81462_, (Object)entity)).m_287235_(LootContextParamSets.f_81421_));
            if (lootList.isEmpty()) {
                return false;
            }
            ItemStack lootItem = (ItemStack)lootList.iterator().next();
            Item item = lootItem.m_41720_();
            if (item instanceof SpawnEggItem && (eggEntity = (egg = (SpawnEggItem)item).m_43228_(lootItem.m_41783_()).m_20615_(level)) != null) {
                eggEntity.m_6027_((double)pos.m_123341_() + 0.5, (double)(pos.m_123342_() + 1), (double)pos.m_123343_() + 0.5);
                level.m_7967_(eggEntity);
                itemEntity.m_32055_().m_41774_(1);
                return true;
            }
            SluiceBlockEntity.suckInItems((Container)entity, lootItem);
            RandomSource random = level.f_46441_;
            ParticleUtils.m_216318_((Level)level, (BlockPos)pos, (ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, lootItem), (IntProvider)UniformInt.m_146622_((int)3, (int)5), (Direction)Direction.UP, () -> new Vec3(Mth.m_216263_((RandomSource)random, (double)-0.5, (double)0.5), Mth.m_216263_((RandomSource)random, (double)-0.5, (double)0.5), Mth.m_216263_((RandomSource)random, (double)-0.5, (double)0.5)), (double)0.55);
            itemEntity.m_32055_().m_41774_(1);
            return true;
        }
        return false;
    }

    public static boolean suckInItems(Container container, ItemStack itemStack) {
        ItemStack itemStack2 = SluiceBlockEntity.addItem(container, itemStack);
        return itemStack2.m_41619_();
    }

    public static ItemStack addItem(Container destination, ItemStack stack) {
        int j = destination.m_6643_();
        for (int i = 0; i < j && !stack.m_41619_(); ++i) {
            stack = SluiceBlockEntity.tryMoveInItem(destination, stack, i);
        }
        return stack;
    }

    private static ItemStack tryMoveInItem(Container destination, ItemStack stack, int slot) {
        ItemStack itemStack = destination.m_8020_(slot);
        if (SluiceBlockEntity.canPlaceItemInContainer(destination, stack, slot)) {
            int j;
            boolean bl = false;
            boolean bl2 = destination.m_7983_();
            if (itemStack.m_41619_()) {
                destination.m_6836_(slot, stack);
                stack = ItemStack.f_41583_;
                bl = true;
            } else if (SluiceBlockEntity.canMergeItems(itemStack, stack)) {
                int i = stack.m_41741_() - itemStack.m_41613_();
                j = Math.min(stack.m_41613_(), i);
                stack.m_41774_(j);
                itemStack.m_41769_(j);
                boolean bl3 = bl = j > 0;
            }
            if (bl) {
                if (bl2 && destination instanceof SluiceBlockEntity) {
                    SluiceBlockEntity hopperBlockEntity = (SluiceBlockEntity)destination;
                    j = 0;
                    hopperBlockEntity.setCooldown(8 - j);
                }
                destination.m_6596_();
            }
        }
        return stack;
    }

    private static boolean canPlaceItemInContainer(Container container, ItemStack stack, int slot) {
        WorldlyContainer worldlyContainer;
        if (!container.m_7013_(slot, stack)) {
            return false;
        }
        if (container instanceof WorldlyContainer && !(worldlyContainer = (WorldlyContainer)container).m_7155_(slot, stack, null)) {
            boolean var10000 = false;
            return var10000;
        }
        boolean var10000 = true;
        return var10000;
    }

    private static boolean canMergeItems(ItemStack stack1, ItemStack stack2) {
        return stack1.m_41613_() <= stack1.m_41741_() && ItemStack.m_150942_((ItemStack)stack1, (ItemStack)stack2);
    }
}

