/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.spelunkery.blocks;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.ordana.spelunkery.Spelunkery;
import com.ordana.spelunkery.blocks.ModBaseEntityBlock;
import com.ordana.spelunkery.blocks.entity.SluiceBlockEntity;
import com.ordana.spelunkery.reg.ModBlockProperties;
import com.ordana.spelunkery.reg.ModBlocks;
import com.ordana.spelunkery.reg.ModEntities;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Map;
import java.util.Objects;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ParticleUtils;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class SluiceBlock
extends ModBaseEntityBlock {
    public static final BooleanProperty GRATE_NORTH = ModBlockProperties.GRATE_NORTH;
    public static final BooleanProperty GRATE_SOUTH;
    public static final BooleanProperty GRATE_EAST;
    public static final BooleanProperty GRATE_WEST;
    protected static final VoxelShape SHAPE_TALL_N;
    protected static final VoxelShape SHAPE_TALL_E;
    protected static final VoxelShape SHAPE_TALL_S;
    protected static final VoxelShape SHAPE_TALL_W;
    protected static final VoxelShape SHAPE_TALL_NE;
    protected static final VoxelShape SHAPE_TALL_SE;
    protected static final VoxelShape SHAPE_TALL_NW;
    protected static final VoxelShape SHAPE_TALL_SW;
    protected static final VoxelShape SHAPE_TALL_EW;
    protected static final VoxelShape SHAPE_TALL_NS;
    protected static final VoxelShape SHAPE_TALL_NES;
    protected static final VoxelShape SHAPE_TALL_ESW;
    protected static final VoxelShape SHAPE_TALL_SWN;
    protected static final VoxelShape SHAPE_TALL_WNE;
    protected static final VoxelShape SHAPE_TALL_NESW;
    protected static final VoxelShape SHAPE_TALL_NONE;
    public static final Map<Direction, BooleanProperty> GRATE_PROPERTY_BY_DIRECTION;

    public SluiceBlock(BlockBehaviour.Properties properties) {
        super(properties);
        super.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)GRATE_NORTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)GRATE_SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)GRATE_EAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)GRATE_WEST, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{SUPPORTED, NORTH, EAST, SOUTH, WEST, GRATE_NORTH, GRATE_EAST, GRATE_SOUTH, GRATE_WEST});
    }

    public boolean m_6724_(BlockState state) {
        return (Boolean)state.m_61143_((Property)GRATE_NORTH) != false || (Boolean)state.m_61143_((Property)GRATE_EAST) != false || (Boolean)state.m_61143_((Property)GRATE_WEST) != false || (Boolean)state.m_61143_((Property)GRATE_SOUTH) != false;
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        SluiceBlockEntity sluice;
        int flow;
        block9: {
            block8: {
                flow = SluiceBlock.getFlow((Level)level, state, pos);
                BlockEntity blockEntity = level.m_7702_(pos);
                if (!(blockEntity instanceof SluiceBlockEntity)) break block8;
                sluice = (SluiceBlockEntity)blockEntity;
                if (flow != 0) break block9;
            }
            return;
        }
        String fluidName = Utils.getID((Fluid)level.m_6425_(pos.m_7494_()).m_76152_()).m_135815_();
        if (!Objects.equals(fluidName, "empty")) {
            if (fluidName.contains("flowing_")) {
                fluidName = fluidName.replace("flowing_", "");
            }
            ResourceLocation tablePath = Spelunkery.res("gameplay/sluice/" + fluidName + "/passive");
            LootTable lootTable = Objects.requireNonNull(level.m_7654_()).m_278653_().m_278676_(tablePath);
            LootParams.Builder builder = new LootParams.Builder(level).m_287286_(LootContextParams.f_81461_, (Object)level.m_8055_(pos)).m_287286_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)pos)).m_287286_(LootContextParams.f_81463_, (Object)ItemStack.f_41583_).m_287289_(LootContextParams.f_81462_, (Object)sluice);
            for (int i = 0; i < flow; ++i) {
                SpawnEggItem egg;
                Entity eggEntity;
                ObjectArrayList lootItem = lootTable.m_287195_(builder.m_287235_(LootContextParamSets.f_81421_));
                if (lootItem.isEmpty()) {
                    return;
                }
                Item item = ((ItemStack)lootItem.iterator().next()).m_41720_();
                if (item instanceof SpawnEggItem && (eggEntity = (egg = (SpawnEggItem)item).m_43228_(((ItemStack)lootItem.iterator().next()).m_41783_()).m_20615_((Level)level)) != null) {
                    eggEntity.m_6027_((double)pos.m_123341_() + 0.5, (double)(pos.m_123342_() + 1), (double)pos.m_123343_() + 0.5);
                    level.m_7967_(eggEntity);
                    return;
                }
                boolean bl = SluiceBlockEntity.suckInItems((Container)sluice, (ItemStack)lootItem.iterator().next());
                SluiceBlockEntity.tryFilterItems((Level)level, pos, state, sluice, flow, () -> bl);
            }
        }
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack stack = player.m_21120_(hand);
        boolean stone = state.m_60713_(ModBlocks.STONE_SLUICE.get());
        boolean tool = stone ? stack.m_204117_(ItemTags.f_271360_) : stack.m_204117_(ItemTags.f_271207_);
        Direction dir = hit.m_82434_();
        if (tool && dir != Direction.DOWN && dir != Direction.UP) {
            if (((Boolean)state.m_61143_((Property)PROPERTY_BY_DIRECTION.get(dir))).booleanValue()) {
                level.m_7731_(pos, (BlockState)((BlockState)state.m_61124_((Property)PROPERTY_BY_DIRECTION.get(dir), (Comparable)Boolean.valueOf(false))).m_61124_((Property)GRATE_PROPERTY_BY_DIRECTION.get(dir), (Comparable)Boolean.valueOf(true)), 3);
                if (!stone) {
                    level.m_5594_(null, pos, SoundEvents.f_11688_, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
                level.m_5594_(null, pos, stone ? SoundEvents.f_12442_ : SoundEvents.f_12630_, SoundSource.BLOCKS, 1.0f, 1.0f);
                level.m_5594_(null, pos, SoundEvents.f_11745_, SoundSource.BLOCKS, 1.0f, 1.0f);
                ParticleUtils.m_216313_((Level)level, (BlockPos)pos, (ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, this.m_49966_()), (IntProvider)UniformInt.m_146622_((int)3, (int)5));
            } else if (((Boolean)state.m_61143_((Property)GRATE_PROPERTY_BY_DIRECTION.get(dir))).booleanValue()) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)GRATE_PROPERTY_BY_DIRECTION.get(dir), (Comparable)Boolean.valueOf(false)), 3);
                if (!stone) {
                    level.m_5594_(null, pos, SoundEvents.f_11688_, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
                level.m_5594_(null, pos, SoundEvents.f_11794_, SoundSource.BLOCKS, 1.0f, 1.0f);
                ParticleUtils.m_216313_((Level)level, (BlockPos)pos, (ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, this.m_49966_()), (IntProvider)UniformInt.m_146622_((int)3, (int)5));
            } else if (!((Boolean)state.m_61143_((Property)GRATE_PROPERTY_BY_DIRECTION.get(dir))).booleanValue()) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)PROPERTY_BY_DIRECTION.get(dir), (Comparable)Boolean.valueOf(true)), 3);
                level.m_5594_(null, pos, stone ? SoundEvents.f_12447_ : SoundEvents.f_12635_, SoundSource.BLOCKS, 1.0f, 1.0f);
                if (!level.m_6425_(pos.m_121945_(dir).m_7494_()).m_192917_(Fluids.f_76191_)) {
                    level.m_7731_(pos.m_121945_(dir).m_7494_(), Blocks.f_50016_.m_49966_(), 3);
                }
            }
            if (!player.m_7500_()) {
                stack.m_41622_(1, (LivingEntity)player, playerx -> playerx.m_21190_(hand));
            }
            player.m_36246_(Stats.f_12982_.m_12902_((Object)stack.m_41720_()));
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof SluiceBlockEntity) {
            player.m_5893_((MenuProvider)((SluiceBlockEntity)blockEntity));
        }
        return InteractionResult.CONSUME;
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        EntityCollisionContext c;
        if (context instanceof EntityCollisionContext && (c = (EntityCollisionContext)context).m_193113_() instanceof ItemEntity) {
            boolean north = (Boolean)state.m_61143_((Property)NORTH) != false || (Boolean)state.m_61143_((Property)GRATE_NORTH) != false;
            boolean south = (Boolean)state.m_61143_((Property)SOUTH) != false || (Boolean)state.m_61143_((Property)GRATE_SOUTH) != false;
            boolean east = (Boolean)state.m_61143_((Property)EAST) != false || (Boolean)state.m_61143_((Property)GRATE_EAST) != false;
            boolean west = (Boolean)state.m_61143_((Property)WEST) != false || (Boolean)state.m_61143_((Property)GRATE_WEST) != false;
            VoxelShape model = SHAPE_TALL_NONE;
            if (north && south && east && west) {
                return SHAPE_TALL_NESW;
            }
            if (north) {
                model = SHAPE_TALL_N;
                if (east) {
                    model = SHAPE_TALL_NE;
                    if (west) {
                        return SHAPE_TALL_WNE;
                    }
                }
                if (west) {
                    model = SHAPE_TALL_NW;
                    if (south) {
                        return SHAPE_TALL_SWN;
                    }
                }
                if (south) {
                    model = SHAPE_TALL_NS;
                    if (east) {
                        return SHAPE_TALL_NES;
                    }
                }
            } else if (east) {
                model = SHAPE_TALL_E;
                if (south) {
                    model = SHAPE_TALL_SE;
                    if (west) {
                        return SHAPE_TALL_ESW;
                    }
                } else if (west) {
                    return SHAPE_TALL_EW;
                }
            } else if (south) {
                model = SHAPE_TALL_S;
                if (west) {
                    return SHAPE_TALL_SW;
                }
            } else if (west) {
                return SHAPE_TALL_W;
            }
            return model;
        }
        return super.m_5940_(state, level, pos, context);
    }

    public static int getFlow(Level level, BlockState state, BlockPos pos) {
        int flowCount = 0;
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockPos neighborPos = pos.m_121945_(direction);
            if (level.m_6425_(neighborPos).m_192917_(Fluids.f_76191_) || !((Boolean)state.m_61143_((Property)GRATE_PROPERTY_BY_DIRECTION.get(direction))).booleanValue()) continue;
            ++flowCount;
        }
        return flowCount;
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        if (!state.m_60713_(newState.m_60734_())) {
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof Container) {
                Containers.m_19002_((Level)level, (BlockPos)pos, (Container)((Container)blockEntity));
                level.m_46717_(pos, (Block)this);
            }
            super.m_6810_(state, level, pos, newState, movedByPiston);
        }
    }

    @Override
    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof SluiceBlockEntity) {
            ((SluiceBlockEntity)blockEntity).recheckOpen();
        }
        super.m_213897_(state, level, pos, random);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new SluiceBlockEntity(pos, state);
    }

    @Override
    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        BlockEntity blockEntity;
        if (stack.m_41788_() && (blockEntity = level.m_7702_(pos)) instanceof SluiceBlockEntity) {
            ((SluiceBlockEntity)blockEntity).m_58638_(stack.m_41786_());
        }
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState state, Level level, BlockPos pos) {
        return AbstractContainerMenu.m_38918_((BlockEntity)level.m_7702_(pos));
    }

    @Override
    public boolean m_8133_(BlockState state, Level level, BlockPos pos, int id, int param) {
        super.m_8133_(state, level, pos, id, param);
        BlockEntity blockEntity = level.m_7702_(pos);
        return blockEntity != null && blockEntity.m_7531_(id, param);
    }

    @Override
    @Nullable
    public MenuProvider m_7246_(BlockState state, Level level, BlockPos pos) {
        BlockEntity blockEntity = level.m_7702_(pos);
        return blockEntity instanceof MenuProvider ? (MenuProvider)blockEntity : null;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        if (!level.f_46443_) {
            return SluiceBlock.createTickerHelper(blockEntityType, state.m_60713_(ModBlocks.WOODEN_SLUICE.get()) ? ModEntities.WOODEN_SLUICE.get() : ModEntities.STONE_SLUICE.get(), SluiceBlockEntity::pushItemsTick);
        }
        return super.m_142354_(level, state, blockEntityType);
    }

    static {
        GRATE_EAST = ModBlockProperties.GRATE_EAST;
        GRATE_SOUTH = ModBlockProperties.GRATE_SOUTH;
        GRATE_WEST = ModBlockProperties.GRATE_WEST;
        GRATE_PROPERTY_BY_DIRECTION = ImmutableMap.copyOf((Map)((Map)Util.m_137469_((Object)Maps.newEnumMap(Direction.class), enumMap -> {
            enumMap.put(Direction.NORTH, GRATE_NORTH);
            enumMap.put(Direction.EAST, GRATE_EAST);
            enumMap.put(Direction.SOUTH, GRATE_SOUTH);
            enumMap.put(Direction.WEST, GRATE_WEST);
        })));
        SHAPE_TALL_NONE = Shapes.m_83110_((VoxelShape)SHAPE_LEGS, (VoxelShape)SHAPE_BASE);
        SHAPE_TALL_N = Shapes.m_83124_((VoxelShape)SHAPE_LEGS, (VoxelShape[])new VoxelShape[]{SHAPE_BASE, Block.m_49796_((double)0.0, (double)12.0, (double)-2.0, (double)16.0, (double)32.0, (double)0.0)});
        SHAPE_TALL_E = Shapes.m_83124_((VoxelShape)SHAPE_LEGS, (VoxelShape[])new VoxelShape[]{SHAPE_BASE, Block.m_49796_((double)16.0, (double)12.0, (double)0.0, (double)18.0, (double)32.0, (double)16.0)});
        SHAPE_TALL_S = Shapes.m_83124_((VoxelShape)SHAPE_LEGS, (VoxelShape[])new VoxelShape[]{SHAPE_BASE, Block.m_49796_((double)0.0, (double)12.0, (double)16.0, (double)16.0, (double)32.0, (double)18.0)});
        SHAPE_TALL_W = Shapes.m_83124_((VoxelShape)SHAPE_LEGS, (VoxelShape[])new VoxelShape[]{SHAPE_BASE, Block.m_49796_((double)-2.0, (double)12.0, (double)0.0, (double)0.0, (double)32.0, (double)16.0)});
        SHAPE_TALL_NE = Shapes.m_83110_((VoxelShape)SHAPE_TALL_N, (VoxelShape)SHAPE_TALL_E);
        SHAPE_TALL_SE = Shapes.m_83110_((VoxelShape)SHAPE_TALL_S, (VoxelShape)SHAPE_TALL_E);
        SHAPE_TALL_NW = Shapes.m_83110_((VoxelShape)SHAPE_TALL_N, (VoxelShape)SHAPE_TALL_W);
        SHAPE_TALL_SW = Shapes.m_83110_((VoxelShape)SHAPE_TALL_S, (VoxelShape)SHAPE_TALL_W);
        SHAPE_TALL_EW = Shapes.m_83110_((VoxelShape)SHAPE_TALL_E, (VoxelShape)SHAPE_TALL_W);
        SHAPE_TALL_NS = Shapes.m_83110_((VoxelShape)SHAPE_TALL_N, (VoxelShape)SHAPE_TALL_S);
        SHAPE_TALL_NES = Shapes.m_83124_((VoxelShape)SHAPE_TALL_N, (VoxelShape[])new VoxelShape[]{SHAPE_TALL_E, SHAPE_TALL_S});
        SHAPE_TALL_ESW = Shapes.m_83124_((VoxelShape)SHAPE_TALL_E, (VoxelShape[])new VoxelShape[]{SHAPE_TALL_S, SHAPE_TALL_W});
        SHAPE_TALL_SWN = Shapes.m_83124_((VoxelShape)SHAPE_TALL_S, (VoxelShape[])new VoxelShape[]{SHAPE_TALL_W, SHAPE_TALL_N});
        SHAPE_TALL_WNE = Shapes.m_83124_((VoxelShape)SHAPE_TALL_W, (VoxelShape[])new VoxelShape[]{SHAPE_TALL_N, SHAPE_TALL_E});
        SHAPE_TALL_NESW = Shapes.m_83124_((VoxelShape)SHAPE_TALL_N, (VoxelShape[])new VoxelShape[]{SHAPE_TALL_E, SHAPE_TALL_S, SHAPE_TALL_W});
    }
}

