/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe668.cloudstorage.misc;

import com.github.alexthe668.cloudstorage.inventory.CloudChestContainer;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.SimpleContainer;

public class CloudIndex {
    private UUID playerUUID;
    private int balloonColor;
    private int containerSize;
    private CloudChestContainer container;

    public CloudIndex(UUID playerUUID, int balloonColor, int size) {
        this.playerUUID = playerUUID;
        this.balloonColor = balloonColor;
        this.containerSize = size;
        this.container = new CloudChestContainer(size);
    }

    public CloudIndex(CompoundTag innerTag) {
        this.balloonColor = innerTag.m_128451_("BalloonColor");
        this.containerSize = innerTag.m_128451_("Size");
        this.playerUUID = innerTag.m_128342_("PlayerUUID");
        this.container = new CloudChestContainer(this.containerSize);
        this.container.m_7797_(innerTag.m_128437_("ContainerTag", 10));
    }

    public void writeToNBT(CompoundTag tag) {
        tag.m_128405_("BalloonColor", this.balloonColor);
        tag.m_128405_("Size", this.containerSize);
        tag.m_128362_("PlayerUUID", this.playerUUID);
        tag.m_128365_("ContainerTag", (Tag)this.container.m_7927_());
    }

    public void resize(int newSize) {
        if (this.containerSize != newSize) {
            ListTag tag = new ListTag();
            if (this.container != null) {
                tag = this.container.m_7927_();
            }
            this.containerSize = newSize;
            this.container = new CloudChestContainer(newSize);
            this.container.m_7797_(tag);
        }
    }

    public int getBalloonColor() {
        return this.balloonColor;
    }

    public void setBalloonColor(int balloonColor) {
        this.balloonColor = balloonColor;
    }

    public int getContainerSize() {
        return this.containerSize;
    }

    public SimpleContainer getContainer() {
        return this.container;
    }

    public UUID getPlayerUUID() {
        return this.playerUUID;
    }

    public int calcUsedSlots() {
        int slots = 0;
        for (int i = 0; i < this.container.m_6643_(); ++i) {
            if (this.container.m_8020_(i).m_41619_()) continue;
            ++slots;
        }
        return slots;
    }
}

