/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe668.cloudstorage.item;

import com.github.alexthe668.cloudstorage.entity.BalloonBuddyEntity;
import com.github.alexthe668.cloudstorage.entity.BalloonFace;
import com.github.alexthe668.cloudstorage.entity.CSEntityRegistry;
import com.github.alexthe668.cloudstorage.item.BalloonItem;
import com.github.alexthe668.cloudstorage.item.CustomTabBehavior;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;

public class BalloonBuddyItem
extends BalloonItem
implements CustomTabBehavior {
    public BalloonBuddyItem() {
        super(new Item.Properties().m_41487_(1));
    }

    @Override
    public InteractionResult m_6225_(UseOnContext context) {
        BlockPos blockpos = context.m_8083_();
        Direction direction = context.m_43719_();
        BlockPos blockpos1 = blockpos.m_121945_(direction);
        Level level = context.m_43725_();
        BalloonBuddyEntity balloon = (BalloonBuddyEntity)((EntityType)CSEntityRegistry.BALLOON_BUDDY.get()).m_20615_(level);
        Player player = context.m_43723_();
        ItemStack itemstack = context.m_43722_();
        if (itemstack.m_41783_() != null && itemstack.m_41783_().m_128441_("MobNBT") && itemstack.m_41783_().m_128469_("MobNBT") != null) {
            balloon.m_7378_(itemstack.m_41783_().m_128469_("MobNBT"));
        } else {
            balloon.setCommand(2);
        }
        balloon.setBalloonColor(this.m_41121_(itemstack));
        if (itemstack.m_41783_() != null && itemstack.m_41783_().m_128441_("Health")) {
            balloon.m_21153_(itemstack.m_41783_().m_128457_("Health"));
        }
        if (BalloonBuddyItem.getPersonality(itemstack) != null) {
            balloon.setPersonality(BalloonBuddyItem.getPersonality(itemstack));
        }
        if (player != null) {
            balloon.m_7105_(true);
            balloon.m_21816_(player.m_20148_());
        }
        if (itemstack.m_41788_()) {
            balloon.m_6593_(itemstack.m_41786_());
        }
        balloon.m_6034_((float)blockpos1.m_123341_() + 0.5f, (float)blockpos1.m_123342_() + 0.5f, (float)blockpos1.m_123343_() + 0.5f);
        if (level.m_45786_((Entity)balloon)) {
            if (!level.f_46443_) {
                level.m_142346_((Entity)player, GameEvent.f_157810_, blockpos);
                level.m_7967_((Entity)balloon);
            }
            if (!player.m_7500_()) {
                itemstack.m_41774_(1);
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return InteractionResult.PASS;
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> components, TooltipFlag flags) {
        if (BalloonBuddyItem.getPersonality(stack) != null) {
            components.add((Component)Component.m_237115_((String)BalloonBuddyItem.getPersonality(stack).getPersonalityText()).m_130940_(ChatFormatting.GRAY));
        }
        super.m_7373_(stack, level, components, flags);
    }

    @Override
    public void fillItemCategory(CreativeModeTab.Output contents) {
        for (int i = BalloonFace.HAPPY.ordinal(); i < BalloonFace.values().length; ++i) {
            contents.m_246342_(this.createBalloon(15149353, BalloonFace.values()[i]));
        }
    }

    public ItemStack createBalloon(int color, BalloonFace face) {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("color", color);
        tag.m_128405_("Personality", face.ordinal());
        ItemStack stack = new ItemStack((ItemLike)this);
        stack.m_41751_(tag);
        return stack;
    }

    public static BalloonFace getPersonality(ItemStack stack) {
        CompoundTag compoundtag = stack.m_41783_();
        return compoundtag != null && compoundtag.m_128425_("Personality", 99) && compoundtag.m_128451_("Personality") != -1 ? BalloonFace.values()[Mth.m_14045_((int)compoundtag.m_128451_("Personality"), (int)0, (int)(BalloonFace.values().length - 1))] : null;
    }

    @Override
    public void m_6883_(ItemStack stack, Level level, Entity entity, int i, boolean held) {
        super.m_6883_(stack, level, entity, i, held);
        if (!level.f_46443_) {
            if (BalloonBuddyItem.getPersonality(stack) == null) {
                CompoundTag compoundtag = stack.m_41784_();
                compoundtag.m_128405_("Personality", BalloonFace.getRandomPersonality(level.m_213780_()).ordinal());
                stack.m_41751_(compoundtag);
            }
        }
    }
}

