/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe668.cloudstorage.entity.villager;

import com.github.alexthe668.cloudstorage.block.CSBlockRegistry;
import com.github.alexthe668.cloudstorage.item.CSItemRegistry;
import com.github.alexthe668.cloudstorage.world.CSStructureRegistry;
import com.mojang.datafixers.util.Pair;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.maps.MapDecoration;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;

public class SellingMap
implements VillagerTrades.ItemListing {
    private final int emeraldCost;
    private final boolean balloon;
    private final String displayName;
    private final MapDecoration.Type destinationType;
    private final int maxUses;
    private final int villagerXp;

    public SellingMap(int cost, boolean balloon, String displayName, MapDecoration.Type destinationType, int uses, int exp) {
        this.emeraldCost = cost;
        this.balloon = balloon;
        this.displayName = displayName;
        this.destinationType = destinationType;
        this.maxUses = uses;
        this.villagerXp = exp;
    }

    @Nullable
    public BlockPos findNearestMapFeature(ServerLevel level, BlockPos pos, int dist, boolean bool) {
        if (!level.m_7654_().m_129910_().m_246337_().m_247749_()) {
            return null;
        }
        try {
            Registry registry = level.m_6018_().m_9598_().m_175515_(Registries.f_256944_);
            Holder.Reference holder = this.balloon ? registry.m_246971_(CSStructureRegistry.BIG_BALLOON_KEY) : registry.m_246971_(CSStructureRegistry.SKY_TEMPLE_KEY);
            HolderSet.Direct holderset = HolderSet.m_205809_((Holder[])new Holder[]{holder});
            Pair pair = level.m_7726_().m_8481_().m_223037_(level, (HolderSet)holderset, pos, 100, false);
            return pair == null ? null : (BlockPos)pair.getFirst();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Nullable
    public MerchantOffer m_213663_(Entity entity, RandomSource random) {
        if (!(entity.m_9236_() instanceof ServerLevel)) {
            return null;
        }
        ServerLevel serverlevel = (ServerLevel)entity.m_9236_();
        BlockPos blockpos = this.findNearestMapFeature(serverlevel, entity.m_20183_(), 100, true);
        if (blockpos != null) {
            ItemStack itemstack = MapItem.m_42886_((Level)serverlevel, (int)blockpos.m_123341_(), (int)blockpos.m_123343_(), (byte)2, (boolean)true, (boolean)true);
            MapItem.m_42850_((ServerLevel)serverlevel, (ItemStack)itemstack);
            MapItemSavedData.m_77925_((ItemStack)itemstack, (BlockPos)blockpos, (String)"+", (MapDecoration.Type)this.destinationType);
            CompoundTag compoundtag1 = itemstack.m_41698_("display");
            compoundtag1.m_128405_("MapColor", this.balloon ? 15149353 : 10924991);
            itemstack.m_41714_((Component)Component.m_237115_((String)this.displayName));
            return new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, this.emeraldCost), new ItemStack(this.balloon ? (ItemLike)CSItemRegistry.BALLOON.get() : (ItemLike)CSBlockRegistry.CLOUD.get()), itemstack, this.maxUses, this.villagerXp, 0.2f);
        }
        return null;
    }
}

