/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe668.cloudstorage.entity;

import com.github.alexthe668.cloudstorage.client.particle.CSParticleRegistry;
import com.github.alexthe668.cloudstorage.entity.BalloonFlyer;
import com.github.alexthe668.cloudstorage.entity.CSEntityRegistry;
import com.github.alexthe668.cloudstorage.entity.ai.BloviatorAttackGoal;
import com.github.alexthe668.cloudstorage.entity.ai.FlightMoveController;
import com.github.alexthe668.cloudstorage.entity.ai.FlyAroundGoal;
import com.github.alexthe668.cloudstorage.item.CSItemRegistry;
import com.github.alexthe668.cloudstorage.misc.CSSoundRegistry;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;

public class BloviatorEntity
extends Monster
implements BalloonFlyer {
    private static final EntityDataAccessor<Float> CLOUD_SCALE = SynchedEntityData.m_135353_(BloviatorEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Integer> PUSH_ENTITY = SynchedEntityData.m_135353_(BloviatorEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> SHOCK_ENTITY = SynchedEntityData.m_135353_(BloviatorEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> THUNDERY = SynchedEntityData.m_135353_(BloviatorEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> CHARGE = SynchedEntityData.m_135353_(BloviatorEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> SHOCKTIME = SynchedEntityData.m_135353_(BloviatorEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final ResourceLocation THUNDERY_LOOT_TABLE = new ResourceLocation("cloudstorage:entities/bloviator_thunder");
    public final double[][] positions = new double[64][4];
    public int posPointer = -1;
    private float pushProgress;
    private float prevPushProgress;
    private float transformProgress;
    private float prevTransformProgress;
    private int prevShockTime;
    private int prevChargeTime;
    private int blowingSoundTime = 0;

    protected BloviatorEntity(EntityType type, Level level) {
        super(type, level);
        this.f_21342_ = new FlightMoveController((Mob)this, 1.0f, true, 5.0f);
    }

    public static AttributeSupplier.Builder bakeAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 16.0).m_22268_(Attributes.f_22281_, 1.0).m_22268_(Attributes.f_22279_, (double)0.15f).m_22268_(Attributes.f_22280_, (double)0.15f).m_22268_(Attributes.f_22277_, 32.0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(CLOUD_SCALE, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(PUSH_ENTITY, (Object)-1);
        this.f_19804_.m_135372_(SHOCK_ENTITY, (Object)-1);
        this.f_19804_.m_135372_(THUNDERY, (Object)false);
        this.f_19804_.m_135372_(CHARGE, (Object)1);
        this.f_19804_.m_135372_(SHOCKTIME, (Object)0);
    }

    protected void m_7562_() {
        if (this.f_19796_.m_188499_()) {
            ++this.f_20891_;
        }
    }

    public boolean isPushing() {
        return (Integer)this.f_19804_.m_135370_(PUSH_ENTITY) != -1 && !this.isThundery();
    }

    public boolean isShocking() {
        return (Integer)this.f_19804_.m_135370_(SHOCK_ENTITY) != -1 && this.isThundery();
    }

    public boolean isThundery() {
        return (Boolean)this.f_19804_.m_135370_(THUNDERY);
    }

    public void setThundery(boolean thundery, boolean progress) {
        this.f_19804_.m_135381_(THUNDERY, (Object)thundery);
        if (progress && thundery) {
            this.transformProgress = 5.0f;
            this.prevTransformProgress = 5.0f;
        }
    }

    @Nullable
    public Entity getPushingEntity() {
        if (!this.isPushing()) {
            return null;
        }
        return this.m_9236_().m_6815_(((Integer)this.f_19804_.m_135370_(PUSH_ENTITY)).intValue());
    }

    @Nullable
    public Entity getShockingEntity() {
        if (!this.isShocking()) {
            return null;
        }
        return this.m_9236_().m_6815_(((Integer)this.f_19804_.m_135370_(SHOCK_ENTITY)).intValue());
    }

    public int getChargeTime() {
        return (Integer)this.f_19804_.m_135370_(CHARGE);
    }

    public void setChargeTime(int i) {
        this.f_19804_.m_135381_(CHARGE, (Object)i);
    }

    public int getShockTime() {
        return (Integer)this.f_19804_.m_135370_(SHOCKTIME);
    }

    public void setShockTime(int i) {
        this.f_19804_.m_135381_(SHOCKTIME, (Object)i);
    }

    protected void setCloudScale(float size, boolean heal) {
        float i = Mth.m_14036_((float)size, (float)0.25f, (float)2.0f);
        this.f_19804_.m_135381_(CLOUD_SCALE, (Object)Float.valueOf(i));
        this.m_20090_();
        this.m_6210_();
        this.m_21051_(Attributes.f_22276_).m_22100_((double)(i * 16.0f));
        this.m_21051_(Attributes.f_22281_).m_22100_((double)i);
        if (heal) {
            this.m_21153_(this.m_21233_());
        }
        this.f_21364_ = (int)(i * 4.0f);
    }

    public void m_6210_() {
        double d0 = this.m_20185_();
        double d1 = this.m_20186_();
        double d2 = this.m_20189_();
        super.m_6210_();
        this.m_6034_(d0, d1, d2);
    }

    public float getCloudScale() {
        return ((Float)this.f_19804_.m_135370_(CLOUD_SCALE)).floatValue();
    }

    public void m_7350_(EntityDataAccessor<?> p_33609_) {
        if (CLOUD_SCALE.equals(p_33609_)) {
            this.m_6210_();
            this.m_146922_(this.f_20885_);
            this.f_20883_ = this.f_20885_;
            if (this.m_20069_() && this.f_19796_.m_188503_(20) == 0) {
                this.m_5841_();
            }
        }
        super.m_7350_(p_33609_);
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)CSSoundRegistry.BLOVIATOR_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)CSSoundRegistry.BLOVIATOR_HURT.get();
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)CSSoundRegistry.BLOVIATOR_IDLE.get();
    }

    public float m_6100_() {
        float f = 1.0f / Mth.m_14036_((float)this.getCloudScale(), (float)0.25f, (float)2.0f);
        return super.m_6100_() * Mth.m_14116_((float)f);
    }

    protected ResourceLocation m_7582_() {
        return this.isTiny() ? (this.isThundery() ? THUNDERY_LOOT_TABLE : this.m_6095_().m_20677_()) : BuiltInLootTables.f_78712_;
    }

    public void m_142687_(Entity.RemovalReason reason) {
        float i = this.getCloudScale();
        if (!this.m_9236_().f_46443_ && i > 0.25f && this.m_21224_()) {
            Component component = this.m_7770_();
            boolean flag = this.m_21525_();
            float f = i / 4.0f;
            float j = i / 2.0f;
            int k = 2 + this.f_19796_.m_188503_(3);
            for (int l = 0; l < k; ++l) {
                float f1 = ((float)(l % 2) - 0.5f) * f;
                float f2 = ((float)(l / 2) - 0.5f) * f;
                BloviatorEntity mini = (BloviatorEntity)((EntityType)CSEntityRegistry.BLOVIATOR.get()).m_20615_(this.m_9236_());
                if (this.m_21532_()) {
                    mini.m_21530_();
                }
                mini.m_6593_(component);
                mini.m_21557_(flag);
                mini.m_20331_(this.m_20147_());
                mini.setCloudScale(j, true);
                mini.setThundery(this.isThundery(), true);
                mini.m_7678_(this.m_20185_() + (double)f1, this.m_20227_(0.5), this.m_20189_() + (double)f2, this.f_19796_.m_188501_() * 360.0f, 0.0f);
                this.m_9236_().m_7967_((Entity)mini);
            }
        }
        super.m_142687_(reason);
    }

    public float m_5610_(BlockPos pos, LevelReader worldIn) {
        return worldIn.m_8055_(pos).m_60795_() ? 10.0f : 0.0f;
    }

    protected PathNavigation m_6037_(Level worldIn) {
        FlyingPathNavigation flyingpathnavigator = new FlyingPathNavigation((Mob)this, worldIn){

            public boolean m_6342_(BlockPos pos) {
                return this.f_26495_.m_8055_(pos).m_60795_();
            }
        };
        flyingpathnavigator.m_26440_(false);
        flyingpathnavigator.m_7008_(true);
        flyingpathnavigator.m_26443_(true);
        return flyingpathnavigator;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new BloviatorAttackGoal(this));
        this.f_21345_.m_25352_(2, new FlyAroundGoal<BloviatorEntity>(this, 15, 7, 20, 1.0f));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, false, false, null).m_26146_(300));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Sheep.class, 100, false, false, null).m_26146_(300));
        this.f_21346_.m_25352_(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    public boolean causeFallDamage(float distance, float damageMultiplier) {
        return false;
    }

    protected void m_7840_(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
        this.f_19789_ = 0.0f;
    }

    public void m_8119_() {
        super.m_8119_();
        this.prevPushProgress = this.pushProgress;
        this.prevTransformProgress = this.transformProgress;
        this.prevShockTime = this.getShockTime();
        this.prevChargeTime = this.getChargeTime();
        this.m_20256_(this.m_20184_().m_82542_((double)0.8f, (double)0.6f, (double)0.8f));
        if (this.posPointer < 0) {
            for (int i = 0; i < this.positions.length; ++i) {
                this.positions[i][0] = this.m_20185_();
                this.positions[i][1] = this.m_20186_();
                this.positions[i][2] = this.m_20189_();
                this.positions[i][3] = this.f_20883_;
            }
        }
        if (++this.posPointer == this.positions.length) {
            this.posPointer = 0;
        }
        this.positions[this.posPointer][0] = this.m_20185_();
        this.positions[this.posPointer][1] = this.m_20186_();
        this.positions[this.posPointer][2] = this.m_20189_();
        this.positions[this.posPointer][3] = this.f_20883_;
        Entity pushing = this.getPushingEntity();
        if (pushing == null) {
            if (this.pushProgress > 0.0f) {
                this.pushProgress -= 1.0f;
            }
            if (!this.m_9236_().f_46443_ && this.m_5448_() != null && this.m_5448_().m_6084_() && this.canPush((Entity)this.m_5448_())) {
                this.f_19804_.m_135381_(PUSH_ENTITY, (Object)this.m_5448_().m_19879_());
            }
            this.blowingSoundTime = 0;
        } else {
            if (this.pushProgress < 5.0f) {
                this.pushProgress += 1.0f;
            }
            if (this.blowingSoundTime % 60 == 0) {
                this.m_5496_((SoundEvent)CSSoundRegistry.BLOVIATOR_BLOW.get(), this.m_6121_(), this.m_6100_());
            }
            ++this.blowingSoundTime;
            if (this.canPush(pushing)) {
                Vec3 mouth = this.getMouthVec(1.0f);
                Vec3 vec2 = pushing.m_20182_().m_82546_(this.m_20182_()).m_82541_().m_82490_((double)(0.1f * this.getCloudScale()));
                if (this.m_9236_().f_46443_) {
                    for (int i = 0; i < this.getCloudCount(); ++i) {
                        Vec3 randomOffset = new Vec3((double)(this.f_19796_.m_188501_() - 0.5f), (double)(this.f_19796_.m_188501_() - 0.5f), (double)(this.f_19796_.m_188501_() - 0.5f)).m_82490_((double)this.getCloudScale());
                        Vec3 vec3 = pushing.m_146892_().m_82549_(randomOffset).m_82546_(mouth).m_82541_().m_82549_(this.m_20184_()).m_82490_(0.5);
                        this.m_9236_().m_7106_((ParticleOptions)CSParticleRegistry.BLOVIATOR_BREATH.get(), mouth.f_82479_, mouth.f_82480_, mouth.f_82481_, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
                    }
                }
                pushing.m_20256_(pushing.m_20184_().m_82549_(vec2));
            } else if (!this.m_9236_().f_46443_) {
                this.f_19804_.m_135381_(PUSH_ENTITY, (Object)-1);
            }
        }
        if (this.isThundery()) {
            if (this.transformProgress < 5.0f) {
                this.transformProgress += 1.0f;
            }
            if (this.m_5448_() != null && this.m_5448_().m_6084_() && this.m_142582_((Entity)this.m_5448_())) {
                double d0 = this.m_20185_() - this.m_5448_().m_20185_();
                double d2 = this.m_20189_() - this.m_5448_().m_20189_();
                double xzDist = Math.sqrt(d0 * d0 + d2 * d2);
                if (this.isShocking()) {
                    if (this.getShockTime() > 0) {
                        this.setShockTime(this.getShockTime() - 1);
                    } else {
                        this.m_5496_((SoundEvent)CSSoundRegistry.BLOVIATOR_LIGHTNING.get(), this.m_6121_(), 0.65f * this.m_6100_());
                        if (this.getShockingEntity() != null) {
                            this.shock(this.getShockingEntity());
                        }
                        this.f_19804_.m_135381_(SHOCK_ENTITY, (Object)-1);
                    }
                } else if (this.getChargeTime() < this.getMaxChargeTime()) {
                    this.setChargeTime(this.getChargeTime() + 1);
                }
                if (this.m_20186_() > this.m_5448_().m_20227_(0.9) && xzDist < (double)(this.getCloudScale() * 2.0f) && this.getChargeTime() == this.getMaxChargeTime()) {
                    this.setChargeTime(0);
                    this.f_19804_.m_135381_(SHOCK_ENTITY, (Object)this.m_5448_().m_19879_());
                    this.setShockTime(5);
                }
            }
            if (this.getChargeTime() > 1) {
                double d0 = (double)((this.f_19796_.m_188501_() - 0.5f) * this.m_20205_()) + this.m_20184_().f_82479_;
                double d1 = (double)((this.f_19796_.m_188501_() - 0.5f) * this.m_20206_()) + this.m_20184_().f_82480_;
                double d2 = (double)((this.f_19796_.m_188501_() - 0.5f) * this.m_20205_()) + this.m_20184_().f_82481_;
                double dist = 0.2f + this.f_19796_.m_188501_() * 0.2f;
                double d3 = d0 * dist;
                double d4 = d1 * dist;
                double d5 = d2 * dist;
                this.m_9236_().m_7106_((ParticleOptions)CSParticleRegistry.STATIC_LIGHTNING.get(), this.m_20185_() + d0, this.m_20186_() + d1, this.m_20189_() + d2, d3, d4, d5);
            }
        } else {
            if (this.transformProgress > 5.0f) {
                this.transformProgress -= 1.0f;
            }
            if ((this.m_9236_().m_46471_() || this.m_9236_().m_46470_()) && this.m_9236_().m_45527_(this.m_20183_())) {
                this.setThundery(true, false);
            }
        }
    }

    private void shock(Entity target) {
        float damage = Mth.m_14036_((float)((float)this.getCloudCount() * 0.75f), (float)1.0f, (float)10.0f);
        LightningBolt dummy = (LightningBolt)EntityType.f_20465_.m_20615_(this.m_9236_());
        dummy.setDamage(damage);
        if (!ForgeEventFactory.onEntityStruckByLightning((Entity)target, (LightningBolt)dummy)) {
            target.m_8038_((ServerLevel)this.m_9236_(), dummy);
        }
        if (target instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)target;
            living.m_6703_((LivingEntity)this);
        }
    }

    public int getMaxChargeTime() {
        return Math.max((int)(20.0f * this.getCloudScale()), 10);
    }

    public boolean canPush(Entity entity) {
        return entity != null && entity.m_6084_() && entity.f_19789_ < 3.0f && this.m_142582_(entity) && this.m_20270_(entity) < 16.0f * this.getCloudScale();
    }

    public boolean m_20068_() {
        return true;
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128350_("Size", this.getCloudScale());
        tag.m_128379_("Thunder", this.isThundery());
    }

    public void m_7378_(CompoundTag tag) {
        this.setCloudScale(tag.m_128451_("Size"), false);
        this.setThundery(tag.m_128471_("Thunder"), true);
        super.m_7378_(tag);
    }

    public EntityDimensions m_6972_(Pose pose) {
        return super.m_6972_(pose).m_20388_(this.getCloudScale());
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor levelAccessor, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData, @Nullable CompoundTag tag) {
        float rand = this.f_19796_.m_188501_();
        float scale = 1.0f;
        if (rand < 0.001f) {
            scale = 2.0f;
        } else if (rand < 0.5f) {
            scale = 0.5f;
        }
        this.setCloudScale(scale, true);
        return super.m_6518_(levelAccessor, difficulty, spawnType, spawnGroupData, tag);
    }

    public boolean isTiny() {
        return this.getCloudScale() <= 0.25f;
    }

    public double getLatencyVar(int pointer, int index, float partialTick) {
        if (this.m_21224_()) {
            partialTick = 1.0f;
        }
        int i = this.posPointer - pointer & 0x3F;
        int j = this.posPointer - pointer - 1 & 0x3F;
        double d0 = this.positions[j][index];
        double d1 = Mth.m_14175_((double)(this.positions[i][index] - d0));
        return d0 + d1 * (double)partialTick;
    }

    public int m_8085_() {
        return 4;
    }

    public int m_21529_() {
        return 4;
    }

    public int getCloudCount() {
        float f = this.getCloudScale();
        if (f > 1.0f) {
            return 7;
        }
        if (f > 0.5f) {
            return 5;
        }
        if ((double)f > 0.25) {
            return 3;
        }
        return 1;
    }

    public Vec3 getMouthVec(float partialTicks) {
        double x = Mth.m_14139_((double)partialTicks, (double)this.f_19790_, (double)this.m_20185_());
        double y = Mth.m_14139_((double)partialTicks, (double)this.f_19791_, (double)this.m_20186_());
        double z = Mth.m_14139_((double)partialTicks, (double)this.f_19792_, (double)this.m_20189_());
        Vec3 pos = new Vec3(x, y, z);
        Vec3 offset = new Vec3(0.0, (double)0.35f, (double)1.15f).m_82490_((double)this.getCloudScale()).m_82524_(-this.f_20883_ * ((float)Math.PI / 180));
        return pos.m_82549_(offset);
    }

    public float getPushProgress(float partialTick) {
        return (this.prevPushProgress + (this.pushProgress - this.prevPushProgress) * partialTick) / 5.0f;
    }

    public float getTransformProgress(float partialTick) {
        return (this.prevTransformProgress + (this.transformProgress - this.prevTransformProgress) * partialTick) / 5.0f;
    }

    public float getShockTimeLerp(float partialTick) {
        return (float)this.prevShockTime + (float)(this.getShockTime() - this.prevShockTime) * partialTick;
    }

    public float getChargeTimeLerp(float partialTick) {
        return (float)this.prevChargeTime + (float)(this.getChargeTime() - this.prevChargeTime) * partialTick;
    }

    protected InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (this.isTiny() && itemstack.m_150930_(Items.f_42590_)) {
            ItemStack bottle;
            if (!player.m_150110_().f_35937_) {
                itemstack.m_41774_(1);
            }
            if (!player.m_36356_(bottle = new ItemStack((ItemLike)CSItemRegistry.ANGRY_CLOUD_IN_A_BOTTLE.get()))) {
                player.m_19983_(bottle);
            }
            this.m_142687_(Entity.RemovalReason.DISCARDED);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public boolean m_5545_(LevelAccessor worldIn, MobSpawnType spawnReasonIn) {
        return true;
    }

    public static boolean canBloviatorSpawn(EntityType<BloviatorEntity> entityType, ServerLevelAccessor iServerWorld, MobSpawnType reason, BlockPos pos, RandomSource random) {
        return reason == MobSpawnType.SPAWNER || random.m_188501_() < 0.2f && iServerWorld.m_45527_(pos);
    }
}

