/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe668.cloudstorage.client.render;

import com.github.alexthe668.cloudstorage.block.CSBlockRegistry;
import com.github.alexthe668.cloudstorage.client.model.BalloonModel;
import com.github.alexthe668.cloudstorage.client.render.BalloonTextures;
import com.github.alexthe668.cloudstorage.client.render.StringRenderHelper;
import com.github.alexthe668.cloudstorage.entity.BalloonEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class RenderBalloon
extends EntityRenderer<BalloonEntity> {
    private static final BalloonModel BALLOON_MODEL = new BalloonModel();

    public RenderBalloon(EntityRendererProvider.Context renderManagerIn) {
        super(renderManagerIn);
    }

    public ResourceLocation getTextureLocation(BalloonEntity balloon) {
        return balloon.isPopped() ? BalloonTextures.POPPED : BalloonTextures.BALLOON;
    }

    public boolean shouldRender(BalloonEntity entity, Frustum frustum, double x, double y, double z) {
        if (super.m_5523_((Entity)entity, frustum, x, y, z)) {
            return true;
        }
        Entity tie = entity.getTieForRendering();
        return tie != null && frustum.m_113029_(tie.m_20191_());
    }

    public void render(BalloonEntity entityIn, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        int color = entityIn.getBalloonColor();
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        BALLOON_MODEL.setColor(r, g, b);
        matrixStackIn.m_85836_();
        matrixStackIn.m_252781_(Axis.f_252392_.m_252977_(Mth.m_14179_((float)partialTicks, (float)entityIn.f_19859_, (float)entityIn.m_146908_())));
        matrixStackIn.m_252880_(0.0f, 1.5f, 0.0f);
        float rotX = 0.0f;
        matrixStackIn.m_252781_(Axis.f_252529_.m_252977_(180.0f + rotX));
        VertexConsumer ivertexbuilder = bufferIn.m_6299_(RenderType.m_110458_((ResourceLocation)this.getTextureLocation(entityIn)));
        BALLOON_MODEL.m_6973_(entityIn, 0.0f, 0.0f, (float)entityIn.f_19797_ + partialTicks, entityYaw, 0.0f);
        BALLOON_MODEL.m_7695_(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        BALLOON_MODEL.setColor(1.0f, 1.0f, 1.0f);
        if (!entityIn.isPopped()) {
            VertexConsumer ivertexbuilder2 = bufferIn.m_6299_(RenderType.m_110473_((ResourceLocation)BalloonTextures.BALLOON_SHEEN));
            BALLOON_MODEL.m_7695_(matrixStackIn, ivertexbuilder2, packedLightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 0.75f);
        }
        VertexConsumer ivertexbuilder3 = bufferIn.m_6299_(RenderType.m_110473_((ResourceLocation)BalloonTextures.STRING_TIE));
        BALLOON_MODEL.m_7695_(matrixStackIn, ivertexbuilder3, packedLightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStackIn.m_85849_();
        double d0 = Mth.m_14139_((double)partialTicks, (double)entityIn.f_19790_, (double)entityIn.m_20185_());
        double d1 = Mth.m_14139_((double)partialTicks, (double)entityIn.f_19791_, (double)entityIn.m_20186_());
        double d2 = Mth.m_14139_((double)partialTicks, (double)entityIn.f_19792_, (double)entityIn.m_20189_());
        float xRot = entityIn.f_19860_ + (entityIn.m_146909_() - entityIn.f_19860_) * partialTicks;
        float yRot = entityIn.f_19859_ + (entityIn.m_146908_() - entityIn.f_19859_) * partialTicks;
        Vec3 to = new Vec3(d0, d1 - (double)entityIn.getStringLength(), d2);
        if (entityIn.getTieForRendering() != null) {
            double d3 = Mth.m_14139_((double)partialTicks, (double)entityIn.getTieForRendering().f_19790_, (double)entityIn.getTieForRendering().m_20185_());
            double d4 = Mth.m_14139_((double)partialTicks, (double)entityIn.getTieForRendering().f_19791_, (double)entityIn.getTieForRendering().m_20186_());
            double d5 = Mth.m_14139_((double)partialTicks, (double)entityIn.getTieForRendering().f_19792_, (double)entityIn.getTieForRendering().m_20189_());
            double height = entityIn.getTieForRendering().m_20206_() * 0.5f;
            if (entityIn.getTieForRendering() instanceof AbstractArrow) {
                height = 0.0;
            }
            to = new Vec3(d3, d4, d5).m_82520_(0.0, height, 0.0);
        } else {
            float ageInTicks = (float)entityIn.f_19797_ + partialTicks;
            Vec3 swingVec = new Vec3(Math.sin(ageInTicks * 0.1f) * (double)0.2f, 0.0, Math.cos(ageInTicks * 0.1f) * (double)0.2f);
            to = to.m_82549_(swingVec);
        }
        matrixStackIn.m_85836_();
        matrixStackIn.m_85837_(-d0, -d1, -d2);
        Vec3 position = new Vec3(d0, d1, d2);
        Vec3 from = BALLOON_MODEL.translateToBottom(new Vec3(0.0, (double)0.2f, 0.0)).m_82496_(xRot * ((float)Math.PI / 180)).m_82524_(-yRot * ((float)Math.PI / 180));
        StringRenderHelper.renderSting(entityIn, to, partialTicks, matrixStackIn, bufferIn, position.m_82549_(from), packedLightIn);
        matrixStackIn.m_85849_();
        float uploadProgress = entityIn.getUploadProgress(partialTicks);
        if (uploadProgress > 0.0f) {
            uploadProgress = Math.min(uploadProgress * 2.0f, 1.0f);
            matrixStackIn.m_85836_();
            matrixStackIn.m_252880_(0.0f, uploadProgress * (float)(-entityIn.getStringLength()) - 1.0f, 0.0f);
            matrixStackIn.m_85841_(1.1f, 1.1f, 1.1f);
            matrixStackIn.m_85837_(-0.5, 0.0, -0.5);
            BlockState blockstate = entityIn.isCharged() ? ((Block)CSBlockRegistry.STATIC_CLOUD.get()).m_49966_() : ((Block)CSBlockRegistry.CLOUD.get()).m_49966_();
            Minecraft.m_91087_().m_91289_().m_110912_(blockstate, matrixStackIn, bufferIn, packedLightIn, OverlayTexture.f_118083_);
            matrixStackIn.m_85849_();
        }
        super.m_7392_((Entity)entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
    }
}

