/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe668.cloudstorage.client.render;

import com.github.alexthe668.cloudstorage.client.model.CloudBlowerBackpackModel;
import com.github.alexthe668.cloudstorage.client.render.StringRenderHelper;
import com.github.alexthe668.cloudstorage.item.CSItemRegistry;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4fc;
import org.joml.Vector4f;

public class CloudBlowerBackpackLayer<T extends LivingEntity, M extends EntityModel<T>>
extends RenderLayer<T, M> {
    private static final CloudBlowerBackpackModel CLOUD_BLOWER_BACKPACK_MODEL = new CloudBlowerBackpackModel();
    public static final ResourceLocation CLOUD_BLOWER_BACKPACK_TEXTURE = new ResourceLocation("cloudstorage:textures/entity/cloud_blower_backpack.png");

    public CloudBlowerBackpackLayer(RenderLayerParent<T, M> renderLayerParent) {
        super(renderLayerParent);
    }

    public void render(PoseStack poseStack, MultiBufferSource multiBufferSource, int packedLight, T entity, float f1, float f2, float f3, float f4, float f5, float f6) {
        Player player;
        if (entity instanceof Player && ((player = (Player)entity).m_21205_().m_150930_((Item)CSItemRegistry.CLOUD_BLOWER.get()) || player.m_21206_().m_150930_((Item)CSItemRegistry.CLOUD_BLOWER.get()))) {
            Vector4f bodyOffsetVec;
            PoseStack bodyStack;
            Vector4f armOffsetVec;
            EntityModel armStack;
            HumanoidModel humanoidModel;
            ItemStack itemStack = player.m_21205_().m_150930_((Item)CSItemRegistry.CLOUD_BLOWER.get()) ? player.m_21205_() : player.m_21206_();
            VertexConsumer vertexconsumer = ItemRenderer.m_115184_((MultiBufferSource)multiBufferSource, (RenderType)RenderType.m_110431_((ResourceLocation)CLOUD_BLOWER_BACKPACK_TEXTURE), (boolean)false, (boolean)itemStack.m_41790_());
            Vec3 body = Vec3.f_82478_;
            poseStack.m_85836_();
            EntityModel entityModel = this.m_117386_();
            if (entityModel instanceof HumanoidModel) {
                HumanoidModel humanoidModel2 = (HumanoidModel)entityModel;
                humanoidModel2.f_102810_.m_104299_(poseStack);
            }
            poseStack.m_252880_(0.0f, -0.75f, 0.45f);
            poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
            CLOUD_BLOWER_BACKPACK_MODEL.resetToDefaultPose();
            CLOUD_BLOWER_BACKPACK_MODEL.m_7695_(poseStack, vertexconsumer, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            poseStack.m_85849_();
            if (this.isRightHand((LivingEntity)entity)) {
                poseStack.m_85836_();
                Vec3 rightHandPos = Vec3.f_82478_;
                EntityModel entityModel2 = this.m_117386_();
                if (entityModel2 instanceof HumanoidModel) {
                    humanoidModel = (HumanoidModel)entityModel2;
                    armStack = new PoseStack();
                    armStack.m_85836_();
                    humanoidModel.f_102811_.m_104299_((PoseStack)armStack);
                    armOffsetVec = new Vector4f(-0.05f, 0.6f, 0.0f, 1.0f);
                    armOffsetVec.mul((Matrix4fc)armStack.m_85850_().m_252922_());
                    rightHandPos = new Vec3((double)armOffsetVec.x(), (double)armOffsetVec.y(), (double)armOffsetVec.z());
                    armStack.m_85849_();
                    bodyStack = new PoseStack();
                    humanoidModel.f_102810_.m_104299_(bodyStack);
                    bodyOffsetVec = new Vector4f(-0.2f, 0.6f, 0.4f, 1.0f);
                    bodyOffsetVec.mul((Matrix4fc)bodyStack.m_85850_().m_252922_());
                    body = new Vec3((double)bodyOffsetVec.x(), (double)bodyOffsetVec.y(), (double)bodyOffsetVec.z());
                    bodyStack.m_85849_();
                }
                poseStack.m_85849_();
                StringRenderHelper.renderWire((Entity)player, body, f3, poseStack, multiBufferSource, rightHandPos, 3.0f, packedLight);
            }
            if (this.isLeftHand((LivingEntity)entity)) {
                poseStack.m_85836_();
                Vec3 leftHandPos = Vec3.f_82478_;
                armStack = this.m_117386_();
                if (armStack instanceof HumanoidModel) {
                    humanoidModel = (HumanoidModel)armStack;
                    armStack = new PoseStack();
                    armStack.m_85836_();
                    humanoidModel.f_102812_.m_104299_((PoseStack)armStack);
                    armOffsetVec = new Vector4f(0.05f, 0.6f, 0.0f, 1.0f);
                    armOffsetVec.mul((Matrix4fc)armStack.m_85850_().m_252922_());
                    leftHandPos = new Vec3((double)armOffsetVec.x(), (double)armOffsetVec.y(), (double)armOffsetVec.z());
                    armStack.m_85849_();
                    bodyStack = new PoseStack();
                    humanoidModel.f_102810_.m_104299_(bodyStack);
                    bodyOffsetVec = new Vector4f(0.2f, 0.6f, 0.4f, 1.0f);
                    bodyOffsetVec.mul((Matrix4fc)bodyStack.m_85850_().m_252922_());
                    body = new Vec3((double)bodyOffsetVec.x(), (double)bodyOffsetVec.y(), (double)bodyOffsetVec.z());
                    bodyStack.m_85849_();
                }
                poseStack.m_85849_();
                StringRenderHelper.renderWire((Entity)player, leftHandPos, f3, poseStack, multiBufferSource, body, 1.0f, packedLight);
            }
        }
    }

    public boolean isLeftHand(LivingEntity entity) {
        boolean leftHand = false;
        if (entity.m_21120_(InteractionHand.MAIN_HAND).m_150930_((Item)CSItemRegistry.CLOUD_BLOWER.get())) {
            boolean bl = leftHand = leftHand || entity.m_5737_() == HumanoidArm.LEFT;
        }
        if (entity.m_21120_(InteractionHand.OFF_HAND).m_150930_((Item)CSItemRegistry.CLOUD_BLOWER.get())) {
            leftHand = leftHand || entity.m_5737_() != HumanoidArm.LEFT;
        }
        return leftHand;
    }

    public boolean isRightHand(LivingEntity entity) {
        boolean rightHand = false;
        if (entity.m_21120_(InteractionHand.MAIN_HAND).m_150930_((Item)CSItemRegistry.CLOUD_BLOWER.get())) {
            boolean bl = rightHand = rightHand || entity.m_5737_() == HumanoidArm.RIGHT;
        }
        if (entity.m_21120_(InteractionHand.OFF_HAND).m_150930_((Item)CSItemRegistry.CLOUD_BLOWER.get())) {
            rightHand = rightHand || entity.m_5737_() != HumanoidArm.RIGHT;
        }
        return rightHand;
    }
}

