/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe668.cloudstorage.client.render;

import com.github.alexthe666.citadel.client.render.LightningBoltData;
import com.github.alexthe666.citadel.client.render.LightningRender;
import com.github.alexthe668.cloudstorage.block.CSBlockRegistry;
import com.github.alexthe668.cloudstorage.client.model.BalloonModel;
import com.github.alexthe668.cloudstorage.client.model.BloviatorModel;
import com.github.alexthe668.cloudstorage.client.model.CloudBlowerNozzleModel;
import com.github.alexthe668.cloudstorage.client.model.CloudChestModel;
import com.github.alexthe668.cloudstorage.client.particle.CSParticleRegistry;
import com.github.alexthe668.cloudstorage.client.render.BalloonTextures;
import com.github.alexthe668.cloudstorage.client.render.StringRenderHelper;
import com.github.alexthe668.cloudstorage.entity.BalloonFace;
import com.github.alexthe668.cloudstorage.item.BalloonBuddyItem;
import com.github.alexthe668.cloudstorage.item.BalloonItem;
import com.github.alexthe668.cloudstorage.item.CSItemRegistry;
import com.github.alexthe668.cloudstorage.item.CloudBlowerItem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.Random;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.ForgeRenderTypes;
import org.joml.Vector4f;

public class CSItemRenderer
extends BlockEntityWithoutLevelRenderer {
    public static final ResourceLocation CLOUD_CHEST_TEXTURE = new ResourceLocation("cloudstorage:textures/entity/cloud_chest.png");
    public static final ResourceLocation CLOUD_CHEST_LIGHTNING_TEXTURE = new ResourceLocation("cloudstorage:textures/entity/cloud_chest_static.png");
    public static final ResourceLocation BLOVIATOR_TEXTURE = new ResourceLocation("cloudstorage:textures/entity/bloviator/bloviator.png");
    public static final ResourceLocation CLOUD_BLOWER_NOZZLE_TEXTURE = new ResourceLocation("cloudstorage:textures/entity/cloud_blower_nozzle.png");
    private static final BalloonModel BALLOON_MODEL = new BalloonModel();
    private static final CloudChestModel CLOUD_CHEST_MODEL = new CloudChestModel();
    private static final BloviatorModel BLOVIATOR_MODEL = new BloviatorModel(5);
    private static final CloudBlowerNozzleModel CLOUD_BLOWER_NOZZLE_MODEL = new CloudBlowerNozzleModel();
    private static Vec3 lightningZapPos = Vec3.f_82478_;
    private static final Random random = new Random();
    private static int tickForRender = 0;
    private static float ageInTicks = 0.0f;
    private static int changeFaceTime = 0;
    private static BalloonFace cyclingBalloonFace = BalloonFace.HAPPY;
    private final LightningRender lightningRender = new LightningRender();
    private final LightningBoltData.BoltRenderInfo lightningBoltData = new LightningBoltData.BoltRenderInfo(0.5f, 0.1f, 0.5f, 0.85f, new Vector4f(0.1f, 0.3f, 0.3f, 1.0f), 0.1f);

    public CSItemRenderer() {
        super(null, null);
    }

    public static void incrementRenderTick() {
        ++tickForRender;
        if (changeFaceTime-- <= 0) {
            changeFaceTime = 40;
            int nextOrdinal = cyclingBalloonFace.ordinal() + 1;
            cyclingBalloonFace = nextOrdinal < BalloonFace.values().length ? BalloonFace.values()[nextOrdinal] : BalloonFace.HAPPY;
        }
    }

    public static void renderBalloonStatic(LivingEntity player, ItemStack balloon, boolean leftHanded) {
        float f3;
        double d6;
        double d5;
        double d4;
        int i = leftHanded ? -1 : 1;
        float f = player.m_21324_(1.0f);
        float f1 = Mth.m_14031_((float)(Mth.m_14116_((float)f) * (float)Math.PI));
        float f2 = player.f_20883_ * ((float)Math.PI / 180);
        double d0 = Mth.m_14031_((float)f2);
        double d1 = Mth.m_14089_((float)f2);
        double d2 = (double)i * 0.35;
        float ageInTicksOffset = player.f_19797_;
        Vec3 swingVec = new Vec3(Math.sin(ageInTicksOffset * 0.1f) * (double)0.2f, Math.cos(ageInTicksOffset * 0.1f + 2.0f) * (double)0.3f, Math.cos(ageInTicksOffset * 0.1f) * (double)0.2f);
        if ((Minecraft.m_91087_().m_91290_().f_114360_ == null || Minecraft.m_91087_().m_91290_().f_114360_.m_92176_().m_90612_()) && player == Minecraft.m_91087_().f_91074_) {
            double d7 = 960.0 / (double)((Integer)Minecraft.m_91087_().m_91290_().f_114360_.m_231837_().m_231551_()).intValue();
            Vec3 vec3 = Minecraft.m_91087_().m_91290_().f_114358_.m_167684_().m_167695_((float)i * 0.525f, -0.1f);
            vec3 = vec3.m_82490_(d7);
            vec3 = vec3.m_82524_(f1 * 0.5f);
            vec3 = vec3.m_82496_(-f1 * 0.7f);
            d4 = player.m_20185_() + vec3.f_82479_;
            d5 = player.m_20186_() + vec3.f_82480_;
            d6 = player.m_20189_() + vec3.f_82481_;
            f3 = player.m_20192_();
        } else {
            d4 = player.m_20185_() - d1 * d2 - d0 * 0.8;
            d5 = (double)player.m_20192_() + player.m_20186_() - 0.45;
            d6 = player.m_20189_() - d0 * d2 + d1 * 0.8;
            f3 = player.m_6047_() ? -0.1875f : 0.0f;
        }
        float f4 = (random.nextFloat() - 0.5f) * 0.5f;
        float f5 = (random.nextFloat() - 0.5f) * 0.5f;
        float f6 = (random.nextFloat() - 0.5f) * 0.5f;
        float f7 = 1.2f;
        player.m_9236_().m_7106_((ParticleOptions)CSParticleRegistry.STATIC_LIGHTNING.get(), d4 - swingVec.f_82479_ + (double)f4, d5 + (double)f7 + (double)f3 - swingVec.f_82480_ + (double)f5, d6 - swingVec.f_82481_ + (double)f5, (double)(f4 * 0.5f), (double)(f5 * 0.5f), (double)(f6 * 0.5f));
    }

    public void m_108829_(ItemStack itemStackIn, ItemDisplayContext transformType, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        float partialTick = Minecraft.m_91087_().m_91296_();
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (!Minecraft.m_91087_().m_91104_() && Minecraft.m_91087_().f_91074_ != null) {
            tickForRender = Minecraft.m_91087_().f_91074_.f_19797_;
            ageInTicks = (float)tickForRender + partialTick;
        }
        if (Util.m_137550_() % 100L == 0L) {
            Vec3 raw = new Vec3((double)(random.nextFloat() - 0.5f), (double)(random.nextFloat() - 0.5f), (double)(random.nextFloat() - 0.5f));
            lightningZapPos = raw.m_82541_().m_82490_(5.0);
        }
        if (itemStackIn.m_41720_() instanceof BalloonItem) {
            matrixStackIn.m_252880_(0.5f, 0.5f, 0.5f);
            if (BalloonItem.get3DRender(itemStackIn) != 0 || transformType == ItemDisplayContext.THIRD_PERSON_LEFT_HAND || transformType == ItemDisplayContext.THIRD_PERSON_RIGHT_HAND || transformType == ItemDisplayContext.FIRST_PERSON_RIGHT_HAND || transformType == ItemDisplayContext.FIRST_PERSON_LEFT_HAND) {
                int colorIn = ((DyeableLeatherItem)itemStackIn.m_41720_()).m_41121_(itemStackIn);
                int color = colorIn < 0 ? CSItemRenderer.getRainbowBalloonColor() : colorIn;
                float r = (float)(color >> 16 & 0xFF) / 255.0f;
                float g = (float)(color >> 8 & 0xFF) / 255.0f;
                float b = (float)(color & 0xFF) / 255.0f;
                Vec3 swingVec = new Vec3(Math.sin(ageInTicks * 0.1f) * (double)0.2f, Math.cos(ageInTicks * 0.1f + 2.0f) * (double)0.3f, Math.cos(ageInTicks * 0.1f) * (double)0.2f);
                Vec3 to = new Vec3(0.0, 2.0, 0.0);
                BALLOON_MODEL.setColor(r, g, b);
                if (transformType == ItemDisplayContext.GUI) {
                    if (BalloonItem.get3DRender(itemStackIn) == 1) {
                        matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(-135.0f));
                        matrixStackIn.m_252781_(Axis.f_252529_.m_252977_(-15.0f));
                        matrixStackIn.m_252880_(0.0f, -0.9f, 0.0f);
                        swingVec = swingVec.m_82490_((double)0.2f);
                        to = to.m_82490_((double)0.8f);
                    } else {
                        matrixStackIn.m_252781_(Axis.f_252529_.m_252977_(15.0f));
                        matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(-135.0f));
                        matrixStackIn.m_252880_(0.0f, -0.9f, 0.0f);
                        swingVec = swingVec.m_82490_((double)0.2f);
                        to = to.m_82490_(1.0);
                    }
                }
                Vec3 from = new Vec3(swingVec.f_82479_, (double)1.3f + swingVec.f_82480_, swingVec.f_82481_);
                matrixStackIn.m_85836_();
                matrixStackIn.m_252781_(Axis.f_252529_.m_252977_(-180.0f));
                matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(180.0f));
                matrixStackIn.m_252880_(0.0f, -2.0f, 0.0f);
                StringRenderHelper.renderSting((Entity)Minecraft.m_91087_().f_91074_, from, partialTick, matrixStackIn, bufferIn, to, combinedLightIn);
                matrixStackIn.m_85837_(swingVec.f_82479_, swingVec.f_82480_, swingVec.f_82481_);
                BALLOON_MODEL.m_7695_(matrixStackIn, bufferIn.m_6299_(RenderType.m_110458_((ResourceLocation)BalloonTextures.BALLOON)), combinedLightIn, combinedOverlayIn, 1.0f, 1.0f, 1.0f, 1.0f);
                if (itemStackIn.m_150930_((Item)CSItemRegistry.BALLOON_BUDDY.get())) {
                    BalloonFace face = BalloonBuddyItem.getPersonality(itemStackIn);
                    if (face == null) {
                        face = cyclingBalloonFace;
                    }
                    if (face != null) {
                        BALLOON_MODEL.m_7695_(matrixStackIn, bufferIn.m_6299_(RenderType.m_110458_((ResourceLocation)BalloonTextures.getTextureForFace(face))), combinedLightIn, combinedOverlayIn, 1.0f, 1.0f, 1.0f, 0.75f);
                    }
                }
                BALLOON_MODEL.setColor(1.0f, 1.0f, 1.0f);
                BALLOON_MODEL.m_7695_(matrixStackIn, bufferIn.m_6299_(RenderType.m_110458_((ResourceLocation)BalloonTextures.STRING_TIE)), combinedLightIn, combinedOverlayIn, 1.0f, 1.0f, 1.0f, 1.0f);
                BALLOON_MODEL.m_7695_(matrixStackIn, bufferIn.m_6299_(RenderType.m_110473_((ResourceLocation)BalloonTextures.BALLOON_SHEEN)), combinedLightIn, combinedOverlayIn, 1.0f, 1.0f, 1.0f, 0.75f);
                if (BalloonItem.isLoot(itemStackIn)) {
                    BALLOON_MODEL.m_7695_(matrixStackIn, bufferIn.m_6299_(RenderType.m_110458_((ResourceLocation)BalloonTextures.LOOT)), combinedLightIn, combinedOverlayIn, 1.0f, 1.0f, 1.0f, 1.0f);
                }
                matrixStackIn.m_85849_();
            } else {
                ItemStack copyColorData = new ItemStack(itemStackIn.m_150930_((Item)CSItemRegistry.BALLOON_BUDDY.get()) ? (ItemLike)CSItemRegistry.BALLOON_BUDDY_INVENTORY.get() : (ItemLike)CSItemRegistry.BALLOON_INVENTORY.get());
                copyColorData.m_41751_(itemStackIn.m_41783_());
                Minecraft.m_91087_().m_91291_().m_269128_(copyColorData, transformType, combinedLightIn, combinedOverlayIn, matrixStackIn, bufferIn, (Level)level, 0);
            }
        }
        if (itemStackIn.m_150930_(((Block)CSBlockRegistry.CLOUD_CHEST.get()).m_5456_())) {
            CompoundTag tag = itemStackIn.m_41783_();
            if (tag != null && tag.m_128471_("MobRender")) {
                matrixStackIn.m_85836_();
                matrixStackIn.m_252880_(0.5f, 1.5f, 0.5f);
                matrixStackIn.m_252781_(Axis.f_252529_.m_252977_(-180.0f));
                matrixStackIn.m_252880_(0.3f, 0.7f, 0.0f);
                matrixStackIn.m_85841_(0.55f, 0.55f, 0.55f);
                BLOVIATOR_MODEL.resetToDefaultPose();
                BLOVIATOR_MODEL.m_7695_(matrixStackIn, bufferIn.m_6299_(RenderType.m_110473_((ResourceLocation)BLOVIATOR_TEXTURE)), combinedLightIn, combinedOverlayIn, 1.0f, 1.0f, 1.0f, 1.0f);
                matrixStackIn.m_85849_();
            } else {
                matrixStackIn.m_85836_();
                matrixStackIn.m_252880_(0.5f, 1.5f, 0.5f);
                matrixStackIn.m_252781_(Axis.f_252529_.m_252977_(-180.0f));
                CLOUD_CHEST_MODEL.resetToDefaultPose();
                CLOUD_CHEST_MODEL.m_7695_(matrixStackIn, bufferIn.m_6299_(RenderType.m_110473_((ResourceLocation)CLOUD_CHEST_TEXTURE)), combinedLightIn, combinedOverlayIn, 1.0f, 1.0f, 1.0f, 1.0f);
                matrixStackIn.m_85849_();
            }
        }
        if (itemStackIn.m_150930_(((Block)CSBlockRegistry.STATIC_CLOUD_CHEST.get()).m_5456_())) {
            matrixStackIn.m_85836_();
            matrixStackIn.m_252880_(0.5f, 1.5f, 0.5f);
            matrixStackIn.m_252781_(Axis.f_252529_.m_252977_(-180.0f));
            CLOUD_CHEST_MODEL.resetToDefaultPose();
            CLOUD_CHEST_MODEL.m_7695_(matrixStackIn, bufferIn.m_6299_(RenderType.m_110473_((ResourceLocation)CLOUD_CHEST_TEXTURE)), combinedLightIn, combinedOverlayIn, 1.0f, 1.0f, 1.0f, 1.0f);
            CLOUD_CHEST_MODEL.m_7695_(matrixStackIn, bufferIn.m_6299_(ForgeRenderTypes.getUnlitTranslucent((ResourceLocation)CLOUD_CHEST_LIGHTNING_TEXTURE)), 240, combinedOverlayIn, 1.0f, 1.0f, 1.0f, 1.0f);
            matrixStackIn.m_85849_();
        }
        if (itemStackIn.m_150930_((Item)CSItemRegistry.CLOUD_BLOWER.get())) {
            if (transformType == ItemDisplayContext.THIRD_PERSON_LEFT_HAND || transformType == ItemDisplayContext.THIRD_PERSON_RIGHT_HAND || transformType == ItemDisplayContext.FIRST_PERSON_RIGHT_HAND || transformType == ItemDisplayContext.FIRST_PERSON_LEFT_HAND) {
                matrixStackIn.m_85836_();
                matrixStackIn.m_252880_(0.45f, 1.8f, 0.5f);
                matrixStackIn.m_252781_(Axis.f_252529_.m_252977_(-180.0f));
                matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(-180.0f));
                float useTime = CloudBlowerItem.getLerpedUseTime(itemStackIn, partialTick);
                float leverForwards = CloudBlowerItem.getMode(itemStackIn);
                CLOUD_BLOWER_NOZZLE_MODEL.animateInHand(useTime, leverForwards, transformType);
                CLOUD_BLOWER_NOZZLE_MODEL.m_7695_(matrixStackIn, bufferIn.m_6299_(RenderType.m_110458_((ResourceLocation)CLOUD_BLOWER_NOZZLE_TEXTURE)), combinedLightIn, combinedOverlayIn, 1.0f, 1.0f, 1.0f, 1.0f);
                if (useTime > 5.0f) {
                    Vec3 beam = new Vec3(0.0, 0.0, 3.0);
                    matrixStackIn.m_85836_();
                    if (transformType.m_269069_()) {
                        matrixStackIn.m_252880_(0.0f, 1.1f, -0.4f);
                    } else {
                        matrixStackIn.m_252781_(Axis.f_252529_.m_252977_(-20.0f));
                        matrixStackIn.m_252880_(0.0f, 1.3f, -0.1f);
                    }
                    float intensity = leverForwards == 1.0f ? -1.0f : 1.0f;
                    StringRenderHelper.renderCloudBlowerBeam((float)beam.f_82479_, (float)beam.f_82480_, (float)beam.f_82481_, partialTick, CloudBlowerItem.getUseTime(itemStackIn), matrixStackIn, bufferIn, combinedLightIn, intensity, 1.0f, false);
                    matrixStackIn.m_85849_();
                }
                matrixStackIn.m_85849_();
            } else {
                matrixStackIn.m_85836_();
                matrixStackIn.m_252880_(0.5f, 0.5f, 0.5f);
                ItemStack cloudBlower = new ItemStack((ItemLike)CSItemRegistry.CLOUD_BLOWER_INVENTORY.get());
                Minecraft.m_91087_().m_91291_().m_269128_(cloudBlower, transformType, combinedLightIn, combinedOverlayIn, matrixStackIn, bufferIn, (Level)level, 0);
                matrixStackIn.m_85849_();
            }
        }
    }

    public static int getRainbowBalloonColor() {
        return (int)(ageInTicks % 1.6777215E7f);
    }
}

