/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe668.cloudstorage.client.model;

import com.github.alexthe666.citadel.client.model.AdvancedEntityModel;
import com.github.alexthe666.citadel.client.model.AdvancedModelBox;
import com.github.alexthe666.citadel.client.model.basic.BasicModelPart;
import com.github.alexthe668.cloudstorage.entity.BalloonEntity;
import com.github.alexthe668.cloudstorage.entity.BalloonFace;
import com.github.alexthe668.cloudstorage.entity.LivingBalloon;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4fc;
import org.joml.Vector4f;

public class BalloonModel<T extends Entity>
extends AdvancedEntityModel<T> {
    private final AdvancedModelBox root;
    private final AdvancedModelBox balloon;
    private final AdvancedModelBox face;
    private final AdvancedModelBox tie;
    private final AdvancedModelBox below;
    private float r = 1.0f;
    private float g = 1.0f;
    private float b = 1.0f;
    private float a = 1.0f;

    public BalloonModel() {
        this.texWidth = 64;
        this.texHeight = 64;
        this.root = new AdvancedModelBox((AdvancedEntityModel)this, "root");
        this.root.setPos(0.0f, 24.0f, 0.0f);
        this.balloon = new AdvancedModelBox((AdvancedEntityModel)this, "balloon");
        this.balloon.setPos(0.0f, 0.0f, 0.0f);
        this.root.addChild((BasicModelPart)this.balloon);
        this.balloon.setTextureOffset(0, 0).addBox(-5.0f, -15.0f, -5.0f, 10.0f, 10.0f, 10.0f, 0.0f, false);
        this.face = new AdvancedModelBox((AdvancedEntityModel)this, "face");
        this.face.setPos(0.0f, 0.0f, 0.0f);
        this.balloon.addChild((BasicModelPart)this.face);
        this.face.setTextureOffset(16, 20).addBox(-5.0f, -15.0f, -6.0f, 10.0f, 10.0f, 0.0f, 0.0f, false);
        this.tie = new AdvancedModelBox((AdvancedEntityModel)this, "tie");
        this.tie.setPos(0.0f, 0.0f, 0.0f);
        this.balloon.addChild((BasicModelPart)this.tie);
        this.tie.setTextureOffset(0, 0).addBox(-1.0f, -5.0f, -1.0f, 2.0f, 1.0f, 2.0f, 0.0f, false);
        this.below = new AdvancedModelBox((AdvancedEntityModel)this, "below");
        this.below.setPos(0.0f, 0.0f, 0.0f);
        this.tie.addChild((BasicModelPart)this.below);
        this.below.setTextureOffset(0, 20).addBox(-2.0f, -4.0f, -2.0f, 4.0f, 2.0f, 4.0f, 0.0f, false);
        this.balloon.setShouldScaleChildren(true);
        this.updateDefaultPose();
    }

    public Iterable<BasicModelPart> parts() {
        return ImmutableList.of((Object)this.root);
    }

    public Iterable<AdvancedModelBox> getAllParts() {
        return ImmutableList.of((Object)this.root, (Object)this.balloon, (Object)this.face, (Object)this.tie, (Object)this.below);
    }

    public void m_6973_(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.resetToDefaultPose();
        float popProgress = 0.0f;
        if (entity instanceof LivingBalloon) {
            LivingBalloon badloon = (LivingBalloon)entity;
            float ability = badloon.getAbilityProgress(ageInTicks - (float)((Entity)entity).f_19797_);
            if (badloon.getFace() == BalloonFace.ANGRY) {
                this.face.rotationPointY = (float)((double)this.face.rotationPointY + Math.cos(ageInTicks * 0.6f) * (double)0.7f);
            } else if (badloon.getFace() == BalloonFace.SCARED) {
                this.face.rotationPointX = (float)((double)this.face.rotationPointX + Math.sin(ageInTicks) * 2.0);
            } else if (badloon.getFace() == BalloonFace.SCARY) {
                this.face.rotationPointX = (float)((double)this.face.rotationPointX + Math.sin(ageInTicks) * 2.0 * (double)ability);
            } else if (badloon.getFace() == BalloonFace.CRAZY) {
                this.face.rotationPointX = (float)((double)this.face.rotationPointX + Math.sin(ageInTicks) * 0.5);
                this.face.rotationPointY = (float)((double)this.face.rotationPointY + Math.cos(ageInTicks) * 0.5);
            } else {
                this.face.rotationPointZ = (float)((double)this.face.rotationPointZ + Math.sin(ageInTicks * 0.3f) * 0.25);
            }
            popProgress = badloon.getPopProgress(ageInTicks - (float)((Entity)entity).f_19797_);
        }
        if (entity instanceof BalloonEntity) {
            BalloonEntity balloon = (BalloonEntity)((Object)entity);
            popProgress = balloon.getPopProgress(ageInTicks - (float)((Entity)entity).f_19797_);
        }
        float popScale = 1.0f + popProgress * 1.7f;
        this.balloon.setScale(popScale, popScale, popScale);
        this.face.setScale(1.0f / popScale, 1.0f / popScale, 1.0f / popScale);
        this.balloon.rotationPointY += popProgress * 17.0f;
        this.face.rotationPointZ -= popProgress * 3.0f;
        this.face.rotationPointY -= popProgress * 5.0f;
    }

    public void setColor(float r, float g, float b) {
        this.r = r;
        this.g = g;
        this.b = b;
        this.a = 1.0f;
    }

    public Vec3 translateToBottom(Vec3 in) {
        PoseStack modelTranslateStack = new PoseStack();
        this.root.translateAndRotate(modelTranslateStack);
        this.balloon.translateAndRotate(modelTranslateStack);
        this.tie.translateAndRotate(modelTranslateStack);
        this.below.translateAndRotate(modelTranslateStack);
        Vector4f bodyOffsetVec = new Vector4f((float)in.f_82479_, (float)in.f_82480_, (float)in.f_82481_, 1.0f);
        bodyOffsetVec.mul((Matrix4fc)modelTranslateStack.m_85850_().m_252922_());
        Vec3 offset = new Vec3((double)bodyOffsetVec.x(), (double)bodyOffsetVec.y(), (double)bodyOffsetVec.z());
        modelTranslateStack.m_85849_();
        return offset.m_82520_(0.0, -1.5, 0.0);
    }

    public void setAlpha(float a) {
        this.a = a;
    }

    public void m_7695_(PoseStack p_170506_, VertexConsumer p_170507_, int p_170508_, int p_170509_, float p_170510_, float p_170511_, float p_170512_, float p_170513_) {
        super.m_7695_(p_170506_, p_170507_, p_170508_, p_170509_, this.r * p_170510_, this.g * p_170511_, this.b * p_170512_, this.a * p_170513_);
    }
}

