/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe668.cloudstorage.block;

import com.github.alexthe668.cloudstorage.CloudStorage;
import com.github.alexthe668.cloudstorage.block.AbstractCloudChestBlockEntity;
import com.github.alexthe668.cloudstorage.block.CSBlockEntityRegistry;
import com.github.alexthe668.cloudstorage.block.CloudChestBlockEntity;
import com.github.alexthe668.cloudstorage.block.StaticCloudChestBlockEntity;
import com.github.alexthe668.cloudstorage.client.particle.CSParticleRegistry;
import com.github.alexthe668.cloudstorage.network.MessageOpenCloudChest;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class CloudChestBlock
extends BaseEntityBlock {
    public static final DirectionProperty HORIZONTAL_FACING = HorizontalDirectionalBlock.f_54117_;
    protected static final VoxelShape AABB = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0);
    private final boolean lightning;

    public CloudChestBlock(boolean lightning) {
        super(BlockBehaviour.Properties.m_284310_().m_278166_(PushReaction.BLOCK).m_284180_(MapColor.f_283869_).m_60955_().m_60918_(SoundType.f_56745_).m_60978_(1.5f));
        this.lightning = lightning;
    }

    public VoxelShape m_5940_(BlockState p_51569_, BlockGetter p_51570_, BlockPos p_51571_, CollisionContext p_51572_) {
        return AABB;
    }

    public BlockState m_6843_(BlockState p_185499_1_, Rotation p_185499_2_) {
        return (BlockState)p_185499_1_.m_61124_((Property)HORIZONTAL_FACING, (Comparable)p_185499_2_.m_55954_((Direction)p_185499_1_.m_61143_((Property)HORIZONTAL_FACING)));
    }

    public BlockState m_6943_(BlockState p_185471_1_, Mirror p_185471_2_) {
        return p_185471_1_.m_60717_(p_185471_2_.m_54846_((Direction)p_185471_1_.m_61143_((Property)HORIZONTAL_FACING)));
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)HORIZONTAL_FACING, (Comparable)context.m_8125_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{HORIZONTAL_FACING});
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean m_6104_(BlockState p_200122_1_, BlockState p_200122_2_, Direction p_200122_3_) {
        return p_200122_2_.m_60734_() == this || super.m_6104_(p_200122_1_, p_200122_2_, p_200122_3_);
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        ItemStack heldItem = player.m_21120_(handIn);
        BlockEntity blockEntity = worldIn.m_7702_(pos);
        if (blockEntity instanceof AbstractCloudChestBlockEntity) {
            AbstractCloudChestBlockEntity chest = (AbstractCloudChestBlockEntity)blockEntity;
            if (!chest.hasClearance()) {
                player.m_5661_((Component)Component.m_237115_((String)"message.cloudstorage.no_sky_access").m_130940_(ChatFormatting.RED), true);
                return InteractionResult.PASS;
            }
            if (!chest.hasBalloonFor(player)) {
                player.m_5661_((Component)Component.m_237115_((String)"message.cloudstorage.no_balloon").m_130940_(ChatFormatting.RED), true);
                return InteractionResult.PASS;
            }
            if (worldIn.f_46443_) {
                return InteractionResult.SUCCESS;
            }
            CloudStorage.sendMSGToAll(new MessageOpenCloudChest(chest.getContainerSize(player)));
            if (chest.hasNoInvSpace(player)) {
                player.m_5661_((Component)Component.m_237115_((String)"message.cloudstorage.no_inventory_space").m_130940_(ChatFormatting.RED), true);
            } else {
                MenuProvider menuprovider = chest.getMenuProvider();
                if (menuprovider != null) {
                    player.m_5893_(menuprovider);
                }
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity blockEntity = worldIn.m_7702_(pos);
        if (blockEntity instanceof AbstractCloudChestBlockEntity) {
            AbstractCloudChestBlockEntity cloudChest = (AbstractCloudChestBlockEntity)blockEntity;
            cloudChest.releaseBalloons();
        }
        super.m_6810_(state, worldIn, pos, newState, isMoving);
    }

    public RenderShape m_7514_(BlockState p_149645_1_) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return this.lightning ? new StaticCloudChestBlockEntity(pos, state) : new CloudChestBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level p_152180_, BlockState p_152181_, BlockEntityType<T> p_152182_) {
        if (this.lightning) {
            return CloudChestBlock.m_152132_(p_152182_, (BlockEntityType)((BlockEntityType)CSBlockEntityRegistry.STATIC_CLOUD_CHEST.get()), AbstractCloudChestBlockEntity::commonTick);
        }
        return CloudChestBlock.m_152132_(p_152182_, (BlockEntityType)((BlockEntityType)CSBlockEntityRegistry.CLOUD_CHEST.get()), AbstractCloudChestBlockEntity::commonTick);
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource rng) {
        if (this.lightning && rng.m_188503_(1) == 0) {
            Direction direction = Direction.m_235672_((RandomSource)rng);
            BlockPos blockpos = pos.m_121945_(direction);
            BlockState blockstate = level.m_8055_(blockpos);
            if (!state.m_60815_() || !blockstate.m_60783_((BlockGetter)level, blockpos, direction.m_122424_())) {
                double d0 = direction.m_122429_() == 0 ? rng.m_188500_() - 0.5 : (double)direction.m_122429_() * 0.3;
                double d1 = direction.m_122430_() == 0 ? rng.m_188500_() - 0.5 : (double)direction.m_122430_() * 0.3;
                double d2 = direction.m_122431_() == 0 ? rng.m_188500_() - 0.5 : (double)direction.m_122431_() * 0.3;
                double length = 0.3 + (double)rng.m_188501_() * 0.3;
                double d3 = d0 * length;
                double d4 = d1 * length;
                double d5 = d2 * length;
                level.m_7106_((ParticleOptions)CSParticleRegistry.STATIC_LIGHTNING.get(), (double)pos.m_123341_() + 0.5 + d0, (double)pos.m_123342_() + 0.5 + d1, (double)pos.m_123343_() + 0.5 + d2, d3, d4, d5);
            }
        }
    }
}

