/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe668.cloudstorage.block;

import com.github.alexthe668.cloudstorage.CloudStorage;
import com.github.alexthe668.cloudstorage.client.particle.CSParticleRegistry;
import com.github.alexthe668.cloudstorage.item.CSItemRegistry;
import com.github.alexthe668.cloudstorage.misc.CSSoundRegistry;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public abstract class AbstractCloudChestBlockEntity
extends BlockEntity {
    private float openProgress;
    private float prevOpenProgress;
    private float emergence;
    private float prevEmergence;
    public int tickCount;
    public Player lastValidPlayer = null;
    private static Random random = new Random();
    private int lastSoundTimestamp = 0;

    public AbstractCloudChestBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public static void commonTick(Level level, BlockPos pos, BlockState state, AbstractCloudChestBlockEntity e) {
        e.prevOpenProgress = e.openProgress;
        e.prevEmergence = e.emergence;
        ++e.tickCount;
        boolean open = false;
        boolean emergedBalloon = false;
        Player player = e.f_58857_.m_45924_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, ((Double)CloudStorage.CONFIG.cloudChestOpenDistance.get()).doubleValue(), false);
        if (player != null && e.hasClearance()) {
            if (e.hasBalloonFor(player)) {
                emergedBalloon = true;
                open = true;
                e.lastValidPlayer = player;
            } else if (!e.getValidBalloonStack(player).m_41619_()) {
                open = true;
            }
        }
        if (open && e.openProgress == 0.0f) {
            e.playSound(true);
        }
        if (!open && e.openProgress == 1.0f) {
            e.playSound(false);
        }
        if (open && e.openProgress < 1.0f) {
            e.openProgress = Math.min(e.openProgress + 0.1f, 1.0f);
        }
        if (open && e.openProgress >= 1.0f) {
            if (emergedBalloon && e.emergence < 1.0f) {
                e.emergence = Math.min(e.emergence + 0.1f, 1.0f);
            }
            if (!emergedBalloon && e.emergence > 0.0f) {
                e.emergence = Math.max(e.emergence - 0.1f, 0.0f);
            }
        }
        if (!open && e.openProgress > 0.0f) {
            if (e.emergence <= 0.0f) {
                e.openProgress = Math.max(e.openProgress - 0.1f, 0.0f);
            } else {
                e.emergence = Math.max(e.emergence - 0.1f, 0.0f);
            }
        }
        if (e.openProgress >= 1.0f && e.emergence > 0.5f && level.f_46443_) {
            float radius = 3.0f;
            Vec3 center = Vec3.m_82512_((Vec3i)e.m_58899_());
            level.m_7106_((ParticleOptions)CSParticleRegistry.CLOUD_CHEST.get(), center.f_82479_ + (double)(radius * (random.nextFloat() - 0.5f)), center.f_82480_ + (double)(radius * random.nextFloat()), center.f_82481_ + (double)(radius * (random.nextFloat() - 0.5f)), center.f_82479_, center.f_82480_ - 0.5, center.f_82481_);
        }
    }

    private void playSound(boolean open) {
        if (this.tickCount == 0 || this.lastSoundTimestamp < this.tickCount - 10) {
            this.lastSoundTimestamp = this.tickCount;
            float pitch = 0.75f + random.nextFloat() * 0.35f;
            this.f_58857_.m_5594_((Player)null, this.m_58899_(), open ? (SoundEvent)CSSoundRegistry.CLOUD_CHEST_OPEN.get() : (SoundEvent)CSSoundRegistry.CLOUD_CHEST_CLOSE.get(), SoundSource.BLOCKS, 1.0f, pitch);
            this.f_58857_.m_142346_(null, GameEvent.f_157792_, this.m_58899_());
        }
    }

    public AABB getRenderBoundingBox() {
        BlockPos pos = this.m_58899_();
        return new AABB(pos.m_7918_(-1, -1, -1), pos.m_7918_(1, 3, 1));
    }

    public boolean hasClearance() {
        BlockPos pos = this.m_58899_();
        return (this.f_58857_.m_45527_(pos) || (Boolean)CloudStorage.CONFIG.cloudChestNeedsSkyAccess.get() == false) && this.f_58857_.m_46859_(pos.m_7494_()) && this.f_58857_.m_46859_(pos.m_6630_(2));
    }

    public float getOpenProgress(float partialTick) {
        return this.prevOpenProgress + (this.openProgress - this.prevOpenProgress) * partialTick;
    }

    public float getEmergence(float partialTick) {
        return this.prevEmergence + (this.emergence - this.prevEmergence) * partialTick;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public MenuProvider getMenuProvider() {
        return new SimpleMenuProvider((id, playerInventory, textComponent) -> this.getMenu(id, playerInventory), this.getTitle());
    }

    public abstract boolean hasBalloonFor(Player var1);

    public abstract int getBalloonFor(Player var1);

    public abstract void setBalloonColorFor(Player var1, int var2);

    private ItemStack getValidBalloonStack(Player player) {
        ItemStack itemStack1 = player.m_21205_();
        ItemStack itemStack2 = player.m_21206_();
        if (itemStack1.m_150930_((Item)CSItemRegistry.BALLOON.get())) {
            return itemStack1;
        }
        if (itemStack2.m_150930_((Item)CSItemRegistry.BALLOON.get())) {
            return itemStack2;
        }
        return ItemStack.f_41583_;
    }

    public abstract AbstractContainerMenu getMenu(int var1, Inventory var2);

    public abstract Component getTitle();

    public abstract boolean hasNoInvSpace(Player var1);

    public abstract void releaseBalloons();

    public abstract int getContainerSize(Player var1);

    public void setLootBalloon(int color, ResourceLocation resourceLocation, long seed) {
    }

    public boolean hasLootBalloon() {
        return false;
    }
}

