/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_texture_features.compat;

import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Objects;
import me.jellysquid.mods.sodium.client.render.vertex.buffer.ExtendedBufferBuilder;
import me.jellysquid.mods.sodium.client.render.vertex.buffer.SodiumBufferBuilder;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import org.apache.logging.log4j.util.TriConsumer;
import traben.entity_texture_features.features.ETFRenderContext;
import traben.entity_texture_features.utils.ETFVertexConsumer;

public abstract class SodiumGetBufferInjector {
    private static final TriConsumer<MultiBufferSource, RenderType, VertexConsumer> INSTANCE = SodiumGetBufferInjector.get();

    public static void inject(MultiBufferSource provider, RenderType renderLayer, VertexConsumer vertexConsumer) {
        if (INSTANCE != null) {
            INSTANCE.accept((Object)provider, (Object)renderLayer, (Object)vertexConsumer);
        }
    }

    private static TriConsumer<MultiBufferSource, RenderType, VertexConsumer> get() {
        try {
            return new Impl();
        }
        catch (NoClassDefFoundError | NullPointerException e) {
            return null;
        }
    }

    private static class Impl
    implements TriConsumer<MultiBufferSource, RenderType, VertexConsumer> {
        Impl() {
            Objects.requireNonNull(ExtendedBufferBuilder.class);
        }

        public void accept(MultiBufferSource vertexConsumerProvider, RenderType renderLayer, VertexConsumer vertexConsumer) {
            ExtendedBufferBuilder buff;
            SodiumBufferBuilder delegate;
            if (vertexConsumer instanceof ExtendedBufferBuilder && (delegate = (buff = (ExtendedBufferBuilder)vertexConsumer).sodium$getDelegate()) instanceof ETFVertexConsumer) {
                ETFRenderContext.insertETFDataIntoVertexConsumer(vertexConsumerProvider, renderLayer, (VertexConsumer)delegate);
            }
        }
    }
}

