/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createcentralkitchen.foundation.data.loot;

import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.logging.LogUtils;
import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.util.nullness.NonNullFunction;
import com.tterrag.registrate.util.nullness.NonNullUnaryOperator;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.storage.loot.LootDataId;
import net.minecraft.world.level.storage.loot.LootDataResolver;
import net.minecraft.world.level.storage.loot.LootDataType;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraftforge.data.loading.DatagenModLoader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class BlockLootTables
implements DataProvider {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final Map<String, Map<ResourceLocation, Supplier<LootTable.Builder>>> BLOCK_LOOTS = new HashMap<String, Map<ResourceLocation, Supplier<LootTable.Builder>>>();
    private final DataGenerator generator;

    public BlockLootTables(DataGenerator generator) {
        this.generator = generator;
    }

    @NotNull
    public CompletableFuture<?> m_213708_(@NotNull CachedOutput cache) {
        Path outputFolder = this.generator.getPackOutput().m_245114_();
        return CompletableFuture.runAsync(() -> BLOCK_LOOTS.forEach((modid, suppliers) -> {
            Path datapackFolder = outputFolder.resolve("datapacks/" + modid);
            final HashMap map = Maps.newHashMap();
            suppliers.forEach((id, supplier) -> {
                if (map.put(id, ((LootTable.Builder)supplier.get()).m_79165_(LootContextParamSets.f_81421_).m_79167_()) != null) {
                    throw new IllegalStateException("Duplicate loot table " + id);
                }
            });
            ValidationContext validationContext = new ValidationContext(LootContextParamSets.f_81420_, new LootDataResolver(){

                @Nullable
                public <T> T m_278667_(@NotNull LootDataId<T> pId) {
                    return (T)(pId.f_278383_() == LootDataType.f_278413_ ? (LootTable)map.get(pId.f_278500_()) : null);
                }
            });
            map.forEach((id, lootTable) -> lootTable.m_79136_(validationContext));
            Multimap problems = validationContext.m_79352_();
            if (!problems.isEmpty()) {
                problems.forEach((key, value) -> LOGGER.warn("Found validation problem in {}: {}", key, value));
                throw new IllegalStateException("Failed to validate loot tables, see logs");
            }
            map.forEach((id, lootTable) -> {
                Path path = BlockLootTables.createPath(datapackFolder, id);
                DataProvider.m_253162_((CachedOutput)cache, (JsonElement)LootDataType.f_278413_.m_278857_().toJsonTree(lootTable), (Path)path);
            });
        }), Util.m_183991_());
    }

    private static Path createPath(Path path, ResourceLocation id) {
        return path.resolve("data/" + id.m_135827_() + "/loot_tables/" + id.m_135815_() + ".json");
    }

    public static <T extends Block, P> NonNullUnaryOperator<BlockBuilder<T, P>> add(String modId, NonNullFunction<T, LootTable.Builder> function) {
        Map map = BLOCK_LOOTS.computeIfAbsent(modId, it -> new HashMap());
        return builder -> (BlockBuilder)builder.properties(BlockLootTables::noLootGen).onRegister(block -> map.put(new ResourceLocation(builder.getOwner().getModid(), "blocks/" + builder.getName()), () -> (LootTable.Builder)function.apply(block)));
    }

    public static BlockBehaviour.Properties noLootGen(BlockBehaviour.Properties properties) {
        if (DatagenModLoader.isRunningDataGen()) {
            properties.m_222994_();
        }
        return properties;
    }

    public String m_6055_() {
        return "LootTables";
    }
}

